package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.NamedReference;
import io.ciera.tool.sql.architecture.expression.NamedReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class NamedReferenceSetImpl extends InstanceSet<NamedReferenceSet,NamedReference> implements NamedReferenceSet {

    public NamedReferenceSetImpl() {
    }

    public NamedReferenceSetImpl(Comparator<? super NamedReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setBlock_number( ref_block_number );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setName( m_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setParent_package( ref_parent_package );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setParent_name( ref_parent_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setBody_name( ref_body_name );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setExpression_number( ref_expression_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( NamedReference namedreference : this ) namedreference.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( NamedReference namedreference : this ) expressionset.add( namedreference.R776_is_a_Expression() );
        return expressionset;
    }


    @Override
    public NamedReference nullElement() {
        return NamedReferenceImpl.EMPTY_NAMEDREFERENCE;
    }

    @Override
    public NamedReferenceSet emptySet() {
      return new NamedReferenceSetImpl();
    }

    @Override
    public NamedReferenceSet emptySet(Comparator<? super NamedReference> comp) {
      return new NamedReferenceSetImpl(comp);
    }

    @Override
    public List<NamedReference> elements() {
        NamedReference[] elements = toArray(new NamedReference[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
