package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.NamedReference;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;


public class NamedReferenceImpl extends ModelInstance<NamedReference,Sql> implements NamedReference {

    public static final String KEY_LETTERS = "NamedReference";
    public static final NamedReference EMPTY_NAMEDREFERENCE = new EmptyNamedReference();

    private Sql context;

    // constructors
    private NamedReferenceImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        m_name = "";
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private NamedReferenceImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String m_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.m_name = m_name;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static NamedReference create( Sql context ) throws XtumlException {
        NamedReference newNamedReference = new NamedReferenceImpl( context );
        if ( context.addInstance( newNamedReference ) ) {
            newNamedReference.getRunContext().addChange(new InstanceCreatedDelta(newNamedReference, KEY_LETTERS));
            return newNamedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static NamedReference create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String m_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, m_name);
    }

    public static NamedReference create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String m_name ) throws XtumlException {
        NamedReference newNamedReference = new NamedReferenceImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, m_name );
        if ( context.addInstance( newNamedReference ) ) {
            return newNamedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "expression/t.namedreference.java", self() );
    }



    // static operations


    // events


    // selections
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public NamedReference self() {
        return this;
    }

    @Override
    public NamedReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_NAMEDREFERENCE;
    }

}

class EmptyNamedReference extends ModelInstance<NamedReference,Sql> implements NamedReference {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return NamedReferenceImpl.KEY_LETTERS;
    }

    @Override
    public NamedReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public NamedReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return NamedReferenceImpl.EMPTY_NAMEDREFERENCE;
    }

}
