package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Literal;
import io.ciera.tool.sql.architecture.expression.LiteralSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class LiteralSetImpl extends InstanceSet<LiteralSet,Literal> implements LiteralSet {

    public LiteralSetImpl() {
    }

    public LiteralSetImpl(Comparator<? super Literal> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Literal literal : this ) literal.setExpression_number( ref_expression_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Literal literal : this ) literal.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Literal literal : this ) literal.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Literal literal : this ) literal.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Literal literal : this ) literal.setParent_package( ref_parent_package );
    }
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( Literal literal : this ) literal.setValue( m_value );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Literal literal : this ) literal.setParent_name( ref_parent_name );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Literal literal : this ) expressionset.add( literal.R776_is_a_Expression() );
        return expressionset;
    }


    @Override
    public Literal nullElement() {
        return LiteralImpl.EMPTY_LITERAL;
    }

    @Override
    public LiteralSet emptySet() {
      return new LiteralSetImpl();
    }

    @Override
    public LiteralSet emptySet(Comparator<? super Literal> comp) {
      return new LiteralSetImpl(comp);
    }

    @Override
    public List<Literal> elements() {
        return Arrays.asList(toArray(new Literal[0]));
    }

}
