package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Mult implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    MANY( 1 ),
    ONE( 0 );

    private final int value;

    Mult() {
        value = -1;
    }

    Mult( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Mult) {
            return null != value && this.value == ((Mult)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Mult deserialize(Object o) throws XtumlException {
        if (o instanceof Mult) {
            return (Mult)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "mult".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Mult.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static Mult valueOf(int value) {
        switch( value ) {
        case 1:
            return MANY;
        case 0:
            return ONE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
