package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Style implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    BOX( 0 ),
    BOXARROWIN( 27 ),
    BOXARROWINOUT( 29 ),
    BOXARROWOUT( 28 ),
    BROKEN( 1 ),
    BULLSEYE( 2 ),
    CIRCLE( 3 ),
    CIRCLECROSS( 4 ),
    COMPONENT( 5 ),
    COMPONENTCONTAINER( 6 ),
    CONCAVEPENTAGON( 7 ),
    CONVEXPENTAGON( 8 ),
    CROSS( 9 ),
    DASH( 10 ),
    DASHDOUBLE( 11 ),
    DIAMOND( 12 ),
    ELLIPSE( 13 ),
    FILLEDARROW( 14 ),
    FILLEDCIRCLE( 15 ),
    FILLEDSQUARE( 16 ),
    FOLDER( 17 ),
    HOURGLASS( 18 ),
    NONE( 19 ),
    OPENARROW( 20 ),
    ROUNDBOX( 21 ),
    SEMICIRCLE( 22 ),
    SOLID( 23 ),
    STICKFIGURE( 24 ),
    TRIANGLE( 25 ),
    UNDERLINED( 26 );

    private final int value;

    Style() {
        value = -1;
    }

    Style( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Style) {
            return null != value && this.value == ((Style)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Style deserialize(Object o) throws XtumlException {
        if (o instanceof Style) {
            return (Style)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "style".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Style.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static Style valueOf(int value) {
        switch( value ) {
        case 0:
            return BOX;
        case 27:
            return BOXARROWIN;
        case 29:
            return BOXARROWINOUT;
        case 28:
            return BOXARROWOUT;
        case 1:
            return BROKEN;
        case 2:
            return BULLSEYE;
        case 3:
            return CIRCLE;
        case 4:
            return CIRCLECROSS;
        case 5:
            return COMPONENT;
        case 6:
            return COMPONENTCONTAINER;
        case 7:
            return CONCAVEPENTAGON;
        case 8:
            return CONVEXPENTAGON;
        case 9:
            return CROSS;
        case 10:
            return DASH;
        case 11:
            return DASHDOUBLE;
        case 12:
            return DIAMOND;
        case 13:
            return ELLIPSE;
        case 14:
            return FILLEDARROW;
        case 15:
            return FILLEDCIRCLE;
        case 16:
            return FILLEDSQUARE;
        case 17:
            return FOLDER;
        case 18:
            return HOURGLASS;
        case 19:
            return NONE;
        case 20:
            return OPENARROW;
        case 21:
            return ROUNDBOX;
        case 22:
            return SEMICIRCLE;
        case 23:
            return SOLID;
        case 24:
            return STICKFIGURE;
        case 25:
            return TRIANGLE;
        case 26:
            return UNDERLINED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
