package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterImpl;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameter;
import io.ciera.tool.sql.ooaofooa.domain.FunctionParameter;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.FunctionParameterImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameter;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.OperationParameterImpl;
import io.ciera.tool.sql.ooaofooa.value.ParameterValue;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ParameterValueImpl extends ModelInstance<ParameterValue,Sql> implements ParameterValue {

    public static final String KEY_LETTERS = "V_PVL";
    public static final ParameterValue EMPTY_PARAMETERVALUE = new EmptyParameterValue();

    private Sql context;

    // constructors
    private ParameterValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_BParm_ID = UniqueId.random();
        ref_SParm_ID = UniqueId.random();
        ref_TParm_ID = UniqueId.random();
        ref_PP_Id = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R831_is_a_value_of_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R832_is_a_value_of_FunctionParameter_inst = FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
        R833_is_a_value_of_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R843_is_a_value_of_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    private ParameterValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_BParm_ID, UniqueId ref_SParm_ID, UniqueId ref_TParm_ID, UniqueId ref_PP_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_BParm_ID = ref_BParm_ID;
        this.ref_SParm_ID = ref_SParm_ID;
        this.ref_TParm_ID = ref_TParm_ID;
        this.ref_PP_Id = ref_PP_Id;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R831_is_a_value_of_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
        R832_is_a_value_of_FunctionParameter_inst = FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
        R833_is_a_value_of_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R843_is_a_value_of_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    public static ParameterValue create( Sql context ) throws XtumlException {
        ParameterValue newParameterValue = new ParameterValueImpl( context );
        if ( context.addInstance( newParameterValue ) ) {
            newParameterValue.getRunContext().addChange(new InstanceCreatedDelta(newParameterValue, KEY_LETTERS));
            return newParameterValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ParameterValue create( Sql context, UniqueId ref_Value_ID, UniqueId ref_BParm_ID, UniqueId ref_SParm_ID, UniqueId ref_TParm_ID, UniqueId ref_PP_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_BParm_ID, ref_SParm_ID, ref_TParm_ID, ref_PP_Id);
    }

    public static ParameterValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_BParm_ID, UniqueId ref_SParm_ID, UniqueId ref_TParm_ID, UniqueId ref_PP_Id ) throws XtumlException {
        ParameterValue newParameterValue = new ParameterValueImpl( context, instanceId, ref_Value_ID, ref_BParm_ID, ref_SParm_ID, ref_TParm_ID, ref_PP_Id );
        if ( context.addInstance( newParameterValue ) ) {
            return newParameterValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_BParm_ID;
    @Override
    public UniqueId getBParm_ID() throws XtumlException {
        checkLiving();
        return ref_BParm_ID;
    }
    @Override
    public void setBParm_ID(UniqueId ref_BParm_ID) throws XtumlException {
        checkLiving();
        if (ref_BParm_ID.inequality( this.ref_BParm_ID)) {
            final UniqueId oldValue = this.ref_BParm_ID;
            this.ref_BParm_ID = ref_BParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_BParm_ID", oldValue, this.ref_BParm_ID));
        }
    }
    private UniqueId ref_SParm_ID;
    @Override
    public UniqueId getSParm_ID() throws XtumlException {
        checkLiving();
        return ref_SParm_ID;
    }
    @Override
    public void setSParm_ID(UniqueId ref_SParm_ID) throws XtumlException {
        checkLiving();
        if (ref_SParm_ID.inequality( this.ref_SParm_ID)) {
            final UniqueId oldValue = this.ref_SParm_ID;
            this.ref_SParm_ID = ref_SParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SParm_ID", oldValue, this.ref_SParm_ID));
        }
    }
    private UniqueId ref_TParm_ID;
    @Override
    public UniqueId getTParm_ID() throws XtumlException {
        checkLiving();
        return ref_TParm_ID;
    }
    @Override
    public void setTParm_ID(UniqueId ref_TParm_ID) throws XtumlException {
        checkLiving();
        if (ref_TParm_ID.inequality( this.ref_TParm_ID)) {
            final UniqueId oldValue = this.ref_TParm_ID;
            this.ref_TParm_ID = ref_TParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_TParm_ID", oldValue, this.ref_TParm_ID));
        }
    }
    private UniqueId ref_PP_Id;
    @Override
    public void setPP_Id(UniqueId ref_PP_Id) throws XtumlException {
        checkLiving();
        if (ref_PP_Id.inequality( this.ref_PP_Id)) {
            final UniqueId oldValue = this.ref_PP_Id;
            this.ref_PP_Id = ref_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_PP_Id", oldValue, this.ref_PP_Id));
        }
    }
    @Override
    public UniqueId getPP_Id() throws XtumlException {
        checkLiving();
        return ref_PP_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private BridgeParameter R831_is_a_value_of_BridgeParameter_inst;
    @Override
    public void setR831_is_a_value_of_BridgeParameter( BridgeParameter inst ) {
        R831_is_a_value_of_BridgeParameter_inst = inst;
    }
    @Override
    public BridgeParameter R831_is_a_value_of_BridgeParameter() throws XtumlException {
        return R831_is_a_value_of_BridgeParameter_inst;
    }
    private FunctionParameter R832_is_a_value_of_FunctionParameter_inst;
    @Override
    public void setR832_is_a_value_of_FunctionParameter( FunctionParameter inst ) {
        R832_is_a_value_of_FunctionParameter_inst = inst;
    }
    @Override
    public FunctionParameter R832_is_a_value_of_FunctionParameter() throws XtumlException {
        return R832_is_a_value_of_FunctionParameter_inst;
    }
    private OperationParameter R833_is_a_value_of_OperationParameter_inst;
    @Override
    public void setR833_is_a_value_of_OperationParameter( OperationParameter inst ) {
        R833_is_a_value_of_OperationParameter_inst = inst;
    }
    @Override
    public OperationParameter R833_is_a_value_of_OperationParameter() throws XtumlException {
        return R833_is_a_value_of_OperationParameter_inst;
    }
    private PropertyParameter R843_is_a_value_of_PropertyParameter_inst;
    @Override
    public void setR843_is_a_value_of_PropertyParameter( PropertyParameter inst ) {
        R843_is_a_value_of_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R843_is_a_value_of_PropertyParameter() throws XtumlException {
        return R843_is_a_value_of_PropertyParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ParameterValue self() {
        return this;
    }

    @Override
    public ParameterValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PARAMETERVALUE;
    }

}

class EmptyParameterValue extends ModelInstance<ParameterValue,Sql> implements ParameterValue {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBParm_ID( UniqueId ref_BParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSParm_ID( UniqueId ref_SParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTParm_ID( UniqueId ref_TParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPP_Id( UniqueId ref_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public BridgeParameter R831_is_a_value_of_BridgeParameter() {
        return BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }
    @Override
    public FunctionParameter R832_is_a_value_of_FunctionParameter() {
        return FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
    }
    @Override
    public OperationParameter R833_is_a_value_of_OperationParameter() {
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }
    @Override
    public PropertyParameter R843_is_a_value_of_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return ParameterValueImpl.KEY_LETTERS;
    }

    @Override
    public ParameterValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ParameterValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ParameterValueImpl.EMPTY_PARAMETERVALUE;
    }

}
