package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.LiteralString;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class LiteralStringImpl extends ModelInstance<LiteralString,Sql> implements LiteralString {

    public static final String KEY_LETTERS = "V_LST";
    public static final LiteralString EMPTY_LITERALSTRING = new EmptyLiteralString();

    private Sql context;

    // constructors
    private LiteralStringImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        m_Value = "";
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private LiteralStringImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, String m_Value ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.m_Value = m_Value;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static LiteralString create( Sql context ) throws XtumlException {
        LiteralString newLiteralString = new LiteralStringImpl( context );
        if ( context.addInstance( newLiteralString ) ) {
            newLiteralString.getRunContext().addChange(new InstanceCreatedDelta(newLiteralString, KEY_LETTERS));
            return newLiteralString;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LiteralString create( Sql context, UniqueId ref_Value_ID, String m_Value ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, m_Value);
    }

    public static LiteralString create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, String m_Value ) throws XtumlException {
        LiteralString newLiteralString = new LiteralStringImpl( context, instanceId, ref_Value_ID, m_Value );
        if ( context.addInstance( newLiteralString ) ) {
            return newLiteralString;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private String m_Value;
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
        return m_Value;
    }
    @Override
    public void setValue(String m_Value) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Value, this.m_Value)) {
            final String oldValue = this.m_Value;
            this.m_Value = m_Value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Value", oldValue, this.m_Value));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LiteralString self() {
        return this;
    }

    @Override
    public LiteralString oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LITERALSTRING;
    }

}

class EmptyLiteralString extends ModelInstance<LiteralString,Sql> implements LiteralString {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue( String m_Value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return LiteralStringImpl.KEY_LETTERS;
    }

    @Override
    public LiteralString self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LiteralString oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LiteralStringImpl.EMPTY_LITERALSTRING;
    }

}
