package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.AttributeReferenceInClass;
import io.ciera.tool.sql.ooaofooa.subsystem.AttributeReferenceInClassSet;
import io.ciera.tool.sql.ooaofooa.subsystem.BaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferentialAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.AttributeReferenceInClassSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.BaseAttributeImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;


public class ReferentialAttributeImpl extends ModelInstance<ReferentialAttribute,Sql> implements ReferentialAttribute {

    public static final String KEY_LETTERS = "O_RATTR";
    public static final ReferentialAttribute EMPTY_REFERENTIALATTRIBUTE = new EmptyReferentialAttribute();

    private Sql context;

    // constructors
    private ReferentialAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_BAttr_ID = UniqueId.random();
        ref_BObj_ID = UniqueId.random();
        m_Ref_Mode = 0;
        m_BaseAttrName = "";
        R106_is_a_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R108_resolves__AttributeReferenceInClass_set = new AttributeReferenceInClassSetImpl();
        R113_navigates_back_to_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }

    private ReferentialAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, UniqueId ref_BAttr_ID, UniqueId ref_BObj_ID, int m_Ref_Mode, String m_BaseAttrName ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_BAttr_ID = ref_BAttr_ID;
        this.ref_BObj_ID = ref_BObj_ID;
        this.m_Ref_Mode = m_Ref_Mode;
        this.m_BaseAttrName = m_BaseAttrName;
        R106_is_a_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R108_resolves__AttributeReferenceInClass_set = new AttributeReferenceInClassSetImpl();
        R113_navigates_back_to_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }

    public static ReferentialAttribute create( Sql context ) throws XtumlException {
        ReferentialAttribute newReferentialAttribute = new ReferentialAttributeImpl( context );
        if ( context.addInstance( newReferentialAttribute ) ) {
            newReferentialAttribute.getRunContext().addChange(new InstanceCreatedDelta(newReferentialAttribute, KEY_LETTERS));
            return newReferentialAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReferentialAttribute create( Sql context, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, UniqueId ref_BAttr_ID, UniqueId ref_BObj_ID, int m_Ref_Mode, String m_BaseAttrName ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Attr_ID, ref_Obj_ID, ref_BAttr_ID, ref_BObj_ID, m_Ref_Mode, m_BaseAttrName);
    }

    public static ReferentialAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, UniqueId ref_BAttr_ID, UniqueId ref_BObj_ID, int m_Ref_Mode, String m_BaseAttrName ) throws XtumlException {
        ReferentialAttribute newReferentialAttribute = new ReferentialAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID, ref_BAttr_ID, ref_BObj_ID, m_Ref_Mode, m_BaseAttrName );
        if ( context.addInstance( newReferentialAttribute ) ) {
            return newReferentialAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
            if ( !R108_resolves__AttributeReferenceInClass().isEmpty() ) R108_resolves__AttributeReferenceInClass().setAttr_ID( ref_Attr_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R108_resolves__AttributeReferenceInClass().isEmpty() ) R108_resolves__AttributeReferenceInClass().setObj_ID( ref_Obj_ID );
        }
    }
    private UniqueId ref_BAttr_ID;
    @Override
    public void setBAttr_ID(UniqueId ref_BAttr_ID) throws XtumlException {
        checkLiving();
        if (ref_BAttr_ID.inequality( this.ref_BAttr_ID)) {
            final UniqueId oldValue = this.ref_BAttr_ID;
            this.ref_BAttr_ID = ref_BAttr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_BAttr_ID", oldValue, this.ref_BAttr_ID));
        }
    }
    @Override
    public UniqueId getBAttr_ID() throws XtumlException {
        checkLiving();
        return ref_BAttr_ID;
    }
    private UniqueId ref_BObj_ID;
    @Override
    public void setBObj_ID(UniqueId ref_BObj_ID) throws XtumlException {
        checkLiving();
        if (ref_BObj_ID.inequality( this.ref_BObj_ID)) {
            final UniqueId oldValue = this.ref_BObj_ID;
            this.ref_BObj_ID = ref_BObj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_BObj_ID", oldValue, this.ref_BObj_ID));
        }
    }
    @Override
    public UniqueId getBObj_ID() throws XtumlException {
        checkLiving();
        return ref_BObj_ID;
    }
    private int m_Ref_Mode;
    @Override
    public void setRef_Mode(int m_Ref_Mode) throws XtumlException {
        checkLiving();
        if (m_Ref_Mode != this.m_Ref_Mode) {
            final int oldValue = this.m_Ref_Mode;
            this.m_Ref_Mode = m_Ref_Mode;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Ref_Mode", oldValue, this.m_Ref_Mode));
        }
    }
    @Override
    public int getRef_Mode() throws XtumlException {
        checkLiving();
        return m_Ref_Mode;
    }
    private String m_BaseAttrName;
    @Override
    public String getBaseAttrName() throws XtumlException {
        checkLiving();
        return m_BaseAttrName;
    }
    @Override
    public void setBaseAttrName(String m_BaseAttrName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_BaseAttrName, this.m_BaseAttrName)) {
            final String oldValue = this.m_BaseAttrName;
            this.m_BaseAttrName = m_BaseAttrName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_BaseAttrName", oldValue, this.m_BaseAttrName));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_ATTR R106_is_a_O_ATTR_inst;
    @Override
    public void setR106_is_a_O_ATTR( O_ATTR inst ) {
        R106_is_a_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R106_is_a_O_ATTR() throws XtumlException {
        return R106_is_a_O_ATTR_inst;
    }
    private AttributeReferenceInClassSet R108_resolves__AttributeReferenceInClass_set;
    @Override
    public void addR108_resolves__AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R108_resolves__AttributeReferenceInClass_set.add(inst);
    }
    @Override
    public void removeR108_resolves__AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R108_resolves__AttributeReferenceInClass_set.remove(inst);
    }
    @Override
    public AttributeReferenceInClassSet R108_resolves__AttributeReferenceInClass() throws XtumlException {
        return R108_resolves__AttributeReferenceInClass_set;
    }
    private BaseAttribute R113_navigates_back_to_BaseAttribute_inst;
    @Override
    public void setR113_navigates_back_to_BaseAttribute( BaseAttribute inst ) {
        R113_navigates_back_to_BaseAttribute_inst = inst;
    }
    @Override
    public BaseAttribute R113_navigates_back_to_BaseAttribute() throws XtumlException {
        return R113_navigates_back_to_BaseAttribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReferentialAttribute self() {
        return this;
    }

    @Override
    public ReferentialAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REFERENTIALATTRIBUTE;
    }

}

class EmptyReferentialAttribute extends ModelInstance<ReferentialAttribute,Sql> implements ReferentialAttribute {

    // attributes
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBAttr_ID( UniqueId ref_BAttr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBObj_ID( UniqueId ref_BObj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRef_Mode( int m_Ref_Mode ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRef_Mode() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBaseAttrName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBaseAttrName( String m_BaseAttrName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_ATTR R106_is_a_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public AttributeReferenceInClassSet R108_resolves__AttributeReferenceInClass() {
        return (new AttributeReferenceInClassSetImpl());
    }
    @Override
    public BaseAttribute R113_navigates_back_to_BaseAttribute() {
        return BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return ReferentialAttributeImpl.KEY_LETTERS;
    }

    @Override
    public ReferentialAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReferentialAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReferentialAttributeImpl.EMPTY_REFERENTIALATTRIBUTE;
    }

}
