package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.CantHappen;
import io.ciera.tool.sql.ooaofooa.statemachine.EventIgnored;
import io.ciera.tool.sql.ooaofooa.statemachine.NewStateTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntry;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.CantHappenImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.EventIgnoredImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NewStateTransitionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SEMEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineStateImpl;


public class StateEventMatrixEntryImpl extends ModelInstance<StateEventMatrixEntry,Sql> implements StateEventMatrixEntry {

    public static final String KEY_LETTERS = "SM_SEME";
    public static final StateEventMatrixEntry EMPTY_STATEEVENTMATRIXENTRY = new EmptyStateEventMatrixEntry();

    private Sql context;

    // constructors
    private StateEventMatrixEntryImpl( Sql context ) {
        this.context = context;
        ref_SMstt_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R503_is_received_by_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R503_receives_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R504_is_a_CantHappen_inst = CantHappenImpl.EMPTY_CANTHAPPEN;
        R504_is_a_EventIgnored_inst = EventIgnoredImpl.EMPTY_EVENTIGNORED;
        R504_is_a_NewStateTransition_inst = NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
    }

    private StateEventMatrixEntryImpl( Sql context, UniqueId instanceId, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_SMstt_ID = ref_SMstt_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R503_is_received_by_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R503_receives_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R504_is_a_CantHappen_inst = CantHappenImpl.EMPTY_CANTHAPPEN;
        R504_is_a_EventIgnored_inst = EventIgnoredImpl.EMPTY_EVENTIGNORED;
        R504_is_a_NewStateTransition_inst = NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
    }

    public static StateEventMatrixEntry create( Sql context ) throws XtumlException {
        StateEventMatrixEntry newStateEventMatrixEntry = new StateEventMatrixEntryImpl( context );
        if ( context.addInstance( newStateEventMatrixEntry ) ) {
            newStateEventMatrixEntry.getRunContext().addChange(new InstanceCreatedDelta(newStateEventMatrixEntry, KEY_LETTERS));
            return newStateEventMatrixEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateEventMatrixEntry create( Sql context, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        return create(context, UniqueId.random(), ref_SMstt_ID, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated);
    }

    public static StateEventMatrixEntry create( Sql context, UniqueId instanceId, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        StateEventMatrixEntry newStateEventMatrixEntry = new StateEventMatrixEntryImpl( context, instanceId, ref_SMstt_ID, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newStateEventMatrixEntry ) ) {
            return newStateEventMatrixEntry;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return ref_SMstt_ID;
    }
    @Override
    public void setSMstt_ID(UniqueId ref_SMstt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMstt_ID.inequality( this.ref_SMstt_ID)) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
            if ( !R504_is_a_CantHappen().isEmpty() ) R504_is_a_CantHappen().setSMstt_ID( ref_SMstt_ID );
            if ( !R504_is_a_EventIgnored().isEmpty() ) R504_is_a_EventIgnored().setSMstt_ID( ref_SMstt_ID );
            if ( !R504_is_a_NewStateTransition().isEmpty() ) R504_is_a_NewStateTransition().setSMstt_ID( ref_SMstt_ID );
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
            if ( !R504_is_a_CantHappen().isEmpty() ) R504_is_a_CantHappen().setSMevt_ID( ref_SMevt_ID );
            if ( !R504_is_a_NewStateTransition().isEmpty() ) R504_is_a_NewStateTransition().setSMevt_ID( ref_SMevt_ID );
            if ( !R504_is_a_EventIgnored().isEmpty() ) R504_is_a_EventIgnored().setSMevt_ID( ref_SMevt_ID );
        }
    }
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R504_is_a_EventIgnored().isEmpty() ) R504_is_a_EventIgnored().setSM_ID( ref_SM_ID );
            if ( !R504_is_a_CantHappen().isEmpty() ) R504_is_a_CantHappen().setSM_ID( ref_SM_ID );
            if ( !R504_is_a_NewStateTransition().isEmpty() ) R504_is_a_NewStateTransition().setSM_ID( ref_SM_ID );
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMstt_ID(), getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StateMachineState R503_is_received_by_StateMachineState_inst;
    @Override
    public void setR503_is_received_by_StateMachineState( StateMachineState inst ) {
        R503_is_received_by_StateMachineState_inst = inst;
    }
    @Override
    public StateMachineState R503_is_received_by_StateMachineState() throws XtumlException {
        return R503_is_received_by_StateMachineState_inst;
    }
    private SEMEvent R503_receives_SEMEvent_inst;
    @Override
    public void setR503_receives_SEMEvent( SEMEvent inst ) {
        R503_receives_SEMEvent_inst = inst;
    }
    @Override
    public SEMEvent R503_receives_SEMEvent() throws XtumlException {
        return R503_receives_SEMEvent_inst;
    }
    private CantHappen R504_is_a_CantHappen_inst;
    @Override
    public void setR504_is_a_CantHappen( CantHappen inst ) {
        R504_is_a_CantHappen_inst = inst;
    }
    @Override
    public CantHappen R504_is_a_CantHappen() throws XtumlException {
        return R504_is_a_CantHappen_inst;
    }
    private EventIgnored R504_is_a_EventIgnored_inst;
    @Override
    public void setR504_is_a_EventIgnored( EventIgnored inst ) {
        R504_is_a_EventIgnored_inst = inst;
    }
    @Override
    public EventIgnored R504_is_a_EventIgnored() throws XtumlException {
        return R504_is_a_EventIgnored_inst;
    }
    private NewStateTransition R504_is_a_NewStateTransition_inst;
    @Override
    public void setR504_is_a_NewStateTransition( NewStateTransition inst ) {
        R504_is_a_NewStateTransition_inst = inst;
    }
    @Override
    public NewStateTransition R504_is_a_NewStateTransition() throws XtumlException {
        return R504_is_a_NewStateTransition_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateEventMatrixEntry self() {
        return this;
    }

    @Override
    public StateEventMatrixEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATEEVENTMATRIXENTRY;
    }

}

class EmptyStateEventMatrixEntry extends ModelInstance<StateEventMatrixEntry,Sql> implements StateEventMatrixEntry {

    // attributes
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StateMachineState R503_is_received_by_StateMachineState() {
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }
    @Override
    public SEMEvent R503_receives_SEMEvent() {
        return SEMEventImpl.EMPTY_SEMEVENT;
    }
    @Override
    public CantHappen R504_is_a_CantHappen() {
        return CantHappenImpl.EMPTY_CANTHAPPEN;
    }
    @Override
    public EventIgnored R504_is_a_EventIgnored() {
        return EventIgnoredImpl.EMPTY_EVENTIGNORED;
    }
    @Override
    public NewStateTransition R504_is_a_NewStateTransition() {
        return NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
    }


    @Override
    public String getKeyLetters() {
        return StateEventMatrixEntryImpl.KEY_LETTERS;
    }

    @Override
    public StateEventMatrixEntry self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateEventMatrixEntry oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateEventMatrixEntryImpl.EMPTY_STATEEVENTMATRIXENTRY;
    }

}
