package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.NoEventTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.Transition;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineStateImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionImpl;


public class NoEventTransitionImpl extends ModelInstance<NoEventTransition,Sql> implements NoEventTransition {

    public static final String KEY_LETTERS = "SM_NETXN";
    public static final NoEventTransition EMPTY_NOEVENTTRANSITION = new EmptyNoEventTransition();

    private Sql context;

    // constructors
    private NoEventTransitionImpl( Sql context ) {
        this.context = context;
        ref_Trans_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMstt_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R507_is_a_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R508_originates_from_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }

    private NoEventTransitionImpl( Sql context, UniqueId instanceId, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Trans_ID = ref_Trans_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMstt_ID = ref_SMstt_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R507_is_a_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R508_originates_from_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }

    public static NoEventTransition create( Sql context ) throws XtumlException {
        NoEventTransition newNoEventTransition = new NoEventTransitionImpl( context );
        if ( context.addInstance( newNoEventTransition ) ) {
            newNoEventTransition.getRunContext().addChange(new InstanceCreatedDelta(newNoEventTransition, KEY_LETTERS));
            return newNoEventTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static NoEventTransition create( Sql context, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Trans_ID, ref_SM_ID, ref_SMstt_ID, m_SMspd_IDdeprecated);
    }

    public static NoEventTransition create( Sql context, UniqueId instanceId, UniqueId ref_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        NoEventTransition newNoEventTransition = new NoEventTransitionImpl( context, instanceId, ref_Trans_ID, ref_SM_ID, ref_SMstt_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newNoEventTransition ) ) {
            return newNoEventTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Trans_ID;
    @Override
    public UniqueId getTrans_ID() throws XtumlException {
        checkLiving();
        return ref_Trans_ID;
    }
    @Override
    public void setTrans_ID(UniqueId ref_Trans_ID) throws XtumlException {
        checkLiving();
        if (ref_Trans_ID.inequality( this.ref_Trans_ID)) {
            final UniqueId oldValue = this.ref_Trans_ID;
            this.ref_Trans_ID = ref_Trans_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Trans_ID", oldValue, this.ref_Trans_ID));
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return ref_SMstt_ID;
    }
    @Override
    public void setSMstt_ID(UniqueId ref_SMstt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMstt_ID.inequality( this.ref_SMstt_ID)) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTrans_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Transition R507_is_a_Transition_inst;
    @Override
    public void setR507_is_a_Transition( Transition inst ) {
        R507_is_a_Transition_inst = inst;
    }
    @Override
    public Transition R507_is_a_Transition() throws XtumlException {
        return R507_is_a_Transition_inst;
    }
    private StateMachineState R508_originates_from_StateMachineState_inst;
    @Override
    public void setR508_originates_from_StateMachineState( StateMachineState inst ) {
        R508_originates_from_StateMachineState_inst = inst;
    }
    @Override
    public StateMachineState R508_originates_from_StateMachineState() throws XtumlException {
        return R508_originates_from_StateMachineState_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public NoEventTransition self() {
        return this;
    }

    @Override
    public NoEventTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_NOEVENTTRANSITION;
    }

}

class EmptyNoEventTransition extends ModelInstance<NoEventTransition,Sql> implements NoEventTransition {

    // attributes
    public UniqueId getTrans_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTrans_ID( UniqueId ref_Trans_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Transition R507_is_a_Transition() {
        return TransitionImpl.EMPTY_TRANSITION;
    }
    @Override
    public StateMachineState R508_originates_from_StateMachineState() {
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }


    @Override
    public String getKeyLetters() {
        return NoEventTransitionImpl.KEY_LETTERS;
    }

    @Override
    public NoEventTransition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public NoEventTransition oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return NoEventTransitionImpl.EMPTY_NOEVENTTRANSITION;
    }

}
