package io.ciera.tool.sql.ooaofooa.selection.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.selection.ACT_SEL;
import io.ciera.tool.sql.ooaofooa.selection.ChainLink;
import io.ciera.tool.sql.ooaofooa.selection.impl.ACT_SELImpl;
import io.ciera.tool.sql.ooaofooa.selection.impl.ChainLinkImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;

import ooaofooa.datatypes.Multiplicity;


public class ChainLinkImpl extends ModelInstance<ChainLink,Sql> implements ChainLink {

    public static final String KEY_LETTERS = "ACT_LNK";
    public static final ChainLink EMPTY_CHAINLINK = new EmptyChainLink();

    private Sql context;

    // constructors
    private ChainLinkImpl( Sql context ) {
        this.context = context;
        m_Link_ID = UniqueId.random();
        m_Rel_Phrase = "";
        ref_Statement_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_Next_Link_ID = UniqueId.random();
        m_Mult = Multiplicity.UNINITIALIZED_ENUM;
        ref_Obj_ID = UniqueId.random();
        m_modelClassKeyLettersLineNumber = 0;
        m_modelClassKeyLettersColumn = 0;
        m_associationNumberLineNumber = 0;
        m_associationNumberColumn = 0;
        m_phraseLineNumber = 0;
        m_phraseColumn = 0;
        R604_precedes_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R604_succeeds_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R637_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
        R678_specifies_instances_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R681_specifies_traversal_of_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    private ChainLinkImpl( Sql context, UniqueId instanceId, UniqueId m_Link_ID, String m_Rel_Phrase, UniqueId ref_Statement_ID, UniqueId ref_Rel_ID, UniqueId ref_Next_Link_ID, Multiplicity m_Mult, UniqueId ref_Obj_ID, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn, int m_associationNumberLineNumber, int m_associationNumberColumn, int m_phraseLineNumber, int m_phraseColumn ) {
        super(instanceId);
        this.context = context;
        this.m_Link_ID = m_Link_ID;
        this.m_Rel_Phrase = m_Rel_Phrase;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_Next_Link_ID = ref_Next_Link_ID;
        this.m_Mult = m_Mult;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
        this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
        this.m_associationNumberLineNumber = m_associationNumberLineNumber;
        this.m_associationNumberColumn = m_associationNumberColumn;
        this.m_phraseLineNumber = m_phraseLineNumber;
        this.m_phraseColumn = m_phraseColumn;
        R604_precedes_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R604_succeeds_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R637_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
        R678_specifies_instances_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R681_specifies_traversal_of_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    public static ChainLink create( Sql context ) throws XtumlException {
        ChainLink newChainLink = new ChainLinkImpl( context );
        if ( context.addInstance( newChainLink ) ) {
            newChainLink.getRunContext().addChange(new InstanceCreatedDelta(newChainLink, KEY_LETTERS));
            return newChainLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ChainLink create( Sql context, UniqueId m_Link_ID, String m_Rel_Phrase, UniqueId ref_Statement_ID, UniqueId ref_Rel_ID, UniqueId ref_Next_Link_ID, Multiplicity m_Mult, UniqueId ref_Obj_ID, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn, int m_associationNumberLineNumber, int m_associationNumberColumn, int m_phraseLineNumber, int m_phraseColumn ) throws XtumlException {
        return create(context, UniqueId.random(), m_Link_ID, m_Rel_Phrase, ref_Statement_ID, ref_Rel_ID, ref_Next_Link_ID, m_Mult, ref_Obj_ID, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn, m_associationNumberLineNumber, m_associationNumberColumn, m_phraseLineNumber, m_phraseColumn);
    }

    public static ChainLink create( Sql context, UniqueId instanceId, UniqueId m_Link_ID, String m_Rel_Phrase, UniqueId ref_Statement_ID, UniqueId ref_Rel_ID, UniqueId ref_Next_Link_ID, Multiplicity m_Mult, UniqueId ref_Obj_ID, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn, int m_associationNumberLineNumber, int m_associationNumberColumn, int m_phraseLineNumber, int m_phraseColumn ) throws XtumlException {
        ChainLink newChainLink = new ChainLinkImpl( context, instanceId, m_Link_ID, m_Rel_Phrase, ref_Statement_ID, ref_Rel_ID, ref_Next_Link_ID, m_Mult, ref_Obj_ID, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn, m_associationNumberLineNumber, m_associationNumberColumn, m_phraseLineNumber, m_phraseColumn );
        if ( context.addInstance( newChainLink ) ) {
            return newChainLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Link_ID;
    @Override
    public void setLink_ID(UniqueId m_Link_ID) throws XtumlException {
        checkLiving();
        if (m_Link_ID.inequality( this.m_Link_ID)) {
            final UniqueId oldValue = this.m_Link_ID;
            this.m_Link_ID = m_Link_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Link_ID", oldValue, this.m_Link_ID));
            if ( !R604_succeeds_ChainLink().isEmpty() ) R604_succeeds_ChainLink().setNext_Link_ID( m_Link_ID );
        }
    }
    @Override
    public UniqueId getLink_ID() throws XtumlException {
        checkLiving();
        return m_Link_ID;
    }
    private String m_Rel_Phrase;
    @Override
    public String getRel_Phrase() throws XtumlException {
        checkLiving();
        return m_Rel_Phrase;
    }
    @Override
    public void setRel_Phrase(String m_Rel_Phrase) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Rel_Phrase, this.m_Rel_Phrase)) {
            final String oldValue = this.m_Rel_Phrase;
            this.m_Rel_Phrase = m_Rel_Phrase;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Rel_Phrase", oldValue, this.m_Rel_Phrase));
        }
    }
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    private UniqueId ref_Next_Link_ID;
    @Override
    public void setNext_Link_ID(UniqueId ref_Next_Link_ID) throws XtumlException {
        checkLiving();
        if (ref_Next_Link_ID.inequality( this.ref_Next_Link_ID)) {
            final UniqueId oldValue = this.ref_Next_Link_ID;
            this.ref_Next_Link_ID = ref_Next_Link_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Next_Link_ID", oldValue, this.ref_Next_Link_ID));
        }
    }
    @Override
    public UniqueId getNext_Link_ID() throws XtumlException {
        checkLiving();
        return ref_Next_Link_ID;
    }
    private Multiplicity m_Mult;
    @Override
    public void setMult(Multiplicity m_Mult) throws XtumlException {
        checkLiving();
        if (m_Mult.inequality( this.m_Mult)) {
            final Multiplicity oldValue = this.m_Mult;
            this.m_Mult = m_Mult;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Mult", oldValue, this.m_Mult));
        }
    }
    @Override
    public Multiplicity getMult() throws XtumlException {
        checkLiving();
        return m_Mult;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private int m_modelClassKeyLettersLineNumber;
    @Override
    public void setModelClassKeyLettersLineNumber(int m_modelClassKeyLettersLineNumber) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersLineNumber != this.m_modelClassKeyLettersLineNumber) {
            final int oldValue = this.m_modelClassKeyLettersLineNumber;
            this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersLineNumber", oldValue, this.m_modelClassKeyLettersLineNumber));
        }
    }
    @Override
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersLineNumber;
    }
    private int m_modelClassKeyLettersColumn;
    @Override
    public int getModelClassKeyLettersColumn() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersColumn;
    }
    @Override
    public void setModelClassKeyLettersColumn(int m_modelClassKeyLettersColumn) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersColumn != this.m_modelClassKeyLettersColumn) {
            final int oldValue = this.m_modelClassKeyLettersColumn;
            this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersColumn", oldValue, this.m_modelClassKeyLettersColumn));
        }
    }
    private int m_associationNumberLineNumber;
    @Override
    public void setAssociationNumberLineNumber(int m_associationNumberLineNumber) throws XtumlException {
        checkLiving();
        if (m_associationNumberLineNumber != this.m_associationNumberLineNumber) {
            final int oldValue = this.m_associationNumberLineNumber;
            this.m_associationNumberLineNumber = m_associationNumberLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_associationNumberLineNumber", oldValue, this.m_associationNumberLineNumber));
        }
    }
    @Override
    public int getAssociationNumberLineNumber() throws XtumlException {
        checkLiving();
        return m_associationNumberLineNumber;
    }
    private int m_associationNumberColumn;
    @Override
    public void setAssociationNumberColumn(int m_associationNumberColumn) throws XtumlException {
        checkLiving();
        if (m_associationNumberColumn != this.m_associationNumberColumn) {
            final int oldValue = this.m_associationNumberColumn;
            this.m_associationNumberColumn = m_associationNumberColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_associationNumberColumn", oldValue, this.m_associationNumberColumn));
        }
    }
    @Override
    public int getAssociationNumberColumn() throws XtumlException {
        checkLiving();
        return m_associationNumberColumn;
    }
    private int m_phraseLineNumber;
    @Override
    public int getPhraseLineNumber() throws XtumlException {
        checkLiving();
        return m_phraseLineNumber;
    }
    @Override
    public void setPhraseLineNumber(int m_phraseLineNumber) throws XtumlException {
        checkLiving();
        if (m_phraseLineNumber != this.m_phraseLineNumber) {
            final int oldValue = this.m_phraseLineNumber;
            this.m_phraseLineNumber = m_phraseLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_phraseLineNumber", oldValue, this.m_phraseLineNumber));
        }
    }
    private int m_phraseColumn;
    @Override
    public int getPhraseColumn() throws XtumlException {
        checkLiving();
        return m_phraseColumn;
    }
    @Override
    public void setPhraseColumn(int m_phraseColumn) throws XtumlException {
        checkLiving();
        if (m_phraseColumn != this.m_phraseColumn) {
            final int oldValue = this.m_phraseColumn;
            this.m_phraseColumn = m_phraseColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_phraseColumn", oldValue, this.m_phraseColumn));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLink_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ChainLink R604_precedes_ChainLink_inst;
    @Override
    public void setR604_precedes_ChainLink( ChainLink inst ) {
        R604_precedes_ChainLink_inst = inst;
    }
    @Override
    public ChainLink R604_precedes_ChainLink() throws XtumlException {
        return R604_precedes_ChainLink_inst;
    }
    private ChainLink R604_succeeds_ChainLink_inst;
    @Override
    public void setR604_succeeds_ChainLink( ChainLink inst ) {
        R604_succeeds_ChainLink_inst = inst;
    }
    @Override
    public ChainLink R604_succeeds_ChainLink() throws XtumlException {
        return R604_succeeds_ChainLink_inst;
    }
    private ACT_SEL R637_ACT_SEL_inst;
    @Override
    public void setR637_ACT_SEL( ACT_SEL inst ) {
        R637_ACT_SEL_inst = inst;
    }
    @Override
    public ACT_SEL R637_ACT_SEL() throws XtumlException {
        return R637_ACT_SEL_inst;
    }
    private ModelClass R678_specifies_instances_of_ModelClass_inst;
    @Override
    public void setR678_specifies_instances_of_ModelClass( ModelClass inst ) {
        R678_specifies_instances_of_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R678_specifies_instances_of_ModelClass() throws XtumlException {
        return R678_specifies_instances_of_ModelClass_inst;
    }
    private Association R681_specifies_traversal_of_Association_inst;
    @Override
    public void setR681_specifies_traversal_of_Association( Association inst ) {
        R681_specifies_traversal_of_Association_inst = inst;
    }
    @Override
    public Association R681_specifies_traversal_of_Association() throws XtumlException {
        return R681_specifies_traversal_of_Association_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ChainLink self() {
        return this;
    }

    @Override
    public ChainLink oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CHAINLINK;
    }

}

class EmptyChainLink extends ModelInstance<ChainLink,Sql> implements ChainLink {

    // attributes
    public void setLink_ID( UniqueId m_Link_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getLink_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRel_Phrase() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_Phrase( String m_Rel_Phrase ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setNext_Link_ID( UniqueId ref_Next_Link_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getNext_Link_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMult( Multiplicity m_Mult ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Multiplicity getMult() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersLineNumber( int m_modelClassKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getModelClassKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersColumn( int m_modelClassKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAssociationNumberLineNumber( int m_associationNumberLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getAssociationNumberLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAssociationNumberColumn( int m_associationNumberColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getAssociationNumberColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getPhraseLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPhraseLineNumber( int m_phraseLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getPhraseColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPhraseColumn( int m_phraseColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ChainLink R604_precedes_ChainLink() {
        return ChainLinkImpl.EMPTY_CHAINLINK;
    }
    @Override
    public ChainLink R604_succeeds_ChainLink() {
        return ChainLinkImpl.EMPTY_CHAINLINK;
    }
    @Override
    public ACT_SEL R637_ACT_SEL() {
        return ACT_SELImpl.EMPTY_ACT_SEL;
    }
    @Override
    public ModelClass R678_specifies_instances_of_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public Association R681_specifies_traversal_of_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return ChainLinkImpl.KEY_LETTERS;
    }

    @Override
    public ChainLink self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ChainLink oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ChainLinkImpl.EMPTY_CHAINLINK;
    }

}
