package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.InformalSynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.SynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.SynchronousMessageImpl;


public class InformalSynchronousMessageImpl extends ModelInstance<InformalSynchronousMessage,Sql> implements InformalSynchronousMessage {

    public static final String KEY_LETTERS = "MSG_ISM";
    public static final InformalSynchronousMessage EMPTY_INFORMALSYNCHRONOUSMESSAGE = new EmptyInformalSynchronousMessage();

    private Sql context;

    // constructors
    private InformalSynchronousMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    private InformalSynchronousMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    public static InformalSynchronousMessage create( Sql context ) throws XtumlException {
        InformalSynchronousMessage newInformalSynchronousMessage = new InformalSynchronousMessageImpl( context );
        if ( context.addInstance( newInformalSynchronousMessage ) ) {
            newInformalSynchronousMessage.getRunContext().addChange(new InstanceCreatedDelta(newInformalSynchronousMessage, KEY_LETTERS));
            return newInformalSynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InformalSynchronousMessage create( Sql context, UniqueId ref_Msg_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Msg_ID);
    }

    public static InformalSynchronousMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID ) throws XtumlException {
        InformalSynchronousMessage newInformalSynchronousMessage = new InformalSynchronousMessageImpl( context, instanceId, ref_Msg_ID );
        if ( context.addInstance( newInformalSynchronousMessage ) ) {
            return newInformalSynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SynchronousMessage R1020_is_a_SynchronousMessage_inst;
    @Override
    public void setR1020_is_a_SynchronousMessage( SynchronousMessage inst ) {
        R1020_is_a_SynchronousMessage_inst = inst;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() throws XtumlException {
        return R1020_is_a_SynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InformalSynchronousMessage self() {
        return this;
    }

    @Override
    public InformalSynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INFORMALSYNCHRONOUSMESSAGE;
    }

}

class EmptyInformalSynchronousMessage extends ModelInstance<InformalSynchronousMessage,Sql> implements InformalSynchronousMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() {
        return SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return InformalSynchronousMessageImpl.KEY_LETTERS;
    }

    @Override
    public InformalSynchronousMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InformalSynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InformalSynchronousMessageImpl.EMPTY_INFORMALSYNCHRONOUSMESSAGE;
    }

}
