package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.AsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.InformalAsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.AsynchronousMessageImpl;


public class InformalAsynchronousMessageImpl extends ModelInstance<InformalAsynchronousMessage,Sql> implements InformalAsynchronousMessage {

    public static final String KEY_LETTERS = "MSG_IAM";
    public static final InformalAsynchronousMessage EMPTY_INFORMALASYNCHRONOUSMESSAGE = new EmptyInformalAsynchronousMessage();

    private Sql context;

    // constructors
    private InformalAsynchronousMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }

    private InformalAsynchronousMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }

    public static InformalAsynchronousMessage create( Sql context ) throws XtumlException {
        InformalAsynchronousMessage newInformalAsynchronousMessage = new InformalAsynchronousMessageImpl( context );
        if ( context.addInstance( newInformalAsynchronousMessage ) ) {
            newInformalAsynchronousMessage.getRunContext().addChange(new InstanceCreatedDelta(newInformalAsynchronousMessage, KEY_LETTERS));
            return newInformalAsynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InformalAsynchronousMessage create( Sql context, UniqueId ref_Msg_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Msg_ID);
    }

    public static InformalAsynchronousMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID ) throws XtumlException {
        InformalAsynchronousMessage newInformalAsynchronousMessage = new InformalAsynchronousMessageImpl( context, instanceId, ref_Msg_ID );
        if ( context.addInstance( newInformalAsynchronousMessage ) ) {
            return newInformalAsynchronousMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private AsynchronousMessage R1019_is_a_AsynchronousMessage_inst;
    @Override
    public void setR1019_is_a_AsynchronousMessage( AsynchronousMessage inst ) {
        R1019_is_a_AsynchronousMessage_inst = inst;
    }
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() throws XtumlException {
        return R1019_is_a_AsynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InformalAsynchronousMessage self() {
        return this;
    }

    @Override
    public InformalAsynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INFORMALASYNCHRONOUSMESSAGE;
    }

}

class EmptyInformalAsynchronousMessage extends ModelInstance<InformalAsynchronousMessage,Sql> implements InformalAsynchronousMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() {
        return AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return InformalAsynchronousMessageImpl.KEY_LETTERS;
    }

    @Override
    public InformalAsynchronousMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InformalAsynchronousMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InformalAsynchronousMessageImpl.EMPTY_INFORMALASYNCHRONOUSMESSAGE;
    }

}
