package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameter;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterImpl;
import io.ciera.tool.sql.ooaofooa.message.BridgeArgument;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;


public class BridgeArgumentImpl extends ModelInstance<BridgeArgument,Sql> implements BridgeArgument {

    public static final String KEY_LETTERS = "MSG_BA";
    public static final BridgeArgument EMPTY_BRIDGEARGUMENT = new EmptyBridgeArgument();

    private Sql context;

    // constructors
    private BridgeArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        ref_BParm_ID = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1014_is_represented_by_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }

    private BridgeArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_BParm_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        this.ref_BParm_ID = ref_BParm_ID;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1014_is_represented_by_BridgeParameter_inst = BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }

    public static BridgeArgument create( Sql context ) throws XtumlException {
        BridgeArgument newBridgeArgument = new BridgeArgumentImpl( context );
        if ( context.addInstance( newBridgeArgument ) ) {
            newBridgeArgument.getRunContext().addChange(new InstanceCreatedDelta(newBridgeArgument, KEY_LETTERS));
            return newBridgeArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BridgeArgument create( Sql context, UniqueId ref_Arg_ID, UniqueId ref_BParm_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Arg_ID, ref_BParm_ID);
    }

    public static BridgeArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_BParm_ID ) throws XtumlException {
        BridgeArgument newBridgeArgument = new BridgeArgumentImpl( context, instanceId, ref_Arg_ID, ref_BParm_ID );
        if ( context.addInstance( newBridgeArgument ) ) {
            return newBridgeArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public void setArg_ID(UniqueId ref_Arg_ID) throws XtumlException {
        checkLiving();
        if (ref_Arg_ID.inequality( this.ref_Arg_ID)) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
        return ref_Arg_ID;
    }
    private UniqueId ref_BParm_ID;
    @Override
    public UniqueId getBParm_ID() throws XtumlException {
        checkLiving();
        return ref_BParm_ID;
    }
    @Override
    public void setBParm_ID(UniqueId ref_BParm_ID) throws XtumlException {
        checkLiving();
        if (ref_BParm_ID.inequality( this.ref_BParm_ID)) {
            final UniqueId oldValue = this.ref_BParm_ID;
            this.ref_BParm_ID = ref_BParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_BParm_ID", oldValue, this.ref_BParm_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }
    private BridgeParameter R1014_is_represented_by_BridgeParameter_inst;
    @Override
    public void setR1014_is_represented_by_BridgeParameter( BridgeParameter inst ) {
        R1014_is_represented_by_BridgeParameter_inst = inst;
    }
    @Override
    public BridgeParameter R1014_is_represented_by_BridgeParameter() throws XtumlException {
        return R1014_is_represented_by_BridgeParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BridgeArgument self() {
        return this;
    }

    @Override
    public BridgeArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BRIDGEARGUMENT;
    }

}

class EmptyBridgeArgument extends ModelInstance<BridgeArgument,Sql> implements BridgeArgument {

    // attributes
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getBParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBParm_ID( UniqueId ref_BParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }
    @Override
    public BridgeParameter R1014_is_represented_by_BridgeParameter() {
        return BridgeParameterImpl.EMPTY_BRIDGEPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return BridgeArgumentImpl.KEY_LETTERS;
    }

    @Override
    public BridgeArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BridgeArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BridgeArgumentImpl.EMPTY_BRIDGEARGUMENT;
    }

}
