package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.interaction.LifespanSet;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpanSet;
import io.ciera.tool.sql.ooaofooa.interaction.TimingMark;
import io.ciera.tool.sql.ooaofooa.interaction.TimingMarkSet;
import io.ciera.tool.sql.ooaofooa.interaction.impl.LifespanSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.TimeSpanSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TimingMarkSetImpl extends InstanceSet<TimingMarkSet,TimingMark> implements TimingMarkSet {

    public TimingMarkSetImpl() {
    }

    public TimingMarkSetImpl(Comparator<? super TimingMark> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( TimingMark timingmark : this ) timingmark.setName( m_Name );
    }
    @Override
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        for ( TimingMark timingmark : this ) timingmark.setPart_ID( ref_Part_ID );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( TimingMark timingmark : this ) timingmark.setDescrip( m_Descrip );
    }
    @Override
    public void setMark_ID( UniqueId m_Mark_ID ) throws XtumlException {
        for ( TimingMark timingmark : this ) timingmark.setMark_ID( m_Mark_ID );
    }


    // selections
    @Override
    public LifespanSet R931_marks_a_point_in_time_Lifespan() throws XtumlException {
        LifespanSet lifespanset = new LifespanSetImpl();
        for ( TimingMark timingmark : this ) lifespanset.add( timingmark.R931_marks_a_point_in_time_Lifespan() );
        return lifespanset;
    }
    @Override
    public TimeSpanSet R941_defines_start_of_TimeSpan() throws XtumlException {
        TimeSpanSet timespanset = new TimeSpanSetImpl();
        for ( TimingMark timingmark : this ) timespanset.addAll( timingmark.R941_defines_start_of_TimeSpan() );
        return timespanset;
    }
    @Override
    public TimeSpanSet R942_defines_end_of_TimeSpan() throws XtumlException {
        TimeSpanSet timespanset = new TimeSpanSetImpl();
        for ( TimingMark timingmark : this ) timespanset.addAll( timingmark.R942_defines_end_of_TimeSpan() );
        return timespanset;
    }


    @Override
    public TimingMark nullElement() {
        return TimingMarkImpl.EMPTY_TIMINGMARK;
    }

    @Override
    public TimingMarkSet emptySet() {
      return new TimingMarkSetImpl();
    }

    @Override
    public TimingMarkSet emptySet(Comparator<? super TimingMark> comp) {
      return new TimingMarkSetImpl(comp);
    }

    @Override
    public List<TimingMark> elements() {
        TimingMark[] elements = toArray(new TimingMark[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
