package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.FormalAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantAttributeImpl;


public class FormalAttributeImpl extends ModelInstance<FormalAttribute,Sql> implements FormalAttribute {

    public static final String KEY_LETTERS = "SQ_FA";
    public static final FormalAttribute EMPTY_FORMALATTRIBUTE = new EmptyFormalAttribute();

    private Sql context;

    // constructors
    private FormalAttributeImpl( Sql context ) {
        this.context = context;
        ref_Ia_ID = UniqueId.random();
        R947_is_a_ClassParticipantAttribute_inst = ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

    private FormalAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Ia_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Ia_ID = ref_Ia_ID;
        R947_is_a_ClassParticipantAttribute_inst = ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

    public static FormalAttribute create( Sql context ) throws XtumlException {
        FormalAttribute newFormalAttribute = new FormalAttributeImpl( context );
        if ( context.addInstance( newFormalAttribute ) ) {
            newFormalAttribute.getRunContext().addChange(new InstanceCreatedDelta(newFormalAttribute, KEY_LETTERS));
            return newFormalAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FormalAttribute create( Sql context, UniqueId ref_Ia_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Ia_ID);
    }

    public static FormalAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Ia_ID ) throws XtumlException {
        FormalAttribute newFormalAttribute = new FormalAttributeImpl( context, instanceId, ref_Ia_ID );
        if ( context.addInstance( newFormalAttribute ) ) {
            return newFormalAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Ia_ID;
    @Override
    public UniqueId getIa_ID() throws XtumlException {
        checkLiving();
        return ref_Ia_ID;
    }
    @Override
    public void setIa_ID(UniqueId ref_Ia_ID) throws XtumlException {
        checkLiving();
        if (ref_Ia_ID.inequality( this.ref_Ia_ID)) {
            final UniqueId oldValue = this.ref_Ia_ID;
            this.ref_Ia_ID = ref_Ia_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Ia_ID", oldValue, this.ref_Ia_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getIa_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ClassParticipantAttribute R947_is_a_ClassParticipantAttribute_inst;
    @Override
    public void setR947_is_a_ClassParticipantAttribute( ClassParticipantAttribute inst ) {
        R947_is_a_ClassParticipantAttribute_inst = inst;
    }
    @Override
    public ClassParticipantAttribute R947_is_a_ClassParticipantAttribute() throws XtumlException {
        return R947_is_a_ClassParticipantAttribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FormalAttribute self() {
        return this;
    }

    @Override
    public FormalAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FORMALATTRIBUTE;
    }

}

class EmptyFormalAttribute extends ModelInstance<FormalAttribute,Sql> implements FormalAttribute {

    // attributes
    public UniqueId getIa_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIa_ID( UniqueId ref_Ia_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ClassParticipantAttribute R947_is_a_ClassParticipantAttribute() {
        return ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return FormalAttributeImpl.KEY_LETTERS;
    }

    @Override
    public FormalAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FormalAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FormalAttributeImpl.EMPTY_FORMALATTRIBUTE;
    }

}
