package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionImpl;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannel;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.RuntimeChannelImpl;


public class RuntimeChannelImpl extends ModelInstance<RuntimeChannel,Sql> implements RuntimeChannel {

    public static final String KEY_LETTERS = "I_RCH";
    public static final RuntimeChannel EMPTY_RUNTIMECHANNEL = new EmptyRuntimeChannel();

    private Sql context;

    // constructors
    private RuntimeChannelImpl( Sql context ) {
        this.context = context;
        m_Channel_Id = UniqueId.random();
        ref_Execution_Engine_ID = UniqueId.random();
        ref_other_Execution_Engine_ID = UniqueId.random();
        ref_Satisfaction_Id = UniqueId.random();
        ref_Delegation_Id = UniqueId.random();
        ref_Next_provider_Channel_Id = UniqueId.random();
        R2968_is_interface_provider_to_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2968_is_interface_requirer_of_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2969_implements_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
        R2972_implements_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R2973_provider_RuntimeChannel_inst = RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
        R2973_requirer_RuntimeChannel_inst = RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
    }

    private RuntimeChannelImpl( Sql context, UniqueId instanceId, UniqueId m_Channel_Id, UniqueId ref_Execution_Engine_ID, UniqueId ref_other_Execution_Engine_ID, UniqueId ref_Satisfaction_Id, UniqueId ref_Delegation_Id, UniqueId ref_Next_provider_Channel_Id ) {
        super(instanceId);
        this.context = context;
        this.m_Channel_Id = m_Channel_Id;
        this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
        this.ref_other_Execution_Engine_ID = ref_other_Execution_Engine_ID;
        this.ref_Satisfaction_Id = ref_Satisfaction_Id;
        this.ref_Delegation_Id = ref_Delegation_Id;
        this.ref_Next_provider_Channel_Id = ref_Next_provider_Channel_Id;
        R2968_is_interface_provider_to_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2968_is_interface_requirer_of_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2969_implements_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
        R2972_implements_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R2973_provider_RuntimeChannel_inst = RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
        R2973_requirer_RuntimeChannel_inst = RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
    }

    public static RuntimeChannel create( Sql context ) throws XtumlException {
        RuntimeChannel newRuntimeChannel = new RuntimeChannelImpl( context );
        if ( context.addInstance( newRuntimeChannel ) ) {
            newRuntimeChannel.getRunContext().addChange(new InstanceCreatedDelta(newRuntimeChannel, KEY_LETTERS));
            return newRuntimeChannel;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RuntimeChannel create( Sql context, UniqueId m_Channel_Id, UniqueId ref_Execution_Engine_ID, UniqueId ref_other_Execution_Engine_ID, UniqueId ref_Satisfaction_Id, UniqueId ref_Delegation_Id, UniqueId ref_Next_provider_Channel_Id ) throws XtumlException {
        return create(context, UniqueId.random(), m_Channel_Id, ref_Execution_Engine_ID, ref_other_Execution_Engine_ID, ref_Satisfaction_Id, ref_Delegation_Id, ref_Next_provider_Channel_Id);
    }

    public static RuntimeChannel create( Sql context, UniqueId instanceId, UniqueId m_Channel_Id, UniqueId ref_Execution_Engine_ID, UniqueId ref_other_Execution_Engine_ID, UniqueId ref_Satisfaction_Id, UniqueId ref_Delegation_Id, UniqueId ref_Next_provider_Channel_Id ) throws XtumlException {
        RuntimeChannel newRuntimeChannel = new RuntimeChannelImpl( context, instanceId, m_Channel_Id, ref_Execution_Engine_ID, ref_other_Execution_Engine_ID, ref_Satisfaction_Id, ref_Delegation_Id, ref_Next_provider_Channel_Id );
        if ( context.addInstance( newRuntimeChannel ) ) {
            return newRuntimeChannel;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Channel_Id;
    @Override
    public void setChannel_Id(UniqueId m_Channel_Id) throws XtumlException {
        checkLiving();
        if (m_Channel_Id.inequality( this.m_Channel_Id)) {
            final UniqueId oldValue = this.m_Channel_Id;
            this.m_Channel_Id = m_Channel_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Channel_Id", oldValue, this.m_Channel_Id));
            if ( !R2973_provider_RuntimeChannel().isEmpty() ) R2973_provider_RuntimeChannel().setNext_provider_Channel_Id( m_Channel_Id );
        }
    }
    @Override
    public UniqueId getChannel_Id() throws XtumlException {
        checkLiving();
        return m_Channel_Id;
    }
    private UniqueId ref_Execution_Engine_ID;
    @Override
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        checkLiving();
        return ref_Execution_Engine_ID;
    }
    @Override
    public void setExecution_Engine_ID(UniqueId ref_Execution_Engine_ID) throws XtumlException {
        checkLiving();
        if (ref_Execution_Engine_ID.inequality( this.ref_Execution_Engine_ID)) {
            final UniqueId oldValue = this.ref_Execution_Engine_ID;
            this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Execution_Engine_ID", oldValue, this.ref_Execution_Engine_ID));
        }
    }
    private UniqueId ref_other_Execution_Engine_ID;
    @Override
    public UniqueId getOther_Execution_Engine_ID() throws XtumlException {
        checkLiving();
        return ref_other_Execution_Engine_ID;
    }
    @Override
    public void setOther_Execution_Engine_ID(UniqueId ref_other_Execution_Engine_ID) throws XtumlException {
        checkLiving();
        if (ref_other_Execution_Engine_ID.inequality( this.ref_other_Execution_Engine_ID)) {
            final UniqueId oldValue = this.ref_other_Execution_Engine_ID;
            this.ref_other_Execution_Engine_ID = ref_other_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_other_Execution_Engine_ID", oldValue, this.ref_other_Execution_Engine_ID));
        }
    }
    private UniqueId ref_Satisfaction_Id;
    @Override
    public void setSatisfaction_Id(UniqueId ref_Satisfaction_Id) throws XtumlException {
        checkLiving();
        if (ref_Satisfaction_Id.inequality( this.ref_Satisfaction_Id)) {
            final UniqueId oldValue = this.ref_Satisfaction_Id;
            this.ref_Satisfaction_Id = ref_Satisfaction_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Satisfaction_Id", oldValue, this.ref_Satisfaction_Id));
        }
    }
    @Override
    public UniqueId getSatisfaction_Id() throws XtumlException {
        checkLiving();
        return ref_Satisfaction_Id;
    }
    private UniqueId ref_Delegation_Id;
    @Override
    public UniqueId getDelegation_Id() throws XtumlException {
        checkLiving();
        return ref_Delegation_Id;
    }
    @Override
    public void setDelegation_Id(UniqueId ref_Delegation_Id) throws XtumlException {
        checkLiving();
        if (ref_Delegation_Id.inequality( this.ref_Delegation_Id)) {
            final UniqueId oldValue = this.ref_Delegation_Id;
            this.ref_Delegation_Id = ref_Delegation_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Delegation_Id", oldValue, this.ref_Delegation_Id));
        }
    }
    private UniqueId ref_Next_provider_Channel_Id;
    @Override
    public void setNext_provider_Channel_Id(UniqueId ref_Next_provider_Channel_Id) throws XtumlException {
        checkLiving();
        if (ref_Next_provider_Channel_Id.inequality( this.ref_Next_provider_Channel_Id)) {
            final UniqueId oldValue = this.ref_Next_provider_Channel_Id;
            this.ref_Next_provider_Channel_Id = ref_Next_provider_Channel_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Next_provider_Channel_Id", oldValue, this.ref_Next_provider_Channel_Id));
        }
    }
    @Override
    public UniqueId getNext_provider_Channel_Id() throws XtumlException {
        checkLiving();
        return ref_Next_provider_Channel_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getChannel_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getExecution_Engine_ID(), getOther_Execution_Engine_ID(), getSatisfaction_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ComponentInstance R2968_is_interface_provider_to_ComponentInstance_inst;
    @Override
    public void setR2968_is_interface_provider_to_ComponentInstance( ComponentInstance inst ) {
        R2968_is_interface_provider_to_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2968_is_interface_provider_to_ComponentInstance() throws XtumlException {
        return R2968_is_interface_provider_to_ComponentInstance_inst;
    }
    private ComponentInstance R2968_is_interface_requirer_of_ComponentInstance_inst;
    @Override
    public void setR2968_is_interface_requirer_of_ComponentInstance( ComponentInstance inst ) {
        R2968_is_interface_requirer_of_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2968_is_interface_requirer_of_ComponentInstance() throws XtumlException {
        return R2968_is_interface_requirer_of_ComponentInstance_inst;
    }
    private Satisfaction R2969_implements_Satisfaction_inst;
    @Override
    public void setR2969_implements_Satisfaction( Satisfaction inst ) {
        R2969_implements_Satisfaction_inst = inst;
    }
    @Override
    public Satisfaction R2969_implements_Satisfaction() throws XtumlException {
        return R2969_implements_Satisfaction_inst;
    }
    private Delegation R2972_implements_Delegation_inst;
    @Override
    public void setR2972_implements_Delegation( Delegation inst ) {
        R2972_implements_Delegation_inst = inst;
    }
    @Override
    public Delegation R2972_implements_Delegation() throws XtumlException {
        return R2972_implements_Delegation_inst;
    }
    private RuntimeChannel R2973_provider_RuntimeChannel_inst;
    @Override
    public void setR2973_provider_RuntimeChannel( RuntimeChannel inst ) {
        R2973_provider_RuntimeChannel_inst = inst;
    }
    @Override
    public RuntimeChannel R2973_provider_RuntimeChannel() throws XtumlException {
        return R2973_provider_RuntimeChannel_inst;
    }
    private RuntimeChannel R2973_requirer_RuntimeChannel_inst;
    @Override
    public void setR2973_requirer_RuntimeChannel( RuntimeChannel inst ) {
        R2973_requirer_RuntimeChannel_inst = inst;
    }
    @Override
    public RuntimeChannel R2973_requirer_RuntimeChannel() throws XtumlException {
        return R2973_requirer_RuntimeChannel_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RuntimeChannel self() {
        return this;
    }

    @Override
    public RuntimeChannel oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RUNTIMECHANNEL;
    }

}

class EmptyRuntimeChannel extends ModelInstance<RuntimeChannel,Sql> implements RuntimeChannel {

    // attributes
    public void setChannel_Id( UniqueId m_Channel_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getChannel_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOther_Execution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOther_Execution_Engine_ID( UniqueId ref_other_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSatisfaction_Id( UniqueId ref_Satisfaction_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSatisfaction_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDelegation_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setNext_provider_Channel_Id( UniqueId ref_Next_provider_Channel_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getNext_provider_Channel_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ComponentInstance R2968_is_interface_provider_to_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public ComponentInstance R2968_is_interface_requirer_of_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public Satisfaction R2969_implements_Satisfaction() {
        return SatisfactionImpl.EMPTY_SATISFACTION;
    }
    @Override
    public Delegation R2972_implements_Delegation() {
        return DelegationImpl.EMPTY_DELEGATION;
    }
    @Override
    public RuntimeChannel R2973_provider_RuntimeChannel() {
        return RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
    }
    @Override
    public RuntimeChannel R2973_requirer_RuntimeChannel() {
        return RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
    }


    @Override
    public String getKeyLetters() {
        return RuntimeChannelImpl.KEY_LETTERS;
    }

    @Override
    public RuntimeChannel self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RuntimeChannel oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RuntimeChannelImpl.EMPTY_RUNTIMECHANNEL;
    }

}
