package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.instance.Link;
import io.ciera.tool.sql.ooaofooa.instance.LinkParticipation;
import io.ciera.tool.sql.ooaofooa.instance.impl.LinkParticipationImpl;


public class LinkImpl extends ModelInstance<Link,Sql> implements Link {

    public static final String KEY_LETTERS = "I_LNK";
    public static final Link EMPTY_LINK = new EmptyLink();

    private Sql context;

    // constructors
    private LinkImpl( Sql context ) {
        this.context = context;
        m_Link_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_fromInst_ID = UniqueId.random();
        ref_toInst_ID = UniqueId.random();
        ref_assocInst_ID = UniqueId.random();
        R2901_originates_at_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2902_ends_at_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2903_has_associator_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2904_is_instance_of_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    private LinkImpl( Sql context, UniqueId instanceId, UniqueId m_Link_ID, UniqueId ref_Rel_ID, UniqueId ref_fromInst_ID, UniqueId ref_toInst_ID, UniqueId ref_assocInst_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Link_ID = m_Link_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_fromInst_ID = ref_fromInst_ID;
        this.ref_toInst_ID = ref_toInst_ID;
        this.ref_assocInst_ID = ref_assocInst_ID;
        R2901_originates_at_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2902_ends_at_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2903_has_associator_LinkParticipation_inst = LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
        R2904_is_instance_of_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
    }

    public static Link create( Sql context ) throws XtumlException {
        Link newLink = new LinkImpl( context );
        if ( context.addInstance( newLink ) ) {
            newLink.getRunContext().addChange(new InstanceCreatedDelta(newLink, KEY_LETTERS));
            return newLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Link create( Sql context, UniqueId m_Link_ID, UniqueId ref_Rel_ID, UniqueId ref_fromInst_ID, UniqueId ref_toInst_ID, UniqueId ref_assocInst_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_Link_ID, ref_Rel_ID, ref_fromInst_ID, ref_toInst_ID, ref_assocInst_ID);
    }

    public static Link create( Sql context, UniqueId instanceId, UniqueId m_Link_ID, UniqueId ref_Rel_ID, UniqueId ref_fromInst_ID, UniqueId ref_toInst_ID, UniqueId ref_assocInst_ID ) throws XtumlException {
        Link newLink = new LinkImpl( context, instanceId, m_Link_ID, ref_Rel_ID, ref_fromInst_ID, ref_toInst_ID, ref_assocInst_ID );
        if ( context.addInstance( newLink ) ) {
            return newLink;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Link_ID;
    @Override
    public void setLink_ID(UniqueId m_Link_ID) throws XtumlException {
        checkLiving();
        if (m_Link_ID.inequality( this.m_Link_ID)) {
            final UniqueId oldValue = this.m_Link_ID;
            this.m_Link_ID = m_Link_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Link_ID", oldValue, this.m_Link_ID));
        }
    }
    @Override
    public UniqueId getLink_ID() throws XtumlException {
        checkLiving();
        return m_Link_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private UniqueId ref_fromInst_ID;
    @Override
    public UniqueId getFromInst_ID() throws XtumlException {
        checkLiving();
        return ref_fromInst_ID;
    }
    @Override
    public void setFromInst_ID(UniqueId ref_fromInst_ID) throws XtumlException {
        checkLiving();
        if (ref_fromInst_ID.inequality( this.ref_fromInst_ID)) {
            final UniqueId oldValue = this.ref_fromInst_ID;
            this.ref_fromInst_ID = ref_fromInst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_fromInst_ID", oldValue, this.ref_fromInst_ID));
        }
    }
    private UniqueId ref_toInst_ID;
    @Override
    public UniqueId getToInst_ID() throws XtumlException {
        checkLiving();
        return ref_toInst_ID;
    }
    @Override
    public void setToInst_ID(UniqueId ref_toInst_ID) throws XtumlException {
        checkLiving();
        if (ref_toInst_ID.inequality( this.ref_toInst_ID)) {
            final UniqueId oldValue = this.ref_toInst_ID;
            this.ref_toInst_ID = ref_toInst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_toInst_ID", oldValue, this.ref_toInst_ID));
        }
    }
    private UniqueId ref_assocInst_ID;
    @Override
    public UniqueId getAssocInst_ID() throws XtumlException {
        checkLiving();
        return ref_assocInst_ID;
    }
    @Override
    public void setAssocInst_ID(UniqueId ref_assocInst_ID) throws XtumlException {
        checkLiving();
        if (ref_assocInst_ID.inequality( this.ref_assocInst_ID)) {
            final UniqueId oldValue = this.ref_assocInst_ID;
            this.ref_assocInst_ID = ref_assocInst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_assocInst_ID", oldValue, this.ref_assocInst_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLink_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private LinkParticipation R2901_originates_at_LinkParticipation_inst;
    @Override
    public void setR2901_originates_at_LinkParticipation( LinkParticipation inst ) {
        R2901_originates_at_LinkParticipation_inst = inst;
    }
    @Override
    public LinkParticipation R2901_originates_at_LinkParticipation() throws XtumlException {
        return R2901_originates_at_LinkParticipation_inst;
    }
    private LinkParticipation R2902_ends_at_LinkParticipation_inst;
    @Override
    public void setR2902_ends_at_LinkParticipation( LinkParticipation inst ) {
        R2902_ends_at_LinkParticipation_inst = inst;
    }
    @Override
    public LinkParticipation R2902_ends_at_LinkParticipation() throws XtumlException {
        return R2902_ends_at_LinkParticipation_inst;
    }
    private LinkParticipation R2903_has_associator_LinkParticipation_inst;
    @Override
    public void setR2903_has_associator_LinkParticipation( LinkParticipation inst ) {
        R2903_has_associator_LinkParticipation_inst = inst;
    }
    @Override
    public LinkParticipation R2903_has_associator_LinkParticipation() throws XtumlException {
        return R2903_has_associator_LinkParticipation_inst;
    }
    private Association R2904_is_instance_of_Association_inst;
    @Override
    public void setR2904_is_instance_of_Association( Association inst ) {
        R2904_is_instance_of_Association_inst = inst;
    }
    @Override
    public Association R2904_is_instance_of_Association() throws XtumlException {
        return R2904_is_instance_of_Association_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Link self() {
        return this;
    }

    @Override
    public Link oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LINK;
    }

}

class EmptyLink extends ModelInstance<Link,Sql> implements Link {

    // attributes
    public void setLink_ID( UniqueId m_Link_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getLink_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getFromInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFromInst_ID( UniqueId ref_fromInst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getToInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setToInst_ID( UniqueId ref_toInst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAssocInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAssocInst_ID( UniqueId ref_assocInst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public LinkParticipation R2901_originates_at_LinkParticipation() {
        return LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
    }
    @Override
    public LinkParticipation R2902_ends_at_LinkParticipation() {
        return LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
    }
    @Override
    public LinkParticipation R2903_has_associator_LinkParticipation() {
        return LinkParticipationImpl.EMPTY_LINKPARTICIPATION;
    }
    @Override
    public Association R2904_is_instance_of_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return LinkImpl.KEY_LETTERS;
    }

    @Override
    public Link self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Link oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LinkImpl.EMPTY_LINK;
    }

}
