package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateToClass;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateSMEventStatementImpl;


public class GenerateToClassImpl extends ModelInstance<GenerateToClass,Sql> implements GenerateToClass {

    public static final String KEY_LETTERS = "E_GAR";
    public static final GenerateToClass EMPTY_GENERATETOCLASS = new EmptyGenerateToClass();

    private Sql context;

    // constructors
    private GenerateToClassImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        R705_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }

    private GenerateToClassImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        R705_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }

    public static GenerateToClass create( Sql context ) throws XtumlException {
        GenerateToClass newGenerateToClass = new GenerateToClassImpl( context );
        if ( context.addInstance( newGenerateToClass ) ) {
            newGenerateToClass.getRunContext().addChange(new InstanceCreatedDelta(newGenerateToClass, KEY_LETTERS));
            return newGenerateToClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GenerateToClass create( Sql context, UniqueId ref_Statement_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID);
    }

    public static GenerateToClass create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) throws XtumlException {
        GenerateToClass newGenerateToClass = new GenerateToClassImpl( context, instanceId, ref_Statement_ID );
        if ( context.addInstance( newGenerateToClass ) ) {
            return newGenerateToClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private GenerateSMEventStatement R705_is_a_GenerateSMEventStatement_inst;
    @Override
    public void setR705_is_a_GenerateSMEventStatement( GenerateSMEventStatement inst ) {
        R705_is_a_GenerateSMEventStatement_inst = inst;
    }
    @Override
    public GenerateSMEventStatement R705_is_a_GenerateSMEventStatement() throws XtumlException {
        return R705_is_a_GenerateSMEventStatement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GenerateToClass self() {
        return this;
    }

    @Override
    public GenerateToClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GENERATETOCLASS;
    }

}

class EmptyGenerateToClass extends ModelInstance<GenerateToClass,Sql> implements GenerateToClass {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public GenerateSMEventStatement R705_is_a_GenerateSMEventStatement() {
        return GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }


    @Override
    public String getKeyLetters() {
        return GenerateToClassImpl.KEY_LETTERS;
    }

    @Override
    public GenerateToClass self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GenerateToClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GenerateToClassImpl.EMPTY_GENERATETOCLASS;
    }

}
