package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.impl.UtilityFunctionImpl;
import io.ciera.tool.sql.ooaofooa.body.BridgeBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BridgeBodyImpl;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameter;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameterSet;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntity;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.ExternalEntityImpl;
import io.ciera.tool.sql.ooaofooa.invocation.BridgeInvocation;
import io.ciera.tool.sql.ooaofooa.invocation.BridgeInvocationSet;
import io.ciera.tool.sql.ooaofooa.invocation.impl.BridgeInvocationSetImpl;
import io.ciera.tool.sql.ooaofooa.message.BridgeMessage;
import io.ciera.tool.sql.ooaofooa.message.BridgeMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.BridgeMessageSetImpl;
import io.ciera.tool.sql.ooaofooa.value.BridgeValue;
import io.ciera.tool.sql.ooaofooa.value.BridgeValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.BridgeValueSetImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class BridgeImpl extends ModelInstance<Bridge,Sql> implements Bridge {

    public static final String KEY_LETTERS = "S_BRG";
    public static final Bridge EMPTY_BRIDGE = new EmptyBridge();

    private Sql context;

    // constructors
    private BridgeImpl( Sql context ) {
        this.context = context;
        m_Brg_ID = UniqueId.random();
        ref_EE_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Brg_Typ = 0;
        ref_DT_ID = UniqueId.random();
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Return_Dimensions = "";
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        R1012_is_invoked_by_BridgeMessage_set = new BridgeMessageSetImpl();
        R19_provides_access_to_ExternalEntity_inst = ExternalEntityImpl.EMPTY_EXTERNALENTITY;
        R20_return_value_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R21_is_part_of_BridgeParameter_set = new BridgeParameterSetImpl();
        R4570_is_transformed_from_UtilityFunction_inst = UtilityFunctionImpl.EMPTY_UTILITYFUNCTION;
        R50_return_value_may_have_Dimensions_set = new DimensionsSetImpl();
        R674_BridgeInvocation_set = new BridgeInvocationSetImpl();
        R697_BridgeBody_inst = BridgeBodyImpl.EMPTY_BRIDGEBODY;
        R828_BridgeValue_set = new BridgeValueSetImpl();
    }

    private BridgeImpl( Sql context, UniqueId instanceId, UniqueId m_Brg_ID, UniqueId ref_EE_ID, String m_Name, String m_Descrip, int m_Brg_Typ, UniqueId ref_DT_ID, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, String m_Return_Dimensions, ActionDialect m_Dialect ) {
        super(instanceId);
        this.context = context;
        this.m_Brg_ID = m_Brg_ID;
        this.ref_EE_ID = ref_EE_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Brg_Typ = m_Brg_Typ;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Return_Dimensions = m_Return_Dimensions;
        this.m_Dialect = m_Dialect;
        R1012_is_invoked_by_BridgeMessage_set = new BridgeMessageSetImpl();
        R19_provides_access_to_ExternalEntity_inst = ExternalEntityImpl.EMPTY_EXTERNALENTITY;
        R20_return_value_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R21_is_part_of_BridgeParameter_set = new BridgeParameterSetImpl();
        R4570_is_transformed_from_UtilityFunction_inst = UtilityFunctionImpl.EMPTY_UTILITYFUNCTION;
        R50_return_value_may_have_Dimensions_set = new DimensionsSetImpl();
        R674_BridgeInvocation_set = new BridgeInvocationSetImpl();
        R697_BridgeBody_inst = BridgeBodyImpl.EMPTY_BRIDGEBODY;
        R828_BridgeValue_set = new BridgeValueSetImpl();
    }

    public static Bridge create( Sql context ) throws XtumlException {
        Bridge newBridge = new BridgeImpl( context );
        if ( context.addInstance( newBridge ) ) {
            newBridge.getRunContext().addChange(new InstanceCreatedDelta(newBridge, KEY_LETTERS));
            return newBridge;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Bridge create( Sql context, UniqueId m_Brg_ID, UniqueId ref_EE_ID, String m_Name, String m_Descrip, int m_Brg_Typ, UniqueId ref_DT_ID, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, String m_Return_Dimensions, ActionDialect m_Dialect ) throws XtumlException {
        return create(context, UniqueId.random(), m_Brg_ID, ref_EE_ID, m_Name, m_Descrip, m_Brg_Typ, ref_DT_ID, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Return_Dimensions, m_Dialect);
    }

    public static Bridge create( Sql context, UniqueId instanceId, UniqueId m_Brg_ID, UniqueId ref_EE_ID, String m_Name, String m_Descrip, int m_Brg_Typ, UniqueId ref_DT_ID, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, String m_Return_Dimensions, ActionDialect m_Dialect ) throws XtumlException {
        Bridge newBridge = new BridgeImpl( context, instanceId, m_Brg_ID, ref_EE_ID, m_Name, m_Descrip, m_Brg_Typ, ref_DT_ID, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Return_Dimensions, m_Dialect );
        if ( context.addInstance( newBridge ) ) {
            return newBridge;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Brg_ID;
    @Override
    public void setBrg_ID(UniqueId m_Brg_ID) throws XtumlException {
        checkLiving();
        if (m_Brg_ID.inequality( this.m_Brg_ID)) {
            final UniqueId oldValue = this.m_Brg_ID;
            this.m_Brg_ID = m_Brg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Brg_ID", oldValue, this.m_Brg_ID));
            if ( !R4570_is_transformed_from_UtilityFunction().isEmpty() ) R4570_is_transformed_from_UtilityFunction().setBrg_ID( m_Brg_ID );
            if ( !R1012_is_invoked_by_BridgeMessage().isEmpty() ) R1012_is_invoked_by_BridgeMessage().setBrg_ID( m_Brg_ID );
            if ( !R674_BridgeInvocation().isEmpty() ) R674_BridgeInvocation().setBrg_ID( m_Brg_ID );
            if ( !R828_BridgeValue().isEmpty() ) R828_BridgeValue().setBrg_ID( m_Brg_ID );
            if ( !R50_return_value_may_have_Dimensions().isEmpty() ) R50_return_value_may_have_Dimensions().setBrg_ID( m_Brg_ID );
            if ( !R21_is_part_of_BridgeParameter().isEmpty() ) R21_is_part_of_BridgeParameter().setBrg_ID( m_Brg_ID );
            if ( !R697_BridgeBody().isEmpty() ) R697_BridgeBody().setBrg_ID( m_Brg_ID );
        }
    }
    @Override
    public UniqueId getBrg_ID() throws XtumlException {
        checkLiving();
        return m_Brg_ID;
    }
    private UniqueId ref_EE_ID;
    @Override
    public UniqueId getEE_ID() throws XtumlException {
        checkLiving();
        return ref_EE_ID;
    }
    @Override
    public void setEE_ID(UniqueId ref_EE_ID) throws XtumlException {
        checkLiving();
        if (ref_EE_ID.inequality( this.ref_EE_ID)) {
            final UniqueId oldValue = this.ref_EE_ID;
            this.ref_EE_ID = ref_EE_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_EE_ID", oldValue, this.ref_EE_ID));
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private int m_Brg_Typ;
    @Override
    public void setBrg_Typ(int m_Brg_Typ) throws XtumlException {
        checkLiving();
        if (m_Brg_Typ != this.m_Brg_Typ) {
            final int oldValue = this.m_Brg_Typ;
            this.m_Brg_Typ = m_Brg_Typ;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Brg_Typ", oldValue, this.m_Brg_Typ));
        }
    }
    @Override
    public int getBrg_Typ() throws XtumlException {
        checkLiving();
        return m_Brg_Typ;
    }
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    private String m_Return_Dimensions;
    @Override
    public String getReturn_Dimensions() throws XtumlException {
        checkLiving();
        return m_Return_Dimensions;
    }
    @Override
    public void setReturn_Dimensions(String m_Return_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Return_Dimensions, this.m_Return_Dimensions)) {
            final String oldValue = this.m_Return_Dimensions;
            this.m_Return_Dimensions = m_Return_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Return_Dimensions", oldValue, this.m_Return_Dimensions));
        }
    }
    private ActionDialect m_Dialect;
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getBrg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private BridgeMessageSet R1012_is_invoked_by_BridgeMessage_set;
    @Override
    public void addR1012_is_invoked_by_BridgeMessage( BridgeMessage inst ) {
        R1012_is_invoked_by_BridgeMessage_set.add(inst);
    }
    @Override
    public void removeR1012_is_invoked_by_BridgeMessage( BridgeMessage inst ) {
        R1012_is_invoked_by_BridgeMessage_set.remove(inst);
    }
    @Override
    public BridgeMessageSet R1012_is_invoked_by_BridgeMessage() throws XtumlException {
        return R1012_is_invoked_by_BridgeMessage_set;
    }
    private ExternalEntity R19_provides_access_to_ExternalEntity_inst;
    @Override
    public void setR19_provides_access_to_ExternalEntity( ExternalEntity inst ) {
        R19_provides_access_to_ExternalEntity_inst = inst;
    }
    @Override
    public ExternalEntity R19_provides_access_to_ExternalEntity() throws XtumlException {
        return R19_provides_access_to_ExternalEntity_inst;
    }
    private DataType R20_return_value_defined_by_DataType_inst;
    @Override
    public void setR20_return_value_defined_by_DataType( DataType inst ) {
        R20_return_value_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R20_return_value_defined_by_DataType() throws XtumlException {
        return R20_return_value_defined_by_DataType_inst;
    }
    private BridgeParameterSet R21_is_part_of_BridgeParameter_set;
    @Override
    public void addR21_is_part_of_BridgeParameter( BridgeParameter inst ) {
        R21_is_part_of_BridgeParameter_set.add(inst);
    }
    @Override
    public void removeR21_is_part_of_BridgeParameter( BridgeParameter inst ) {
        R21_is_part_of_BridgeParameter_set.remove(inst);
    }
    @Override
    public BridgeParameterSet R21_is_part_of_BridgeParameter() throws XtumlException {
        return R21_is_part_of_BridgeParameter_set;
    }
    private UtilityFunction R4570_is_transformed_from_UtilityFunction_inst;
    @Override
    public void setR4570_is_transformed_from_UtilityFunction( UtilityFunction inst ) {
        R4570_is_transformed_from_UtilityFunction_inst = inst;
    }
    @Override
    public UtilityFunction R4570_is_transformed_from_UtilityFunction() throws XtumlException {
        return R4570_is_transformed_from_UtilityFunction_inst;
    }
    private DimensionsSet R50_return_value_may_have_Dimensions_set;
    @Override
    public void addR50_return_value_may_have_Dimensions( Dimensions inst ) {
        R50_return_value_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR50_return_value_may_have_Dimensions( Dimensions inst ) {
        R50_return_value_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R50_return_value_may_have_Dimensions() throws XtumlException {
        return R50_return_value_may_have_Dimensions_set;
    }
    private BridgeInvocationSet R674_BridgeInvocation_set;
    @Override
    public void addR674_BridgeInvocation( BridgeInvocation inst ) {
        R674_BridgeInvocation_set.add(inst);
    }
    @Override
    public void removeR674_BridgeInvocation( BridgeInvocation inst ) {
        R674_BridgeInvocation_set.remove(inst);
    }
    @Override
    public BridgeInvocationSet R674_BridgeInvocation() throws XtumlException {
        return R674_BridgeInvocation_set;
    }
    private BridgeBody R697_BridgeBody_inst;
    @Override
    public void setR697_BridgeBody( BridgeBody inst ) {
        R697_BridgeBody_inst = inst;
    }
    @Override
    public BridgeBody R697_BridgeBody() throws XtumlException {
        return R697_BridgeBody_inst;
    }
    private BridgeValueSet R828_BridgeValue_set;
    @Override
    public void addR828_BridgeValue( BridgeValue inst ) {
        R828_BridgeValue_set.add(inst);
    }
    @Override
    public void removeR828_BridgeValue( BridgeValue inst ) {
        R828_BridgeValue_set.remove(inst);
    }
    @Override
    public BridgeValueSet R828_BridgeValue() throws XtumlException {
        return R828_BridgeValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Bridge self() {
        return this;
    }

    @Override
    public Bridge oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BRIDGE;
    }

}

class EmptyBridge extends ModelInstance<Bridge,Sql> implements Bridge {

    // attributes
    public void setBrg_ID( UniqueId m_Brg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBrg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getEE_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEE_ID( UniqueId ref_EE_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBrg_Typ( int m_Brg_Typ ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getBrg_Typ() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReturn_Dimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReturn_Dimensions( String m_Return_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public BridgeMessageSet R1012_is_invoked_by_BridgeMessage() {
        return (new BridgeMessageSetImpl());
    }
    @Override
    public ExternalEntity R19_provides_access_to_ExternalEntity() {
        return ExternalEntityImpl.EMPTY_EXTERNALENTITY;
    }
    @Override
    public DataType R20_return_value_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public BridgeParameterSet R21_is_part_of_BridgeParameter() {
        return (new BridgeParameterSetImpl());
    }
    @Override
    public UtilityFunction R4570_is_transformed_from_UtilityFunction() {
        return UtilityFunctionImpl.EMPTY_UTILITYFUNCTION;
    }
    @Override
    public DimensionsSet R50_return_value_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public BridgeInvocationSet R674_BridgeInvocation() {
        return (new BridgeInvocationSetImpl());
    }
    @Override
    public BridgeBody R697_BridgeBody() {
        return BridgeBodyImpl.EMPTY_BRIDGEBODY;
    }
    @Override
    public BridgeValueSet R828_BridgeValue() {
        return (new BridgeValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return BridgeImpl.KEY_LETTERS;
    }

    @Override
    public Bridge self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Bridge oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BridgeImpl.EMPTY_BRIDGE;
    }

}
