package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.deployment.ServiceInSequence;
import io.ciera.tool.sql.ooaofooa.deployment.ServiceInSequenceSet;
import io.ciera.tool.sql.ooaofooa.deployment.Terminator;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceSequence;
import io.ciera.tool.sql.ooaofooa.deployment.impl.ServiceInSequenceSetImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorImpl;


public class TerminatorServiceSequenceImpl extends ModelInstance<TerminatorServiceSequence,Sql> implements TerminatorServiceSequence {

    public static final String KEY_LETTERS = "D_TSS";
    public static final TerminatorServiceSequence EMPTY_TERMINATORSERVICESEQUENCE = new EmptyTerminatorServiceSequence();

    private Sql context;

    // constructors
    private TerminatorServiceSequenceImpl( Sql context ) {
        this.context = context;
        m_Seq_ID = UniqueId.random();
        ref_Term_ID = UniqueId.random();
        R1658_Terminator_inst = TerminatorImpl.EMPTY_TERMINATOR;
        R1659_described_by_ServiceInSequence_set = new ServiceInSequenceSetImpl();
    }

    private TerminatorServiceSequenceImpl( Sql context, UniqueId instanceId, UniqueId m_Seq_ID, UniqueId ref_Term_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Seq_ID = m_Seq_ID;
        this.ref_Term_ID = ref_Term_ID;
        R1658_Terminator_inst = TerminatorImpl.EMPTY_TERMINATOR;
        R1659_described_by_ServiceInSequence_set = new ServiceInSequenceSetImpl();
    }

    public static TerminatorServiceSequence create( Sql context ) throws XtumlException {
        TerminatorServiceSequence newTerminatorServiceSequence = new TerminatorServiceSequenceImpl( context );
        if ( context.addInstance( newTerminatorServiceSequence ) ) {
            newTerminatorServiceSequence.getRunContext().addChange(new InstanceCreatedDelta(newTerminatorServiceSequence, KEY_LETTERS));
            return newTerminatorServiceSequence;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TerminatorServiceSequence create( Sql context, UniqueId m_Seq_ID, UniqueId ref_Term_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_Seq_ID, ref_Term_ID);
    }

    public static TerminatorServiceSequence create( Sql context, UniqueId instanceId, UniqueId m_Seq_ID, UniqueId ref_Term_ID ) throws XtumlException {
        TerminatorServiceSequence newTerminatorServiceSequence = new TerminatorServiceSequenceImpl( context, instanceId, m_Seq_ID, ref_Term_ID );
        if ( context.addInstance( newTerminatorServiceSequence ) ) {
            return newTerminatorServiceSequence;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Seq_ID;
    @Override
    public void setSeq_ID(UniqueId m_Seq_ID) throws XtumlException {
        checkLiving();
        if (m_Seq_ID.inequality( this.m_Seq_ID)) {
            final UniqueId oldValue = this.m_Seq_ID;
            this.m_Seq_ID = m_Seq_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Seq_ID", oldValue, this.m_Seq_ID));
            if ( !R1659_described_by_ServiceInSequence().isEmpty() ) R1659_described_by_ServiceInSequence().setSeq_ID( m_Seq_ID );
        }
    }
    @Override
    public UniqueId getSeq_ID() throws XtumlException {
        checkLiving();
        return m_Seq_ID;
    }
    private UniqueId ref_Term_ID;
    @Override
    public void setTerm_ID(UniqueId ref_Term_ID) throws XtumlException {
        checkLiving();
        if (ref_Term_ID.inequality( this.ref_Term_ID)) {
            final UniqueId oldValue = this.ref_Term_ID;
            this.ref_Term_ID = ref_Term_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Term_ID", oldValue, this.ref_Term_ID));
        }
    }
    @Override
    public UniqueId getTerm_ID() throws XtumlException {
        checkLiving();
        return ref_Term_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSeq_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Terminator R1658_Terminator_inst;
    @Override
    public void setR1658_Terminator( Terminator inst ) {
        R1658_Terminator_inst = inst;
    }
    @Override
    public Terminator R1658_Terminator() throws XtumlException {
        return R1658_Terminator_inst;
    }
    private ServiceInSequenceSet R1659_described_by_ServiceInSequence_set;
    @Override
    public void addR1659_described_by_ServiceInSequence( ServiceInSequence inst ) {
        R1659_described_by_ServiceInSequence_set.add(inst);
    }
    @Override
    public void removeR1659_described_by_ServiceInSequence( ServiceInSequence inst ) {
        R1659_described_by_ServiceInSequence_set.remove(inst);
    }
    @Override
    public ServiceInSequenceSet R1659_described_by_ServiceInSequence() throws XtumlException {
        return R1659_described_by_ServiceInSequence_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TerminatorServiceSequence self() {
        return this;
    }

    @Override
    public TerminatorServiceSequence oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TERMINATORSERVICESEQUENCE;
    }

}

class EmptyTerminatorServiceSequence extends ModelInstance<TerminatorServiceSequence,Sql> implements TerminatorServiceSequence {

    // attributes
    public void setSeq_ID( UniqueId m_Seq_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSeq_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTerm_ID( UniqueId ref_Term_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTerm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Terminator R1658_Terminator() {
        return TerminatorImpl.EMPTY_TERMINATOR;
    }
    @Override
    public ServiceInSequenceSet R1659_described_by_ServiceInSequence() {
        return (new ServiceInSequenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TerminatorServiceSequenceImpl.KEY_LETTERS;
    }

    @Override
    public TerminatorServiceSequence self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TerminatorServiceSequence oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TerminatorServiceSequenceImpl.EMPTY_TERMINATORSERVICESEQUENCE;
    }

}
