package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.deployment.ServiceInSequence;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorService;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceSequence;
import io.ciera.tool.sql.ooaofooa.deployment.impl.ServiceInSequenceImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceSequenceImpl;


public class ServiceInSequenceImpl extends ModelInstance<ServiceInSequence,Sql> implements ServiceInSequence {

    public static final String KEY_LETTERS = "D_SIS";
    public static final ServiceInSequence EMPTY_SERVICEINSEQUENCE = new EmptyServiceInSequence();

    private Sql context;

    // constructors
    private ServiceInSequenceImpl( Sql context ) {
        this.context = context;
        ref_Svc_ID = UniqueId.random();
        ref_Seq_ID = UniqueId.random();
        ref_Previous_Svc_ID = UniqueId.random();
        R1659_TerminatorServiceSequence_inst = TerminatorServiceSequenceImpl.EMPTY_TERMINATORSERVICESEQUENCE;
        R1660_TerminatorService_inst = TerminatorServiceImpl.EMPTY_TERMINATORSERVICE;
        R1661_precedes_ServiceInSequence_inst = ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
        R1661_succeeds_ServiceInSequence_inst = ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
    }

    private ServiceInSequenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Svc_ID, UniqueId ref_Seq_ID, UniqueId ref_Previous_Svc_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Svc_ID = ref_Svc_ID;
        this.ref_Seq_ID = ref_Seq_ID;
        this.ref_Previous_Svc_ID = ref_Previous_Svc_ID;
        R1659_TerminatorServiceSequence_inst = TerminatorServiceSequenceImpl.EMPTY_TERMINATORSERVICESEQUENCE;
        R1660_TerminatorService_inst = TerminatorServiceImpl.EMPTY_TERMINATORSERVICE;
        R1661_precedes_ServiceInSequence_inst = ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
        R1661_succeeds_ServiceInSequence_inst = ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
    }

    public static ServiceInSequence create( Sql context ) throws XtumlException {
        ServiceInSequence newServiceInSequence = new ServiceInSequenceImpl( context );
        if ( context.addInstance( newServiceInSequence ) ) {
            newServiceInSequence.getRunContext().addChange(new InstanceCreatedDelta(newServiceInSequence, KEY_LETTERS));
            return newServiceInSequence;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ServiceInSequence create( Sql context, UniqueId ref_Svc_ID, UniqueId ref_Seq_ID, UniqueId ref_Previous_Svc_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Svc_ID, ref_Seq_ID, ref_Previous_Svc_ID);
    }

    public static ServiceInSequence create( Sql context, UniqueId instanceId, UniqueId ref_Svc_ID, UniqueId ref_Seq_ID, UniqueId ref_Previous_Svc_ID ) throws XtumlException {
        ServiceInSequence newServiceInSequence = new ServiceInSequenceImpl( context, instanceId, ref_Svc_ID, ref_Seq_ID, ref_Previous_Svc_ID );
        if ( context.addInstance( newServiceInSequence ) ) {
            return newServiceInSequence;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Svc_ID;
    @Override
    public void setSvc_ID(UniqueId ref_Svc_ID) throws XtumlException {
        checkLiving();
        if (ref_Svc_ID.inequality( this.ref_Svc_ID)) {
            final UniqueId oldValue = this.ref_Svc_ID;
            this.ref_Svc_ID = ref_Svc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Svc_ID", oldValue, this.ref_Svc_ID));
            if ( !R1661_precedes_ServiceInSequence().isEmpty() ) R1661_precedes_ServiceInSequence().setPrevious_Svc_ID( ref_Svc_ID );
        }
    }
    @Override
    public UniqueId getSvc_ID() throws XtumlException {
        checkLiving();
        return ref_Svc_ID;
    }
    private UniqueId ref_Seq_ID;
    @Override
    public UniqueId getSeq_ID() throws XtumlException {
        checkLiving();
        return ref_Seq_ID;
    }
    @Override
    public void setSeq_ID(UniqueId ref_Seq_ID) throws XtumlException {
        checkLiving();
        if (ref_Seq_ID.inequality( this.ref_Seq_ID)) {
            final UniqueId oldValue = this.ref_Seq_ID;
            this.ref_Seq_ID = ref_Seq_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Seq_ID", oldValue, this.ref_Seq_ID));
        }
    }
    private UniqueId ref_Previous_Svc_ID;
    @Override
    public void setPrevious_Svc_ID(UniqueId ref_Previous_Svc_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_Svc_ID.inequality( this.ref_Previous_Svc_ID)) {
            final UniqueId oldValue = this.ref_Previous_Svc_ID;
            this.ref_Previous_Svc_ID = ref_Previous_Svc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Svc_ID", oldValue, this.ref_Previous_Svc_ID));
        }
    }
    @Override
    public UniqueId getPrevious_Svc_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_Svc_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSvc_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private TerminatorServiceSequence R1659_TerminatorServiceSequence_inst;
    @Override
    public void setR1659_TerminatorServiceSequence( TerminatorServiceSequence inst ) {
        R1659_TerminatorServiceSequence_inst = inst;
    }
    @Override
    public TerminatorServiceSequence R1659_TerminatorServiceSequence() throws XtumlException {
        return R1659_TerminatorServiceSequence_inst;
    }
    private TerminatorService R1660_TerminatorService_inst;
    @Override
    public void setR1660_TerminatorService( TerminatorService inst ) {
        R1660_TerminatorService_inst = inst;
    }
    @Override
    public TerminatorService R1660_TerminatorService() throws XtumlException {
        return R1660_TerminatorService_inst;
    }
    private ServiceInSequence R1661_precedes_ServiceInSequence_inst;
    @Override
    public void setR1661_precedes_ServiceInSequence( ServiceInSequence inst ) {
        R1661_precedes_ServiceInSequence_inst = inst;
    }
    @Override
    public ServiceInSequence R1661_precedes_ServiceInSequence() throws XtumlException {
        return R1661_precedes_ServiceInSequence_inst;
    }
    private ServiceInSequence R1661_succeeds_ServiceInSequence_inst;
    @Override
    public void setR1661_succeeds_ServiceInSequence( ServiceInSequence inst ) {
        R1661_succeeds_ServiceInSequence_inst = inst;
    }
    @Override
    public ServiceInSequence R1661_succeeds_ServiceInSequence() throws XtumlException {
        return R1661_succeeds_ServiceInSequence_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ServiceInSequence self() {
        return this;
    }

    @Override
    public ServiceInSequence oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SERVICEINSEQUENCE;
    }

}

class EmptyServiceInSequence extends ModelInstance<ServiceInSequence,Sql> implements ServiceInSequence {

    // attributes
    public void setSvc_ID( UniqueId ref_Svc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSvc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSeq_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSeq_ID( UniqueId ref_Seq_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPrevious_Svc_ID( UniqueId ref_Previous_Svc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_Svc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public TerminatorServiceSequence R1659_TerminatorServiceSequence() {
        return TerminatorServiceSequenceImpl.EMPTY_TERMINATORSERVICESEQUENCE;
    }
    @Override
    public TerminatorService R1660_TerminatorService() {
        return TerminatorServiceImpl.EMPTY_TERMINATORSERVICE;
    }
    @Override
    public ServiceInSequence R1661_precedes_ServiceInSequence() {
        return ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
    }
    @Override
    public ServiceInSequence R1661_succeeds_ServiceInSequence() {
        return ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
    }


    @Override
    public String getKeyLetters() {
        return ServiceInSequenceImpl.KEY_LETTERS;
    }

    @Override
    public ServiceInSequence self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ServiceInSequence oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ServiceInSequenceImpl.EMPTY_SERVICEINSEQUENCE;
    }

}
