package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.constants.ConstantSpecification;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstantSet;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ConstantSpecificationImpl extends ModelInstance<ConstantSpecification,Sql> implements ConstantSpecification {

    public static final String KEY_LETTERS = "CNST_CSP";
    public static final ConstantSpecification EMPTY_CONSTANTSPECIFICATION = new EmptyConstantSpecification();

    private Sql context;

    // constructors
    private ConstantSpecificationImpl( Sql context ) {
        this.context = context;
        ref_Constant_Spec_ID = UniqueId.random();
        m_InformalGroupName = "";
        m_Descrip = "";
        R1504_contains_SymbolicConstant_set = new SymbolicConstantSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ConstantSpecificationImpl( Sql context, UniqueId instanceId, UniqueId ref_Constant_Spec_ID, String m_InformalGroupName, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Constant_Spec_ID = ref_Constant_Spec_ID;
        this.m_InformalGroupName = m_InformalGroupName;
        this.m_Descrip = m_Descrip;
        R1504_contains_SymbolicConstant_set = new SymbolicConstantSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static ConstantSpecification create( Sql context ) throws XtumlException {
        ConstantSpecification newConstantSpecification = new ConstantSpecificationImpl( context );
        if ( context.addInstance( newConstantSpecification ) ) {
            newConstantSpecification.getRunContext().addChange(new InstanceCreatedDelta(newConstantSpecification, KEY_LETTERS));
            return newConstantSpecification;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ConstantSpecification create( Sql context, UniqueId ref_Constant_Spec_ID, String m_InformalGroupName, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Constant_Spec_ID, m_InformalGroupName, m_Descrip);
    }

    public static ConstantSpecification create( Sql context, UniqueId instanceId, UniqueId ref_Constant_Spec_ID, String m_InformalGroupName, String m_Descrip ) throws XtumlException {
        ConstantSpecification newConstantSpecification = new ConstantSpecificationImpl( context, instanceId, ref_Constant_Spec_ID, m_InformalGroupName, m_Descrip );
        if ( context.addInstance( newConstantSpecification ) ) {
            return newConstantSpecification;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Constant_Spec_ID;
    @Override
    public void setConstant_Spec_ID(UniqueId ref_Constant_Spec_ID) throws XtumlException {
        checkLiving();
        if (ref_Constant_Spec_ID.inequality( this.ref_Constant_Spec_ID)) {
            final UniqueId oldValue = this.ref_Constant_Spec_ID;
            this.ref_Constant_Spec_ID = ref_Constant_Spec_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Constant_Spec_ID", oldValue, this.ref_Constant_Spec_ID));
            if ( !R1504_contains_SymbolicConstant().isEmpty() ) R1504_contains_SymbolicConstant().setConstant_Spec_ID( ref_Constant_Spec_ID );
        }
    }
    @Override
    public UniqueId getConstant_Spec_ID() throws XtumlException {
        checkLiving();
        return ref_Constant_Spec_ID;
    }
    private String m_InformalGroupName;
    @Override
    public void setInformalGroupName(String m_InformalGroupName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalGroupName, this.m_InformalGroupName)) {
            final String oldValue = this.m_InformalGroupName;
            this.m_InformalGroupName = m_InformalGroupName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalGroupName", oldValue, this.m_InformalGroupName));
        }
    }
    @Override
    public String getInformalGroupName() throws XtumlException {
        checkLiving();
        return m_InformalGroupName;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getConstant_Spec_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SymbolicConstantSet R1504_contains_SymbolicConstant_set;
    @Override
    public void addR1504_contains_SymbolicConstant( SymbolicConstant inst ) {
        R1504_contains_SymbolicConstant_set.add(inst);
    }
    @Override
    public void removeR1504_contains_SymbolicConstant( SymbolicConstant inst ) {
        R1504_contains_SymbolicConstant_set.remove(inst);
    }
    @Override
    public SymbolicConstantSet R1504_contains_SymbolicConstant() throws XtumlException {
        return R1504_contains_SymbolicConstant_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ConstantSpecification self() {
        return this;
    }

    @Override
    public ConstantSpecification oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CONSTANTSPECIFICATION;
    }

}

class EmptyConstantSpecification extends ModelInstance<ConstantSpecification,Sql> implements ConstantSpecification {

    // attributes
    public void setConstant_Spec_ID( UniqueId ref_Constant_Spec_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConstant_Spec_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalGroupName( String m_InformalGroupName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInformalGroupName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SymbolicConstantSet R1504_contains_SymbolicConstant() {
        return (new SymbolicConstantSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ConstantSpecificationImpl.KEY_LETTERS;
    }

    @Override
    public ConstantSpecification self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ConstantSpecification oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ConstantSpecificationImpl.EMPTY_CONSTANTSPECIFICATION;
    }

}
