package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.ExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.DataItemValue;
import io.ciera.tool.sql.ooaofooa.instance.DataItemValueSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.DataItemValueSetImpl;
import io.ciera.tool.sql.ooaofooa.message.ExecutablePropertyArgument;
import io.ciera.tool.sql.ooaofooa.message.ExecutablePropertyArgumentSet;
import io.ciera.tool.sql.ooaofooa.message.impl.ExecutablePropertyArgumentSetImpl;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReference;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReferenceSet;
import io.ciera.tool.sql.ooaofooa.value.ParameterValue;
import io.ciera.tool.sql.ooaofooa.value.ParameterValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.EventParameterReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ParameterValueSetImpl;


public class PropertyParameterImpl extends ModelInstance<PropertyParameter,Sql> implements PropertyParameter {

    public static final String KEY_LETTERS = "C_PP";
    public static final PropertyParameter EMPTY_PROPERTYPARAMETER = new EmptyPropertyParameter();

    private Sql context;

    // constructors
    private PropertyParameterImpl( Sql context ) {
        this.context = context;
        m_PP_Id = UniqueId.random();
        ref_Signal_Id = UniqueId.random();
        ref_DT_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_By_Ref = 0;
        m_Dimensions = "";
        ref_Previous_PP_Id = UniqueId.random();
        R1023_represents_ExecutablePropertyArgument_set = new ExecutablePropertyArgumentSetImpl();
        R2956_DataItemValue_set = new DataItemValueSetImpl();
        R4006_parameterizes_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4007_is_typed_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R4017_may_have_Dimensions_set = new DimensionsSetImpl();
        R4021_precedes_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
        R4021_succeeds_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
        R843_ParameterValue_set = new ParameterValueSetImpl();
        R847_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    private PropertyParameterImpl( Sql context, UniqueId instanceId, UniqueId m_PP_Id, UniqueId ref_Signal_Id, UniqueId ref_DT_ID, String m_Name, String m_Descrip, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_PP_Id ) {
        super(instanceId);
        this.context = context;
        this.m_PP_Id = m_PP_Id;
        this.ref_Signal_Id = ref_Signal_Id;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_By_Ref = m_By_Ref;
        this.m_Dimensions = m_Dimensions;
        this.ref_Previous_PP_Id = ref_Previous_PP_Id;
        R1023_represents_ExecutablePropertyArgument_set = new ExecutablePropertyArgumentSetImpl();
        R2956_DataItemValue_set = new DataItemValueSetImpl();
        R4006_parameterizes_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4007_is_typed_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R4017_may_have_Dimensions_set = new DimensionsSetImpl();
        R4021_precedes_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
        R4021_succeeds_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
        R843_ParameterValue_set = new ParameterValueSetImpl();
        R847_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    public static PropertyParameter create( Sql context ) throws XtumlException {
        PropertyParameter newPropertyParameter = new PropertyParameterImpl( context );
        if ( context.addInstance( newPropertyParameter ) ) {
            newPropertyParameter.getRunContext().addChange(new InstanceCreatedDelta(newPropertyParameter, KEY_LETTERS));
            return newPropertyParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PropertyParameter create( Sql context, UniqueId m_PP_Id, UniqueId ref_Signal_Id, UniqueId ref_DT_ID, String m_Name, String m_Descrip, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_PP_Id ) throws XtumlException {
        return create(context, UniqueId.random(), m_PP_Id, ref_Signal_Id, ref_DT_ID, m_Name, m_Descrip, m_By_Ref, m_Dimensions, ref_Previous_PP_Id);
    }

    public static PropertyParameter create( Sql context, UniqueId instanceId, UniqueId m_PP_Id, UniqueId ref_Signal_Id, UniqueId ref_DT_ID, String m_Name, String m_Descrip, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_PP_Id ) throws XtumlException {
        PropertyParameter newPropertyParameter = new PropertyParameterImpl( context, instanceId, m_PP_Id, ref_Signal_Id, ref_DT_ID, m_Name, m_Descrip, m_By_Ref, m_Dimensions, ref_Previous_PP_Id );
        if ( context.addInstance( newPropertyParameter ) ) {
            return newPropertyParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_PP_Id;
    @Override
    public UniqueId getPP_Id() throws XtumlException {
        checkLiving();
        return m_PP_Id;
    }
    @Override
    public void setPP_Id(UniqueId m_PP_Id) throws XtumlException {
        checkLiving();
        if (m_PP_Id.inequality( this.m_PP_Id)) {
            final UniqueId oldValue = this.m_PP_Id;
            this.m_PP_Id = m_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_PP_Id", oldValue, this.m_PP_Id));
            if ( !R2956_DataItemValue().isEmpty() ) R2956_DataItemValue().setPP_Id( m_PP_Id );
            if ( !R843_ParameterValue().isEmpty() ) R843_ParameterValue().setPP_Id( m_PP_Id );
            if ( !R1023_represents_ExecutablePropertyArgument().isEmpty() ) R1023_represents_ExecutablePropertyArgument().setPP_Id( m_PP_Id );
            if ( !R4017_may_have_Dimensions().isEmpty() ) R4017_may_have_Dimensions().setPP_Id( m_PP_Id );
            if ( !R847_EventParameterReference().isEmpty() ) R847_EventParameterReference().setPP_Id( m_PP_Id );
            if ( !R4021_precedes_PropertyParameter().isEmpty() ) R4021_precedes_PropertyParameter().setPrevious_PP_Id( m_PP_Id );
        }
    }
    private UniqueId ref_Signal_Id;
    @Override
    public UniqueId getSignal_Id() throws XtumlException {
        checkLiving();
        return ref_Signal_Id;
    }
    @Override
    public void setSignal_Id(UniqueId ref_Signal_Id) throws XtumlException {
        checkLiving();
        if (ref_Signal_Id.inequality( this.ref_Signal_Id)) {
            final UniqueId oldValue = this.ref_Signal_Id;
            this.ref_Signal_Id = ref_Signal_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Signal_Id", oldValue, this.ref_Signal_Id));
        }
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private int m_By_Ref;
    @Override
    public int getBy_Ref() throws XtumlException {
        checkLiving();
        return m_By_Ref;
    }
    @Override
    public void setBy_Ref(int m_By_Ref) throws XtumlException {
        checkLiving();
        if (m_By_Ref != this.m_By_Ref) {
            final int oldValue = this.m_By_Ref;
            this.m_By_Ref = m_By_Ref;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_By_Ref", oldValue, this.m_By_Ref));
        }
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }
    private UniqueId ref_Previous_PP_Id;
    @Override
    public UniqueId getPrevious_PP_Id() throws XtumlException {
        checkLiving();
        return ref_Previous_PP_Id;
    }
    @Override
    public void setPrevious_PP_Id(UniqueId ref_Previous_PP_Id) throws XtumlException {
        checkLiving();
        if (ref_Previous_PP_Id.inequality( this.ref_Previous_PP_Id)) {
            final UniqueId oldValue = this.ref_Previous_PP_Id;
            this.ref_Previous_PP_Id = ref_Previous_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_PP_Id", oldValue, this.ref_Previous_PP_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPP_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ExecutablePropertyArgumentSet R1023_represents_ExecutablePropertyArgument_set;
    @Override
    public void addR1023_represents_ExecutablePropertyArgument( ExecutablePropertyArgument inst ) {
        R1023_represents_ExecutablePropertyArgument_set.add(inst);
    }
    @Override
    public void removeR1023_represents_ExecutablePropertyArgument( ExecutablePropertyArgument inst ) {
        R1023_represents_ExecutablePropertyArgument_set.remove(inst);
    }
    @Override
    public ExecutablePropertyArgumentSet R1023_represents_ExecutablePropertyArgument() throws XtumlException {
        return R1023_represents_ExecutablePropertyArgument_set;
    }
    private DataItemValueSet R2956_DataItemValue_set;
    @Override
    public void addR2956_DataItemValue( DataItemValue inst ) {
        R2956_DataItemValue_set.add(inst);
    }
    @Override
    public void removeR2956_DataItemValue( DataItemValue inst ) {
        R2956_DataItemValue_set.remove(inst);
    }
    @Override
    public DataItemValueSet R2956_DataItemValue() throws XtumlException {
        return R2956_DataItemValue_set;
    }
    private ExecutableProperty R4006_parameterizes_ExecutableProperty_inst;
    @Override
    public void setR4006_parameterizes_ExecutableProperty( ExecutableProperty inst ) {
        R4006_parameterizes_ExecutableProperty_inst = inst;
    }
    @Override
    public ExecutableProperty R4006_parameterizes_ExecutableProperty() throws XtumlException {
        return R4006_parameterizes_ExecutableProperty_inst;
    }
    private DataType R4007_is_typed_by_DataType_inst;
    @Override
    public void setR4007_is_typed_by_DataType( DataType inst ) {
        R4007_is_typed_by_DataType_inst = inst;
    }
    @Override
    public DataType R4007_is_typed_by_DataType() throws XtumlException {
        return R4007_is_typed_by_DataType_inst;
    }
    private DimensionsSet R4017_may_have_Dimensions_set;
    @Override
    public void addR4017_may_have_Dimensions( Dimensions inst ) {
        R4017_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR4017_may_have_Dimensions( Dimensions inst ) {
        R4017_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R4017_may_have_Dimensions() throws XtumlException {
        return R4017_may_have_Dimensions_set;
    }
    private PropertyParameter R4021_precedes_PropertyParameter_inst;
    @Override
    public void setR4021_precedes_PropertyParameter( PropertyParameter inst ) {
        R4021_precedes_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R4021_precedes_PropertyParameter() throws XtumlException {
        return R4021_precedes_PropertyParameter_inst;
    }
    private PropertyParameter R4021_succeeds_PropertyParameter_inst;
    @Override
    public void setR4021_succeeds_PropertyParameter( PropertyParameter inst ) {
        R4021_succeeds_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R4021_succeeds_PropertyParameter() throws XtumlException {
        return R4021_succeeds_PropertyParameter_inst;
    }
    private ParameterValueSet R843_ParameterValue_set;
    @Override
    public void addR843_ParameterValue( ParameterValue inst ) {
        R843_ParameterValue_set.add(inst);
    }
    @Override
    public void removeR843_ParameterValue( ParameterValue inst ) {
        R843_ParameterValue_set.remove(inst);
    }
    @Override
    public ParameterValueSet R843_ParameterValue() throws XtumlException {
        return R843_ParameterValue_set;
    }
    private EventParameterReferenceSet R847_EventParameterReference_set;
    @Override
    public void addR847_EventParameterReference( EventParameterReference inst ) {
        R847_EventParameterReference_set.add(inst);
    }
    @Override
    public void removeR847_EventParameterReference( EventParameterReference inst ) {
        R847_EventParameterReference_set.remove(inst);
    }
    @Override
    public EventParameterReferenceSet R847_EventParameterReference() throws XtumlException {
        return R847_EventParameterReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PropertyParameter self() {
        return this;
    }

    @Override
    public PropertyParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PROPERTYPARAMETER;
    }

}

class EmptyPropertyParameter extends ModelInstance<PropertyParameter,Sql> implements PropertyParameter {

    // attributes
    public UniqueId getPP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPP_Id( UniqueId m_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSignal_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSignal_Id( UniqueId ref_Signal_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getBy_Ref() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBy_Ref( int m_By_Ref ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_PP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_PP_Id( UniqueId ref_Previous_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ExecutablePropertyArgumentSet R1023_represents_ExecutablePropertyArgument() {
        return (new ExecutablePropertyArgumentSetImpl());
    }
    @Override
    public DataItemValueSet R2956_DataItemValue() {
        return (new DataItemValueSetImpl());
    }
    @Override
    public ExecutableProperty R4006_parameterizes_ExecutableProperty() {
        return ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
    }
    @Override
    public DataType R4007_is_typed_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R4017_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public PropertyParameter R4021_precedes_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }
    @Override
    public PropertyParameter R4021_succeeds_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }
    @Override
    public ParameterValueSet R843_ParameterValue() {
        return (new ParameterValueSetImpl());
    }
    @Override
    public EventParameterReferenceSet R847_EventParameterReference() {
        return (new EventParameterReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return PropertyParameterImpl.KEY_LETTERS;
    }

    @Override
    public PropertyParameter self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PropertyParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

}
