package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.BodyInComponent;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;


public class BodyInComponentImpl extends ModelInstance<BodyInComponent,Sql> implements BodyInComponent {

    public static final String KEY_LETTERS = "ACT_BIC";
    public static final BodyInComponent EMPTY_BODYINCOMPONENT = new EmptyBodyInComponent();

    private Sql context;

    // constructors
    private BodyInComponentImpl( Sql context ) {
        this.context = context;
        ref_Component_Id = UniqueId.random();
        ref_Action_ID = UniqueId.random();
        R694_has_declared_Body_inst = BodyImpl.EMPTY_BODY;
        R694_is_declared_in_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    private BodyInComponentImpl( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Action_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Component_Id = ref_Component_Id;
        this.ref_Action_ID = ref_Action_ID;
        R694_has_declared_Body_inst = BodyImpl.EMPTY_BODY;
        R694_is_declared_in_C_C_inst = C_CImpl.EMPTY_C_C;
    }

    public static BodyInComponent create( Sql context ) throws XtumlException {
        BodyInComponent newBodyInComponent = new BodyInComponentImpl( context );
        if ( context.addInstance( newBodyInComponent ) ) {
            newBodyInComponent.getRunContext().addChange(new InstanceCreatedDelta(newBodyInComponent, KEY_LETTERS));
            return newBodyInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BodyInComponent create( Sql context, UniqueId ref_Component_Id, UniqueId ref_Action_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Component_Id, ref_Action_ID);
    }

    public static BodyInComponent create( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Action_ID ) throws XtumlException {
        BodyInComponent newBodyInComponent = new BodyInComponentImpl( context, instanceId, ref_Component_Id, ref_Action_ID );
        if ( context.addInstance( newBodyInComponent ) ) {
            return newBodyInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Component_Id;
    @Override
    public void setComponent_Id(UniqueId ref_Component_Id) throws XtumlException {
        checkLiving();
        if (ref_Component_Id.inequality( this.ref_Component_Id)) {
            final UniqueId oldValue = this.ref_Component_Id;
            this.ref_Component_Id = ref_Component_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Component_Id", oldValue, this.ref_Component_Id));
        }
    }
    @Override
    public UniqueId getComponent_Id() throws XtumlException {
        checkLiving();
        return ref_Component_Id;
    }
    private UniqueId ref_Action_ID;
    @Override
    public void setAction_ID(UniqueId ref_Action_ID) throws XtumlException {
        checkLiving();
        if (ref_Action_ID.inequality( this.ref_Action_ID)) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
        return ref_Action_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComponent_Id(), getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Body R694_has_declared_Body_inst;
    @Override
    public void setR694_has_declared_Body( Body inst ) {
        R694_has_declared_Body_inst = inst;
    }
    @Override
    public Body R694_has_declared_Body() throws XtumlException {
        return R694_has_declared_Body_inst;
    }
    private C_C R694_is_declared_in_C_C_inst;
    @Override
    public void setR694_is_declared_in_C_C( C_C inst ) {
        R694_is_declared_in_C_C_inst = inst;
    }
    @Override
    public C_C R694_is_declared_in_C_C() throws XtumlException {
        return R694_is_declared_in_C_C_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BodyInComponent self() {
        return this;
    }

    @Override
    public BodyInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BODYINCOMPONENT;
    }

}

class EmptyBodyInComponent extends ModelInstance<BodyInComponent,Sql> implements BodyInComponent {

    // attributes
    public void setComponent_Id( UniqueId ref_Component_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getComponent_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Body R694_has_declared_Body() {
        return BodyImpl.EMPTY_BODY;
    }
    @Override
    public C_C R694_is_declared_in_C_C() {
        return C_CImpl.EMPTY_C_C;
    }


    @Override
    public String getKeyLetters() {
        return BodyInComponentImpl.KEY_LETTERS;
    }

    @Override
    public BodyInComponent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BodyInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BodyInComponentImpl.EMPTY_BODYINCOMPONENT;
    }

}
