package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ControlNode;
import io.ciera.tool.sql.ooaofooa.activity.DecisionMergeNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ControlNodeImpl;


public class DecisionMergeNodeImpl extends ModelInstance<DecisionMergeNode,Sql> implements DecisionMergeNode {

    public static final String KEY_LETTERS = "A_DM";
    public static final DecisionMergeNode EMPTY_DECISIONMERGENODE = new EmptyDecisionMergeNode();

    private Sql context;

    // constructors
    private DecisionMergeNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1106_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
    }

    private DecisionMergeNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1106_is_a_ControlNode_inst = ControlNodeImpl.EMPTY_CONTROLNODE;
    }

    public static DecisionMergeNode create( Sql context ) throws XtumlException {
        DecisionMergeNode newDecisionMergeNode = new DecisionMergeNodeImpl( context );
        if ( context.addInstance( newDecisionMergeNode ) ) {
            newDecisionMergeNode.getRunContext().addChange(new InstanceCreatedDelta(newDecisionMergeNode, KEY_LETTERS));
            return newDecisionMergeNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DecisionMergeNode create( Sql context, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Id, m_Name, m_Descrip);
    }

    public static DecisionMergeNode create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        DecisionMergeNode newDecisionMergeNode = new DecisionMergeNodeImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newDecisionMergeNode ) ) {
            return newDecisionMergeNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ControlNode R1106_is_a_ControlNode_inst;
    @Override
    public void setR1106_is_a_ControlNode( ControlNode inst ) {
        R1106_is_a_ControlNode_inst = inst;
    }
    @Override
    public ControlNode R1106_is_a_ControlNode() throws XtumlException {
        return R1106_is_a_ControlNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DecisionMergeNode self() {
        return this;
    }

    @Override
    public DecisionMergeNode oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_DECISIONMERGENODE;
    }

}

class EmptyDecisionMergeNode extends ModelInstance<DecisionMergeNode,Sql> implements DecisionMergeNode {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ControlNode R1106_is_a_ControlNode() {
        return ControlNodeImpl.EMPTY_CONTROLNODE;
    }


    @Override
    public String getKeyLetters() {
        return DecisionMergeNodeImpl.KEY_LETTERS;
    }

    @Override
    public DecisionMergeNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DecisionMergeNode oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return DecisionMergeNodeImpl.EMPTY_DECISIONMERGENODE;
    }

}
