package io.ciera.tool.sql.ooaofmarking.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofmarking.Feature;
import io.ciera.tool.sql.ooaofmarking.FeatureSet;
import io.ciera.tool.sql.ooaofmarking.Mark;
import io.ciera.tool.sql.ooaofmarking.MarkSet;
import io.ciera.tool.sql.ooaofmarking.MarkableElementType;
import io.ciera.tool.sql.ooaofmarking.impl.FeatureSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkableElementTypeImpl;

import java.util.Iterator;


public class MarkableElementTypeImpl extends ModelInstance<MarkableElementType,Sql> implements MarkableElementType {

    public static final String KEY_LETTERS = "Markable";
    public static final MarkableElementType EMPTY_MARKABLEELEMENTTYPE = new EmptyMarkableElementType();

    private Sql context;

    // constructors
    private MarkableElementTypeImpl( Sql context ) {
        this.context = context;
        m_name = "";
        R2821_is_marked_by_Mark_set = new MarkSetImpl();
        R2822_makes_available_Feature_set = new FeatureSetImpl();
    }

    private MarkableElementTypeImpl( Sql context, UniqueId instanceId, String m_name ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        R2821_is_marked_by_Mark_set = new MarkSetImpl();
        R2822_makes_available_Feature_set = new FeatureSetImpl();
    }

    public static MarkableElementType create( Sql context ) throws XtumlException {
        MarkableElementType newMarkableElementType = new MarkableElementTypeImpl( context );
        if ( context.addInstance( newMarkableElementType ) ) {
            newMarkableElementType.getRunContext().addChange(new InstanceCreatedDelta(newMarkableElementType, KEY_LETTERS));
            return newMarkableElementType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MarkableElementType create( Sql context, String m_name ) throws XtumlException {
        return create(context, UniqueId.random(), m_name);
    }

    public static MarkableElementType create( Sql context, UniqueId instanceId, String m_name ) throws XtumlException {
        MarkableElementType newMarkableElementType = new MarkableElementTypeImpl( context, instanceId, m_name );
        if ( context.addInstance( newMarkableElementType ) ) {
            return newMarkableElementType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R2821_is_marked_by_Mark().isEmpty() ) R2821_is_marked_by_Mark().setMarkable_name( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void dispose() throws XtumlException {
        FeatureSet features = self().R2822_makes_available_Feature();
        Feature feature;
        for ( Iterator<Feature> _feature_iter = features.elements().iterator(); _feature_iter.hasNext(); ) {
            feature = _feature_iter.next();
            context().unrelate_R2822_Feature_is_available_for_MarkableElementType( feature, self() );
        }
        self().delete();
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public MarkableElementType populate( final String p_name ) throws XtumlException {
            MarkableElementType markable = context().MarkableElementType_instances().anyWhere(selected -> StringUtil.equality(((MarkableElementType)selected).getName(), p_name));
            if ( markable.isEmpty() ) {
                markable = MarkableElementTypeImpl.create( context() );
                markable.setName(p_name);
            }
            return markable;
        }



    }


    // events


    // selections
    private MarkSet R2821_is_marked_by_Mark_set;
    @Override
    public void addR2821_is_marked_by_Mark( Mark inst ) {
        R2821_is_marked_by_Mark_set.add(inst);
    }
    @Override
    public void removeR2821_is_marked_by_Mark( Mark inst ) {
        R2821_is_marked_by_Mark_set.remove(inst);
    }
    @Override
    public MarkSet R2821_is_marked_by_Mark() throws XtumlException {
        return R2821_is_marked_by_Mark_set;
    }
    private FeatureSet R2822_makes_available_Feature_set;
    @Override
    public void addR2822_makes_available_Feature( Feature inst ) {
        R2822_makes_available_Feature_set.add(inst);
    }
    @Override
    public void removeR2822_makes_available_Feature( Feature inst ) {
        R2822_makes_available_Feature_set.remove(inst);
    }
    @Override
    public FeatureSet R2822_makes_available_Feature() throws XtumlException {
        return R2822_makes_available_Feature_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MarkableElementType self() {
        return this;
    }

    @Override
    public MarkableElementType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MARKABLEELEMENTTYPE;
    }

}

class EmptyMarkableElementType extends ModelInstance<MarkableElementType,Sql> implements MarkableElementType {

    // attributes
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void dispose() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public MarkSet R2821_is_marked_by_Mark() {
        return (new MarkSetImpl());
    }
    @Override
    public FeatureSet R2822_makes_available_Feature() {
        return (new FeatureSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return MarkableElementTypeImpl.KEY_LETTERS;
    }

    @Override
    public MarkableElementType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MarkableElementType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MarkableElementTypeImpl.EMPTY_MARKABLEELEMENTTYPE;
    }

}
