package io.ciera.tool.sql.compiler.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.compiler.CIERA;
import io.ciera.tool.sql.compiler.impl.CIERAImpl;


public class CIERAImpl extends ModelInstance<CIERA,Sql> implements CIERA {

    public static final String KEY_LETTERS = "CIERA";
    public static final CIERA EMPTY_CIERA = new EmptyCIERA();

    private Sql context;

    // constructors
    private CIERAImpl( Sql context ) {
        this.context = context;
        m_name = "";
        m_projectroot = "";
        m_version = "";
    }

    private CIERAImpl( Sql context, UniqueId instanceId, String m_name, String m_projectroot, String m_version ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        this.m_projectroot = m_projectroot;
        this.m_version = m_version;
    }

    public static CIERA create( Sql context ) throws XtumlException {
        CIERA newCIERA = new CIERAImpl( context );
        if ( context.addInstance( newCIERA ) ) {
            newCIERA.getRunContext().addChange(new InstanceCreatedDelta(newCIERA, KEY_LETTERS));
            return newCIERA;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CIERA create( Sql context, String m_name, String m_projectroot, String m_version ) throws XtumlException {
        return create(context, UniqueId.random(), m_name, m_projectroot, m_version);
    }

    public static CIERA create( Sql context, UniqueId instanceId, String m_name, String m_projectroot, String m_version ) throws XtumlException {
        CIERA newCIERA = new CIERAImpl( context, instanceId, m_name, m_projectroot, m_version );
        if ( context.addInstance( newCIERA ) ) {
            return newCIERA;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    private String m_projectroot;
    @Override
    public String getProjectroot() throws XtumlException {
        checkLiving();
        return m_projectroot;
    }
    @Override
    public void setProjectroot(String m_projectroot) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_projectroot, this.m_projectroot)) {
            final String oldValue = this.m_projectroot;
            this.m_projectroot = m_projectroot;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_projectroot", oldValue, this.m_projectroot));
        }
    }
    private String m_version;
    @Override
    public String getVersion() throws XtumlException {
        checkLiving();
        return m_version;
    }
    @Override
    public void setVersion(String m_version) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_version, this.m_version)) {
            final String oldValue = this.m_version;
            this.m_version = m_version;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_version", oldValue, this.m_version));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public CIERA getDefaultInstance() throws XtumlException {
            CIERA ciera = context().CIERA_instances().anyWhere(selected -> StringUtil.equality(((CIERA)selected).getName(), "default"));
            if ( ciera.isEmpty() ) {
                ciera = CIERAImpl.create( context() );
                ciera.setName("default");
                ciera.setProjectroot("");
            }
            return ciera;
        }

        public void setprojectroot( final String p_value ) throws XtumlException {
            CIERA ciera = new CIERAImpl.CLASS(context()).getDefaultInstance();
            ciera.setProjectroot(p_value);
        }

        public void setversion( final String p_value ) throws XtumlException {
            CIERA ciera = new CIERAImpl.CLASS(context()).getDefaultInstance();
            ciera.setVersion(p_value);
        }



    }


    // events


    // selections


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CIERA self() {
        return this;
    }

    @Override
    public CIERA oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CIERA;
    }

}

class EmptyCIERA extends ModelInstance<CIERA,Sql> implements CIERA {

    // attributes
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getProjectroot() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setProjectroot( String m_projectroot ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getVersion() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVersion( String m_version ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections


    @Override
    public String getKeyLetters() {
        return CIERAImpl.KEY_LETTERS;
    }

    @Override
    public CIERA self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CIERA oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CIERAImpl.EMPTY_CIERA;
    }

}
