package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.UnresolvedType;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;


public class UnresolvedTypeImpl extends ModelInstance<UnresolvedType,Sql> implements UnresolvedType {

    public static final String KEY_LETTERS = "UnresolvedType";
    public static final UnresolvedType EMPTY_UNRESOLVEDTYPE = new EmptyUnresolvedType();

    private Sql context;

    // constructors
    private UnresolvedTypeImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_num = 0;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    private UnresolvedTypeImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, int m_num ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_num = m_num;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    public static UnresolvedType create( Sql context ) throws XtumlException {
        UnresolvedType newUnresolvedType = new UnresolvedTypeImpl( context );
        if ( context.addInstance( newUnresolvedType ) ) {
            newUnresolvedType.getRunContext().addChange(new InstanceCreatedDelta(newUnresolvedType, KEY_LETTERS));
            return newUnresolvedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UnresolvedType create( Sql context, String ref_name, String ref_package, int m_num ) throws XtumlException {
        return create(context, UniqueId.random(), ref_name, ref_package, m_num);
    }

    public static UnresolvedType create( Sql context, UniqueId instanceId, String ref_name, String ref_package, int m_num ) throws XtumlException {
        UnresolvedType newUnresolvedType = new UnresolvedTypeImpl( context, instanceId, ref_name, ref_package, m_num );
        if ( context.addInstance( newUnresolvedType ) ) {
            return newUnresolvedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
        }
    }
    private int m_num;
    @Override
    public void setNum(int m_num) throws XtumlException {
        checkLiving();
        if (m_num != this.m_num) {
            final int oldValue = this.m_num;
            this.m_num = m_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_num", oldValue, this.m_num));
        }
    }
    @Override
    public int getNum() throws XtumlException {
        checkLiving();
        return m_num;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getNum());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void dispose() throws XtumlException {
        Type type = self().R407_is_a_Type();
        context().unrelate_R407_UnresolvedType_is_a_Type( self(), type );
        self().delete();
    }



    // static operations


    // events


    // selections
    private Type R407_is_a_Type_inst;
    @Override
    public void setR407_is_a_Type( Type inst ) {
        R407_is_a_Type_inst = inst;
    }
    @Override
    public Type R407_is_a_Type() throws XtumlException {
        return R407_is_a_Type_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UnresolvedType self() {
        return this;
    }

    @Override
    public UnresolvedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_UNRESOLVEDTYPE;
    }

}

class EmptyUnresolvedType extends ModelInstance<UnresolvedType,Sql> implements UnresolvedType {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setNum( int m_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNum() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void dispose() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Type R407_is_a_Type() {
        return TypeImpl.EMPTY_TYPE;
    }


    @Override
    public String getKeyLetters() {
        return UnresolvedTypeImpl.KEY_LETTERS;
    }

    @Override
    public UnresolvedType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UnresolvedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
    }

}
