package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.EnumeratorReference;
import io.ciera.tool.sql.architecture.expression.EnumeratorReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.EnumeratorReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeImpl;


public class EnumeratorImpl extends ModelInstance<Enumerator,Sql> implements Enumerator {

    public static final String KEY_LETTERS = "Enumerator";
    public static final Enumerator EMPTY_ENUMERATOR = new EmptyEnumerator();

    private Sql context;

    // constructors
    private EnumeratorImpl( Sql context ) {
        this.context = context;
        ref_type_name = "";
        ref_type_package = "";
        m_name = "";
        m_value = 0;
        R415_is_unique_value_of_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R786_is_referenced_by_EnumeratorReference_set = new EnumeratorReferenceSetImpl();
    }

    private EnumeratorImpl( Sql context, UniqueId instanceId, String ref_type_name, String ref_type_package, String m_name, int m_value ) {
        super(instanceId);
        this.context = context;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.m_name = m_name;
        this.m_value = m_value;
        R415_is_unique_value_of_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R786_is_referenced_by_EnumeratorReference_set = new EnumeratorReferenceSetImpl();
    }

    public static Enumerator create( Sql context ) throws XtumlException {
        Enumerator newEnumerator = new EnumeratorImpl( context );
        if ( context.addInstance( newEnumerator ) ) {
            newEnumerator.getRunContext().addChange(new InstanceCreatedDelta(newEnumerator, KEY_LETTERS));
            return newEnumerator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Enumerator create( Sql context, String ref_type_name, String ref_type_package, String m_name, int m_value ) throws XtumlException {
        return create(context, UniqueId.random(), ref_type_name, ref_type_package, m_name, m_value);
    }

    public static Enumerator create( Sql context, UniqueId instanceId, String ref_type_name, String ref_type_package, String m_name, int m_value ) throws XtumlException {
        Enumerator newEnumerator = new EnumeratorImpl( context, instanceId, ref_type_name, ref_type_package, m_name, m_value );
        if ( context.addInstance( newEnumerator ) ) {
            return newEnumerator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_type_name;
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
            if ( !R786_is_referenced_by_EnumeratorReference().isEmpty() ) R786_is_referenced_by_EnumeratorReference().setEnum_type_name( ref_type_name );
        }
    }
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
            if ( !R786_is_referenced_by_EnumeratorReference().isEmpty() ) R786_is_referenced_by_EnumeratorReference().setEnum_type_package( ref_type_package );
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R786_is_referenced_by_EnumeratorReference().isEmpty() ) R786_is_referenced_by_EnumeratorReference().setEnum_name( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    private int m_value;
    @Override
    public void setValue(int m_value) throws XtumlException {
        checkLiving();
        if (m_value != this.m_value) {
            final int oldValue = this.m_value;
            this.m_value = m_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_value", oldValue, this.m_value));
        }
    }
    @Override
    public int getValue() throws XtumlException {
        checkLiving();
        return m_value;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getType_name(), getType_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "type/t.enumerator.java", self() );
    }

    @Override
    public void render_accessor() throws XtumlException {
        context().T().include( "type/t.enumeratoraccessor.java", self() );
    }



    // static operations


    // events


    // selections
    private EnumeratedType R415_is_unique_value_of_EnumeratedType_inst;
    @Override
    public void setR415_is_unique_value_of_EnumeratedType( EnumeratedType inst ) {
        R415_is_unique_value_of_EnumeratedType_inst = inst;
    }
    @Override
    public EnumeratedType R415_is_unique_value_of_EnumeratedType() throws XtumlException {
        return R415_is_unique_value_of_EnumeratedType_inst;
    }
    private EnumeratorReferenceSet R786_is_referenced_by_EnumeratorReference_set;
    @Override
    public void addR786_is_referenced_by_EnumeratorReference( EnumeratorReference inst ) {
        R786_is_referenced_by_EnumeratorReference_set.add(inst);
    }
    @Override
    public void removeR786_is_referenced_by_EnumeratorReference( EnumeratorReference inst ) {
        R786_is_referenced_by_EnumeratorReference_set.remove(inst);
    }
    @Override
    public EnumeratorReferenceSet R786_is_referenced_by_EnumeratorReference() throws XtumlException {
        return R786_is_referenced_by_EnumeratorReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Enumerator self() {
        return this;
    }

    @Override
    public Enumerator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ENUMERATOR;
    }

}

class EmptyEnumerator extends ModelInstance<Enumerator,Sql> implements Enumerator {

    // attributes
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue( int m_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_accessor() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public EnumeratedType R415_is_unique_value_of_EnumeratedType() {
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }
    @Override
    public EnumeratorReferenceSet R786_is_referenced_by_EnumeratorReference() {
        return (new EnumeratorReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return EnumeratorImpl.KEY_LETTERS;
    }

    @Override
    public Enumerator self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Enumerator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EnumeratorImpl.EMPTY_ENUMERATOR;
    }

}
