package io.ciera.tool.sql.architecture.invocable.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.invocable.GenericInvocable;
import io.ciera.tool.sql.architecture.invocable.GenericInvocableSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class GenericInvocableSetImpl extends InstanceSet<GenericInvocableSet,GenericInvocable> implements GenericInvocableSet {

    public GenericInvocableSetImpl() {
    }

    public GenericInvocableSetImpl(Comparator<? super GenericInvocable> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( GenericInvocable genericinvocable : this ) genericinvocable.setName( ref_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( GenericInvocable genericinvocable : this ) genericinvocable.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( GenericInvocable genericinvocable : this ) genericinvocable.setParent_package( ref_parent_package );
    }


    // selections
    @Override
    public InvocableObjectSet R427_is_a_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( GenericInvocable genericinvocable : this ) invocableobjectset.add( genericinvocable.R427_is_a_InvocableObject() );
        return invocableobjectset;
    }


    @Override
    public GenericInvocable nullElement() {
        return GenericInvocableImpl.EMPTY_GENERICINVOCABLE;
    }

    @Override
    public GenericInvocableSet emptySet() {
      return new GenericInvocableSetImpl();
    }

    @Override
    public GenericInvocableSet emptySet(Comparator<? super GenericInvocable> comp) {
      return new GenericInvocableSetImpl(comp);
    }

    @Override
    public List<GenericInvocable> elements() {
        GenericInvocable[] elements = toArray(new GenericInvocable[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
