package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.impl.ApplicationImpl;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.InstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.file.TypeImportReference;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.file.TypeImportSet;
import io.ciera.tool.sql.architecture.file.impl.GeneralFileImpl;
import io.ciera.tool.sql.architecture.file.impl.TypeImportReferenceSetImpl;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.impl.IfaceImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortImpl;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeImpl;

import java.util.Iterator;

import types.ImportType;


public class FileImpl extends ModelInstance<File,Sql> implements File {

    public static final String KEY_LETTERS = "File";
    public static final File EMPTY_FILE = new EmptyFile();

    private Sql context;

    // constructors
    private FileImpl( Sql context ) {
        this.context = context;
        m_name = "";
        m_package = "";
        m_path = "";
        m_extension = "";
        m_exclude = false;
        R401_is_a_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
        R401_is_a_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R401_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R401_is_a_GeneralFile_inst = GeneralFileImpl.EMPTY_GENERALFILE;
        R401_is_a_Iface_inst = IfaceImpl.EMPTY_IFACE;
        R401_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R401_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R401_is_a_Port_inst = PortImpl.EMPTY_PORT;
        R401_is_a_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R401_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R401_is_a_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R402_imports_type_via_TypeImportReference_set = new TypeImportReferenceSetImpl();
    }

    private FileImpl( Sql context, UniqueId instanceId, String m_name, String m_package, String m_path, String m_extension, boolean m_exclude ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        this.m_package = m_package;
        this.m_path = m_path;
        this.m_extension = m_extension;
        this.m_exclude = m_exclude;
        R401_is_a_Application_inst = ApplicationImpl.EMPTY_APPLICATION;
        R401_is_a_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R401_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R401_is_a_GeneralFile_inst = GeneralFileImpl.EMPTY_GENERALFILE;
        R401_is_a_Iface_inst = IfaceImpl.EMPTY_IFACE;
        R401_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R401_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R401_is_a_Port_inst = PortImpl.EMPTY_PORT;
        R401_is_a_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R401_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R401_is_a_Utility_inst = UtilityImpl.EMPTY_UTILITY;
        R402_imports_type_via_TypeImportReference_set = new TypeImportReferenceSetImpl();
    }

    public static File create( Sql context ) throws XtumlException {
        File newFile = new FileImpl( context );
        if ( context.addInstance( newFile ) ) {
            newFile.getRunContext().addChange(new InstanceCreatedDelta(newFile, KEY_LETTERS));
            return newFile;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static File create( Sql context, String m_name, String m_package, String m_path, String m_extension, boolean m_exclude ) throws XtumlException {
        return create(context, UniqueId.random(), m_name, m_package, m_path, m_extension, m_exclude);
    }

    public static File create( Sql context, UniqueId instanceId, String m_name, String m_package, String m_path, String m_extension, boolean m_exclude ) throws XtumlException {
        File newFile = new FileImpl( context, instanceId, m_name, m_package, m_path, m_extension, m_exclude );
        if ( context.addInstance( newFile ) ) {
            return newFile;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R401_is_a_UserDefinedType().isEmpty() ) R401_is_a_UserDefinedType().setName( m_name );
            if ( !R401_is_a_GeneralFile().isEmpty() ) R401_is_a_GeneralFile().setName( m_name );
            if ( !R401_is_a_Iface().isEmpty() ) R401_is_a_Iface().setName( m_name );
            if ( !R402_imports_type_via_TypeImportReference().isEmpty() ) R402_imports_type_via_TypeImportReference().setFile_name( m_name );
            if ( !R401_is_a_ModelInst().isEmpty() ) R401_is_a_ModelInst().setName( m_name );
            if ( !R401_is_a_Utility().isEmpty() ) R401_is_a_Utility().setName( m_name );
            if ( !R401_is_a_EnumeratedType().isEmpty() ) R401_is_a_EnumeratedType().setName( m_name );
            if ( !R401_is_a_Application().isEmpty() ) R401_is_a_Application().setName( m_name );
            if ( !R401_is_a_InstSet().isEmpty() ) R401_is_a_InstSet().setName( m_name );
            if ( !R401_is_a_Port().isEmpty() ) R401_is_a_Port().setName( m_name );
            if ( !R401_is_a_StateMachine().isEmpty() ) R401_is_a_StateMachine().setName( m_name );
            if ( !R401_is_a_ComponentDefinition().isEmpty() ) R401_is_a_ComponentDefinition().setName( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    private String m_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return m_package;
    }
    @Override
    public void setPackage(String m_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_package, this.m_package)) {
            final String oldValue = this.m_package;
            this.m_package = m_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_package", oldValue, this.m_package));
            if ( !R401_is_a_Port().isEmpty() ) R401_is_a_Port().setPackage( m_package );
            if ( !R401_is_a_InstSet().isEmpty() ) R401_is_a_InstSet().setPackage( m_package );
            if ( !R401_is_a_StateMachine().isEmpty() ) R401_is_a_StateMachine().setPackage( m_package );
            if ( !R401_is_a_EnumeratedType().isEmpty() ) R401_is_a_EnumeratedType().setPackage( m_package );
            if ( !R401_is_a_Application().isEmpty() ) R401_is_a_Application().setPackage( m_package );
            if ( !R401_is_a_UserDefinedType().isEmpty() ) R401_is_a_UserDefinedType().setPackage( m_package );
            if ( !R401_is_a_ComponentDefinition().isEmpty() ) R401_is_a_ComponentDefinition().setPackage( m_package );
            if ( !R401_is_a_ModelInst().isEmpty() ) R401_is_a_ModelInst().setPackage( m_package );
            if ( !R401_is_a_Utility().isEmpty() ) R401_is_a_Utility().setPackage( m_package );
            if ( !R402_imports_type_via_TypeImportReference().isEmpty() ) R402_imports_type_via_TypeImportReference().setFile_package( m_package );
            if ( !R401_is_a_GeneralFile().isEmpty() ) R401_is_a_GeneralFile().setPackage( m_package );
            if ( !R401_is_a_Iface().isEmpty() ) R401_is_a_Iface().setPackage( m_package );
        }
    }
    private String m_path;
    @Override
    public void setPath(String m_path) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_path, this.m_path)) {
            final String oldValue = this.m_path;
            this.m_path = m_path;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_path", oldValue, this.m_path));
        }
    }
    @Override
    public String getPath() throws XtumlException {
        checkLiving();
        return m_path;
    }
    private String m_extension;
    @Override
    public String getExtension() throws XtumlException {
        checkLiving();
        return m_extension;
    }
    @Override
    public void setExtension(String m_extension) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_extension, this.m_extension)) {
            final String oldValue = this.m_extension;
            this.m_extension = m_extension;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_extension", oldValue, this.m_extension));
        }
    }
    private boolean m_exclude;
    @Override
    public void setExclude(boolean m_exclude) throws XtumlException {
        checkLiving();
        if (m_exclude != this.m_exclude) {
            final boolean oldValue = this.m_exclude;
            this.m_exclude = m_exclude;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_exclude", oldValue, this.m_exclude));
        }
    }
    @Override
    public boolean getExclude() throws XtumlException {
        checkLiving();
        return m_exclude;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public String getFormattedImports( final ImportType p_type ) throws XtumlException {
        TypeImportReferenceSet import_refs = ((TypeImportReferenceSet)self().R402_imports_type_via_TypeImportReference().where(selected -> ( p_type.equality(ImportType.BOTH) || ((TypeImportReference)selected).getType().equality(ImportType.BOTH) ) || ((TypeImportReference)selected).getType().equality(p_type)));
        TypeImportSet imports = import_refs.R402_imports_type_via_TypeImport();
        TypeImport type_import;
        for ( Iterator<TypeImport> _type_import_iter = imports.elements().iterator(); _type_import_iter.hasNext(); ) {
            type_import = _type_import_iter.next();
            type_import.render();
            context().T().append( "\n" );
        }
        String import_block = context().T().body();
        context().T().clear();
        import_block = context().C_UTIL().organizeImports( import_block );
        return "\n" + import_block;
    }

    @Override
    public void render() throws XtumlException {
        Application application = self().R401_is_a_Application();
        if ( !application.isEmpty() ) {
            application.render();
        }
        else {
            ComponentDefinition componentdefinition = self().R401_is_a_ComponentDefinition();
            if ( !componentdefinition.isEmpty() ) {
                componentdefinition.render();
            }
            else {
                EnumeratedType enumeratedtype = self().R401_is_a_EnumeratedType();
                if ( !enumeratedtype.isEmpty() ) {
                    enumeratedtype.render();
                }
                else {
                    GeneralFile generalfile = self().R401_is_a_GeneralFile();
                    if ( !generalfile.isEmpty() ) {
                        generalfile.render();
                    }
                    else {
                        Iface iface = self().R401_is_a_Iface();
                        if ( !iface.isEmpty() ) {
                            iface.render();
                        }
                        else {
                            InstSet instset = self().R401_is_a_InstSet();
                            if ( !instset.isEmpty() ) {
                                instset.render();
                            }
                            else {
                                ModelInst modelinst = self().R401_is_a_ModelInst();
                                if ( !modelinst.isEmpty() ) {
                                    modelinst.render();
                                }
                                else {
                                    Port port = self().R401_is_a_Port();
                                    if ( !port.isEmpty() ) {
                                        port.render();
                                    }
                                    else {
                                        StateMachine statemachine = self().R401_is_a_StateMachine();
                                        if ( !statemachine.isEmpty() ) {
                                            statemachine.render();
                                        }
                                        else {
                                            UserDefinedType userdefinedtype = self().R401_is_a_UserDefinedType();
                                            if ( !userdefinedtype.isEmpty() ) {
                                                userdefinedtype.render();
                                            }
                                            else {
                                                Utility utility = self().R401_is_a_Utility();
                                                if ( !utility.isEmpty() ) {
                                                    utility.render();
                                                }
                                                else {
                                                    throw new XtumlException("No subtype selected");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }



    // static operations


    // events


    // selections
    private Application R401_is_a_Application_inst;
    @Override
    public void setR401_is_a_Application( Application inst ) {
        R401_is_a_Application_inst = inst;
    }
    @Override
    public Application R401_is_a_Application() throws XtumlException {
        return R401_is_a_Application_inst;
    }
    private ComponentDefinition R401_is_a_ComponentDefinition_inst;
    @Override
    public void setR401_is_a_ComponentDefinition( ComponentDefinition inst ) {
        R401_is_a_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R401_is_a_ComponentDefinition() throws XtumlException {
        return R401_is_a_ComponentDefinition_inst;
    }
    private EnumeratedType R401_is_a_EnumeratedType_inst;
    @Override
    public void setR401_is_a_EnumeratedType( EnumeratedType inst ) {
        R401_is_a_EnumeratedType_inst = inst;
    }
    @Override
    public EnumeratedType R401_is_a_EnumeratedType() throws XtumlException {
        return R401_is_a_EnumeratedType_inst;
    }
    private GeneralFile R401_is_a_GeneralFile_inst;
    @Override
    public void setR401_is_a_GeneralFile( GeneralFile inst ) {
        R401_is_a_GeneralFile_inst = inst;
    }
    @Override
    public GeneralFile R401_is_a_GeneralFile() throws XtumlException {
        return R401_is_a_GeneralFile_inst;
    }
    private Iface R401_is_a_Iface_inst;
    @Override
    public void setR401_is_a_Iface( Iface inst ) {
        R401_is_a_Iface_inst = inst;
    }
    @Override
    public Iface R401_is_a_Iface() throws XtumlException {
        return R401_is_a_Iface_inst;
    }
    private InstSet R401_is_a_InstSet_inst;
    @Override
    public void setR401_is_a_InstSet( InstSet inst ) {
        R401_is_a_InstSet_inst = inst;
    }
    @Override
    public InstSet R401_is_a_InstSet() throws XtumlException {
        return R401_is_a_InstSet_inst;
    }
    private ModelInst R401_is_a_ModelInst_inst;
    @Override
    public void setR401_is_a_ModelInst( ModelInst inst ) {
        R401_is_a_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R401_is_a_ModelInst() throws XtumlException {
        return R401_is_a_ModelInst_inst;
    }
    private Port R401_is_a_Port_inst;
    @Override
    public void setR401_is_a_Port( Port inst ) {
        R401_is_a_Port_inst = inst;
    }
    @Override
    public Port R401_is_a_Port() throws XtumlException {
        return R401_is_a_Port_inst;
    }
    private StateMachine R401_is_a_StateMachine_inst;
    @Override
    public void setR401_is_a_StateMachine( StateMachine inst ) {
        R401_is_a_StateMachine_inst = inst;
    }
    @Override
    public StateMachine R401_is_a_StateMachine() throws XtumlException {
        return R401_is_a_StateMachine_inst;
    }
    private UserDefinedType R401_is_a_UserDefinedType_inst;
    @Override
    public void setR401_is_a_UserDefinedType( UserDefinedType inst ) {
        R401_is_a_UserDefinedType_inst = inst;
    }
    @Override
    public UserDefinedType R401_is_a_UserDefinedType() throws XtumlException {
        return R401_is_a_UserDefinedType_inst;
    }
    private Utility R401_is_a_Utility_inst;
    @Override
    public void setR401_is_a_Utility( Utility inst ) {
        R401_is_a_Utility_inst = inst;
    }
    @Override
    public Utility R401_is_a_Utility() throws XtumlException {
        return R401_is_a_Utility_inst;
    }
    private TypeImportReferenceSet R402_imports_type_via_TypeImportReference_set;
    @Override
    public void addR402_imports_type_via_TypeImportReference( TypeImportReference inst ) {
        R402_imports_type_via_TypeImportReference_set.add(inst);
    }
    @Override
    public void removeR402_imports_type_via_TypeImportReference( TypeImportReference inst ) {
        R402_imports_type_via_TypeImportReference_set.remove(inst);
    }
    @Override
    public TypeImportReferenceSet R402_imports_type_via_TypeImportReference() throws XtumlException {
        return R402_imports_type_via_TypeImportReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public File self() {
        return this;
    }

    @Override
    public File oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FILE;
    }

}

class EmptyFile extends ModelInstance<File,Sql> implements File {

    // attributes
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String m_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPath( String m_path ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPath() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExtension() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExtension( String m_extension ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExclude( boolean m_exclude ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getExclude() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public String getFormattedImports( final ImportType p_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Application R401_is_a_Application() {
        return ApplicationImpl.EMPTY_APPLICATION;
    }
    @Override
    public ComponentDefinition R401_is_a_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }
    @Override
    public EnumeratedType R401_is_a_EnumeratedType() {
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }
    @Override
    public GeneralFile R401_is_a_GeneralFile() {
        return GeneralFileImpl.EMPTY_GENERALFILE;
    }
    @Override
    public Iface R401_is_a_Iface() {
        return IfaceImpl.EMPTY_IFACE;
    }
    @Override
    public InstSet R401_is_a_InstSet() {
        return InstSetImpl.EMPTY_INSTSET;
    }
    @Override
    public ModelInst R401_is_a_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public Port R401_is_a_Port() {
        return PortImpl.EMPTY_PORT;
    }
    @Override
    public StateMachine R401_is_a_StateMachine() {
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }
    @Override
    public UserDefinedType R401_is_a_UserDefinedType() {
        return UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
    }
    @Override
    public Utility R401_is_a_Utility() {
        return UtilityImpl.EMPTY_UTILITY;
    }
    @Override
    public TypeImportReferenceSet R402_imports_type_via_TypeImportReference() {
        return (new TypeImportReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return FileImpl.KEY_LETTERS;
    }

    @Override
    public File self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public File oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FileImpl.EMPTY_FILE;
    }

}
