package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Promotion;
import io.ciera.tool.sql.architecture.expression.PromotionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class PromotionSetImpl extends InstanceSet<PromotionSet,Promotion> implements PromotionSet {

    public PromotionSetImpl() {
    }

    public PromotionSetImpl(Comparator<? super Promotion> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setExpression_number( ref_expression_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setParent_package( ref_parent_package );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setStatement_number( ref_statement_number );
    }
    @Override
    public void setInput_expression_number( String ref_input_expression_number ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setInput_expression_number( ref_input_expression_number );
    }
    @Override
    public void setCast( boolean m_cast ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setCast( m_cast );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Promotion promotion : this ) promotion.setBlock_number( ref_block_number );
    }


    // selections
    @Override
    public ExpressionSet R3907_promotes_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Promotion promotion : this ) expressionset.add( promotion.R3907_promotes_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Promotion promotion : this ) expressionset.add( promotion.R776_is_a_Expression() );
        return expressionset;
    }


    @Override
    public Promotion nullElement() {
        return PromotionImpl.EMPTY_PROMOTION;
    }

    @Override
    public PromotionSet emptySet() {
      return new PromotionSetImpl();
    }

    @Override
    public PromotionSet emptySet(Comparator<? super Promotion> comp) {
      return new PromotionSetImpl(comp);
    }

    @Override
    public List<Promotion> elements() {
        return Arrays.asList(toArray(new Promotion[0]));
    }

}
