package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.MemberReference;
import io.ciera.tool.sql.architecture.expression.MemberReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class MemberReferenceSetImpl extends InstanceSet<MemberReferenceSet,MemberReference> implements MemberReferenceSet {

    public MemberReferenceSetImpl() {
    }

    public MemberReferenceSetImpl(Comparator<? super MemberReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setBlock_number( ref_block_number );
    }
    @Override
    public void setRoot_expression_number( String ref_root_expression_number ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setRoot_expression_number( ref_root_expression_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setStatement_number( ref_statement_number );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setExpression_number( ref_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( MemberReference memberreference : this ) memberreference.setParent_package( ref_parent_package );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( MemberReference memberreference : this ) expressionset.add( memberreference.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R787_refers_to_member_of_structured_value_expressed_by_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( MemberReference memberreference : this ) expressionset.add( memberreference.R787_refers_to_member_of_structured_value_expressed_by_Expression() );
        return expressionset;
    }


    @Override
    public MemberReference nullElement() {
        return MemberReferenceImpl.EMPTY_MEMBERREFERENCE;
    }

    @Override
    public MemberReferenceSet emptySet() {
      return new MemberReferenceSetImpl();
    }

    @Override
    public MemberReferenceSet emptySet(Comparator<? super MemberReference> comp) {
      return new MemberReferenceSetImpl(comp);
    }

    @Override
    public List<MemberReference> elements() {
        return Arrays.asList(toArray(new MemberReference[0]));
    }

}
