package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ConstantReference;
import io.ciera.tool.sql.architecture.expression.ConstantReferenceSet;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ConstantReferenceSetImpl extends InstanceSet<ConstantReferenceSet,ConstantReference> implements ConstantReferenceSet {

    public ConstantReferenceSetImpl() {
    }

    public ConstantReferenceSetImpl(Comparator<? super ConstantReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setParent_package( ref_parent_package );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setExpression_number( ref_expression_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setStatement_number( ref_statement_number );
    }
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setValue( m_value );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ConstantReference constantreference : this ) constantreference.setParent_name( ref_parent_name );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( ConstantReference constantreference : this ) expressionset.add( constantreference.R776_is_a_Expression() );
        return expressionset;
    }


    @Override
    public ConstantReference nullElement() {
        return ConstantReferenceImpl.EMPTY_CONSTANTREFERENCE;
    }

    @Override
    public ConstantReferenceSet emptySet() {
      return new ConstantReferenceSetImpl();
    }

    @Override
    public ConstantReferenceSet emptySet(Comparator<? super ConstantReference> comp) {
      return new ConstantReferenceSetImpl(comp);
    }

    @Override
    public List<ConstantReference> elements() {
        return Arrays.asList(toArray(new ConstantReference[0]));
    }

}
