package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.BinaryOperation;
import io.ciera.tool.sql.architecture.expression.BinaryOperationSet;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class BinaryOperationSetImpl extends InstanceSet<BinaryOperationSet,BinaryOperation> implements BinaryOperationSet {

    public BinaryOperationSetImpl() {
    }

    public BinaryOperationSetImpl(Comparator<? super BinaryOperation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setParent_package( ref_parent_package );
    }
    @Override
    public void setOperator( String m_operator ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setOperator( m_operator );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setBody_name( ref_body_name );
    }
    @Override
    public void setUtil( boolean m_util ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setUtil( m_util );
    }
    @Override
    public void setRight_expression_number( String ref_right_expression_number ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setRight_expression_number( ref_right_expression_number );
    }
    @Override
    public void setInvocation( boolean m_invocation ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setInvocation( m_invocation );
    }
    @Override
    public void setLeft_expression_number( String ref_left_expression_number ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setLeft_expression_number( ref_left_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setParent_name( ref_parent_name );
    }
    @Override
    public void setCast( String m_cast ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setCast( m_cast );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setExpression_number( ref_expression_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( BinaryOperation binaryoperation : this ) binaryoperation.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( BinaryOperation binaryoperation : this ) expressionset.add( binaryoperation.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R778_has_right_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( BinaryOperation binaryoperation : this ) expressionset.add( binaryoperation.R778_has_right_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R779_has_left_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( BinaryOperation binaryoperation : this ) expressionset.add( binaryoperation.R779_has_left_Expression() );
        return expressionset;
    }


    @Override
    public BinaryOperation nullElement() {
        return BinaryOperationImpl.EMPTY_BINARYOPERATION;
    }

    @Override
    public BinaryOperationSet emptySet() {
      return new BinaryOperationSetImpl();
    }

    @Override
    public BinaryOperationSet emptySet(Comparator<? super BinaryOperation> comp) {
      return new BinaryOperationSetImpl(comp);
    }

    @Override
    public List<BinaryOperation> elements() {
        return Arrays.asList(toArray(new BinaryOperation[0]));
    }

}
