package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;


public class RelationshipPopulationSelectorImpl extends ModelInstance<RelationshipPopulationSelector,Sql> implements RelationshipPopulationSelector {

    public static final String KEY_LETTERS = "RelationshipPopulationSelector";
    public static final RelationshipPopulationSelector EMPTY_RELATIONSHIPPOPULATIONSELECTOR = new EmptyRelationshipPopulationSelector();

    private Sql context;

    // constructors
    private RelationshipPopulationSelectorImpl( Sql context ) {
        this.context = context;
        ref_comp_name = "";
        ref_comp_package = "";
        m_name = "";
        ref_rel_name = "";
        R4571_selects_relationships_out_of_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R4572_selects_instances_of_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    private RelationshipPopulationSelectorImpl( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, String ref_rel_name ) {
        super(instanceId);
        this.context = context;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.m_name = m_name;
        this.ref_rel_name = ref_rel_name;
        R4571_selects_relationships_out_of_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R4572_selects_instances_of_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    public static RelationshipPopulationSelector create( Sql context ) throws XtumlException {
        RelationshipPopulationSelector newRelationshipPopulationSelector = new RelationshipPopulationSelectorImpl( context );
        if ( context.addInstance( newRelationshipPopulationSelector ) ) {
            newRelationshipPopulationSelector.getRunContext().addChange(new InstanceCreatedDelta(newRelationshipPopulationSelector, KEY_LETTERS));
            return newRelationshipPopulationSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RelationshipPopulationSelector create( Sql context, String ref_comp_name, String ref_comp_package, String m_name, String ref_rel_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_comp_name, ref_comp_package, m_name, ref_rel_name);
    }

    public static RelationshipPopulationSelector create( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, String ref_rel_name ) throws XtumlException {
        RelationshipPopulationSelector newRelationshipPopulationSelector = new RelationshipPopulationSelectorImpl( context, instanceId, ref_comp_name, ref_comp_package, m_name, ref_rel_name );
        if ( context.addInstance( newRelationshipPopulationSelector ) ) {
            return newRelationshipPopulationSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_comp_name;
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    private String ref_rel_name;
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return ref_rel_name;
    }
    @Override
    public void setRel_name(String ref_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_rel_name, this.ref_rel_name)) {
            final String oldValue = this.ref_rel_name;
            this.ref_rel_name = ref_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_name", oldValue, this.ref_rel_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComp_name(), getComp_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "component/t.relationshippopulationselector.java", self() );
    }



    // static operations


    // events


    // selections
    private ComponentDefinition R4571_selects_relationships_out_of_population_of_ComponentDefinition_inst;
    @Override
    public void setR4571_selects_relationships_out_of_population_of_ComponentDefinition( ComponentDefinition inst ) {
        R4571_selects_relationships_out_of_population_of_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R4571_selects_relationships_out_of_population_of_ComponentDefinition() throws XtumlException {
        return R4571_selects_relationships_out_of_population_of_ComponentDefinition_inst;
    }
    private ClassRelationship R4572_selects_instances_of_ClassRelationship_inst;
    @Override
    public void setR4572_selects_instances_of_ClassRelationship( ClassRelationship inst ) {
        R4572_selects_instances_of_ClassRelationship_inst = inst;
    }
    @Override
    public ClassRelationship R4572_selects_instances_of_ClassRelationship() throws XtumlException {
        return R4572_selects_instances_of_ClassRelationship_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RelationshipPopulationSelector self() {
        return this;
    }

    @Override
    public RelationshipPopulationSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
    }

}

class EmptyRelationshipPopulationSelector extends ModelInstance<RelationshipPopulationSelector,Sql> implements RelationshipPopulationSelector {

    // attributes
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ComponentDefinition R4571_selects_relationships_out_of_population_of_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }
    @Override
    public ClassRelationship R4572_selects_instances_of_ClassRelationship() {
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }


    @Override
    public String getKeyLetters() {
        return RelationshipPopulationSelectorImpl.KEY_LETTERS;
    }

    @Override
    public RelationshipPopulationSelector self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RelationshipPopulationSelector oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RelationshipPopulationSelectorImpl.EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
    }

}
