package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeReference;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.impl.AttributeImpl;
import io.ciera.tool.sql.architecture.classes.impl.ClassRelationshipImpl;


public class AttributeReferenceImpl extends ModelInstance<AttributeReference,Sql> implements AttributeReference {

    public static final String KEY_LETTERS = "AttributeReference";
    public static final AttributeReference EMPTY_ATTRIBUTEREFERENCE = new EmptyAttributeReference();

    private Sql context;

    // constructors
    private AttributeReferenceImpl( Sql context ) {
        this.context = context;
        ref_referring_attribute_class_name = "";
        ref_referring_attribute_class_package = "";
        ref_referring_attribute_name = "";
        ref_referred_to_attribute_class_name = "";
        ref_referred_to_attribute_class_package = "";
        ref_referred_to_attribute_name = "";
        ref_rel_num = 0;
        ref_form_phrase = "";
        ref_form_name = "";
        ref_part_phrase = "";
        ref_part_name = "";
        R4506_has_value_provided_by_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R4506_provides_value_for_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R4511_refers_to_another_attribute_through_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    private AttributeReferenceImpl( Sql context, UniqueId instanceId, String ref_referring_attribute_class_name, String ref_referring_attribute_class_package, String ref_referring_attribute_name, String ref_referred_to_attribute_class_name, String ref_referred_to_attribute_class_package, String ref_referred_to_attribute_name, int ref_rel_num, String ref_form_phrase, String ref_form_name, String ref_part_phrase, String ref_part_name ) {
        super(instanceId);
        this.context = context;
        this.ref_referring_attribute_class_name = ref_referring_attribute_class_name;
        this.ref_referring_attribute_class_package = ref_referring_attribute_class_package;
        this.ref_referring_attribute_name = ref_referring_attribute_name;
        this.ref_referred_to_attribute_class_name = ref_referred_to_attribute_class_name;
        this.ref_referred_to_attribute_class_package = ref_referred_to_attribute_class_package;
        this.ref_referred_to_attribute_name = ref_referred_to_attribute_name;
        this.ref_rel_num = ref_rel_num;
        this.ref_form_phrase = ref_form_phrase;
        this.ref_form_name = ref_form_name;
        this.ref_part_phrase = ref_part_phrase;
        this.ref_part_name = ref_part_name;
        R4506_has_value_provided_by_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R4506_provides_value_for_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R4511_refers_to_another_attribute_through_ClassRelationship_inst = ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

    public static AttributeReference create( Sql context ) throws XtumlException {
        AttributeReference newAttributeReference = new AttributeReferenceImpl( context );
        if ( context.addInstance( newAttributeReference ) ) {
            newAttributeReference.getRunContext().addChange(new InstanceCreatedDelta(newAttributeReference, KEY_LETTERS));
            return newAttributeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeReference create( Sql context, String ref_referring_attribute_class_name, String ref_referring_attribute_class_package, String ref_referring_attribute_name, String ref_referred_to_attribute_class_name, String ref_referred_to_attribute_class_package, String ref_referred_to_attribute_name, int ref_rel_num, String ref_form_phrase, String ref_form_name, String ref_part_phrase, String ref_part_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_referring_attribute_class_name, ref_referring_attribute_class_package, ref_referring_attribute_name, ref_referred_to_attribute_class_name, ref_referred_to_attribute_class_package, ref_referred_to_attribute_name, ref_rel_num, ref_form_phrase, ref_form_name, ref_part_phrase, ref_part_name);
    }

    public static AttributeReference create( Sql context, UniqueId instanceId, String ref_referring_attribute_class_name, String ref_referring_attribute_class_package, String ref_referring_attribute_name, String ref_referred_to_attribute_class_name, String ref_referred_to_attribute_class_package, String ref_referred_to_attribute_name, int ref_rel_num, String ref_form_phrase, String ref_form_name, String ref_part_phrase, String ref_part_name ) throws XtumlException {
        AttributeReference newAttributeReference = new AttributeReferenceImpl( context, instanceId, ref_referring_attribute_class_name, ref_referring_attribute_class_package, ref_referring_attribute_name, ref_referred_to_attribute_class_name, ref_referred_to_attribute_class_package, ref_referred_to_attribute_name, ref_rel_num, ref_form_phrase, ref_form_name, ref_part_phrase, ref_part_name );
        if ( context.addInstance( newAttributeReference ) ) {
            return newAttributeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_referring_attribute_class_name;
    @Override
    public void setReferring_attribute_class_name(String ref_referring_attribute_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referring_attribute_class_name, this.ref_referring_attribute_class_name)) {
            final String oldValue = this.ref_referring_attribute_class_name;
            this.ref_referring_attribute_class_name = ref_referring_attribute_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referring_attribute_class_name", oldValue, this.ref_referring_attribute_class_name));
        }
    }
    @Override
    public String getReferring_attribute_class_name() throws XtumlException {
        checkLiving();
        return ref_referring_attribute_class_name;
    }
    private String ref_referring_attribute_class_package;
    @Override
    public String getReferring_attribute_class_package() throws XtumlException {
        checkLiving();
        return ref_referring_attribute_class_package;
    }
    @Override
    public void setReferring_attribute_class_package(String ref_referring_attribute_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referring_attribute_class_package, this.ref_referring_attribute_class_package)) {
            final String oldValue = this.ref_referring_attribute_class_package;
            this.ref_referring_attribute_class_package = ref_referring_attribute_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referring_attribute_class_package", oldValue, this.ref_referring_attribute_class_package));
        }
    }
    private String ref_referring_attribute_name;
    @Override
    public void setReferring_attribute_name(String ref_referring_attribute_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referring_attribute_name, this.ref_referring_attribute_name)) {
            final String oldValue = this.ref_referring_attribute_name;
            this.ref_referring_attribute_name = ref_referring_attribute_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referring_attribute_name", oldValue, this.ref_referring_attribute_name));
        }
    }
    @Override
    public String getReferring_attribute_name() throws XtumlException {
        checkLiving();
        return ref_referring_attribute_name;
    }
    private String ref_referred_to_attribute_class_name;
    @Override
    public String getReferred_to_attribute_class_name() throws XtumlException {
        checkLiving();
        return ref_referred_to_attribute_class_name;
    }
    @Override
    public void setReferred_to_attribute_class_name(String ref_referred_to_attribute_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referred_to_attribute_class_name, this.ref_referred_to_attribute_class_name)) {
            final String oldValue = this.ref_referred_to_attribute_class_name;
            this.ref_referred_to_attribute_class_name = ref_referred_to_attribute_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referred_to_attribute_class_name", oldValue, this.ref_referred_to_attribute_class_name));
        }
    }
    private String ref_referred_to_attribute_class_package;
    @Override
    public void setReferred_to_attribute_class_package(String ref_referred_to_attribute_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referred_to_attribute_class_package, this.ref_referred_to_attribute_class_package)) {
            final String oldValue = this.ref_referred_to_attribute_class_package;
            this.ref_referred_to_attribute_class_package = ref_referred_to_attribute_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referred_to_attribute_class_package", oldValue, this.ref_referred_to_attribute_class_package));
        }
    }
    @Override
    public String getReferred_to_attribute_class_package() throws XtumlException {
        checkLiving();
        return ref_referred_to_attribute_class_package;
    }
    private String ref_referred_to_attribute_name;
    @Override
    public void setReferred_to_attribute_name(String ref_referred_to_attribute_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_referred_to_attribute_name, this.ref_referred_to_attribute_name)) {
            final String oldValue = this.ref_referred_to_attribute_name;
            this.ref_referred_to_attribute_name = ref_referred_to_attribute_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_referred_to_attribute_name", oldValue, this.ref_referred_to_attribute_name));
        }
    }
    @Override
    public String getReferred_to_attribute_name() throws XtumlException {
        checkLiving();
        return ref_referred_to_attribute_name;
    }
    private int ref_rel_num;
    @Override
    public void setRel_num(int ref_rel_num) throws XtumlException {
        checkLiving();
        if (ref_rel_num != this.ref_rel_num) {
            final int oldValue = this.ref_rel_num;
            this.ref_rel_num = ref_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_num", oldValue, this.ref_rel_num));
        }
    }
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return ref_rel_num;
    }
    private String ref_form_phrase;
    @Override
    public void setForm_phrase(String ref_form_phrase) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_form_phrase, this.ref_form_phrase)) {
            final String oldValue = this.ref_form_phrase;
            this.ref_form_phrase = ref_form_phrase;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_form_phrase", oldValue, this.ref_form_phrase));
        }
    }
    @Override
    public String getForm_phrase() throws XtumlException {
        checkLiving();
        return ref_form_phrase;
    }
    private String ref_form_name;
    @Override
    public void setForm_name(String ref_form_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_form_name, this.ref_form_name)) {
            final String oldValue = this.ref_form_name;
            this.ref_form_name = ref_form_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_form_name", oldValue, this.ref_form_name));
        }
    }
    @Override
    public String getForm_name() throws XtumlException {
        checkLiving();
        return ref_form_name;
    }
    private String ref_part_phrase;
    @Override
    public void setPart_phrase(String ref_part_phrase) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_part_phrase, this.ref_part_phrase)) {
            final String oldValue = this.ref_part_phrase;
            this.ref_part_phrase = ref_part_phrase;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_part_phrase", oldValue, this.ref_part_phrase));
        }
    }
    @Override
    public String getPart_phrase() throws XtumlException {
        checkLiving();
        return ref_part_phrase;
    }
    private String ref_part_name;
    @Override
    public String getPart_name() throws XtumlException {
        checkLiving();
        return ref_part_name;
    }
    @Override
    public void setPart_name(String ref_part_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_part_name, this.ref_part_name)) {
            final String oldValue = this.ref_part_name;
            this.ref_part_name = ref_part_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_part_name", oldValue, this.ref_part_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getReferring_attribute_class_name(), getReferring_attribute_class_package(), getReferring_attribute_name(), getReferred_to_attribute_class_name(), getReferred_to_attribute_class_package(), getReferred_to_attribute_name(), getRel_num(), getForm_phrase());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Attribute R4506_has_value_provided_by_Attribute_inst;
    @Override
    public void setR4506_has_value_provided_by_Attribute( Attribute inst ) {
        R4506_has_value_provided_by_Attribute_inst = inst;
    }
    @Override
    public Attribute R4506_has_value_provided_by_Attribute() throws XtumlException {
        return R4506_has_value_provided_by_Attribute_inst;
    }
    private Attribute R4506_provides_value_for_Attribute_inst;
    @Override
    public void setR4506_provides_value_for_Attribute( Attribute inst ) {
        R4506_provides_value_for_Attribute_inst = inst;
    }
    @Override
    public Attribute R4506_provides_value_for_Attribute() throws XtumlException {
        return R4506_provides_value_for_Attribute_inst;
    }
    private ClassRelationship R4511_refers_to_another_attribute_through_ClassRelationship_inst;
    @Override
    public void setR4511_refers_to_another_attribute_through_ClassRelationship( ClassRelationship inst ) {
        R4511_refers_to_another_attribute_through_ClassRelationship_inst = inst;
    }
    @Override
    public ClassRelationship R4511_refers_to_another_attribute_through_ClassRelationship() throws XtumlException {
        return R4511_refers_to_another_attribute_through_ClassRelationship_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeReference self() {
        return this;
    }

    @Override
    public AttributeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEREFERENCE;
    }

}

class EmptyAttributeReference extends ModelInstance<AttributeReference,Sql> implements AttributeReference {

    // attributes
    public void setReferring_attribute_class_name( String ref_referring_attribute_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferring_attribute_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReferring_attribute_class_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferring_attribute_class_package( String ref_referring_attribute_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setReferring_attribute_name( String ref_referring_attribute_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferring_attribute_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReferred_to_attribute_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferred_to_attribute_class_name( String ref_referred_to_attribute_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setReferred_to_attribute_class_package( String ref_referred_to_attribute_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferred_to_attribute_class_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferred_to_attribute_name( String ref_referred_to_attribute_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferred_to_attribute_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_phrase( String ref_form_phrase ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_phrase() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_name( String ref_form_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_phrase( String ref_part_phrase ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_phrase() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPart_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_name( String ref_part_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Attribute R4506_has_value_provided_by_Attribute() {
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }
    @Override
    public Attribute R4506_provides_value_for_Attribute() {
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }
    @Override
    public ClassRelationship R4511_refers_to_another_attribute_through_ClassRelationship() {
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }


    @Override
    public String getKeyLetters() {
        return AttributeReferenceImpl.KEY_LETTERS;
    }

    @Override
    public AttributeReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeReferenceImpl.EMPTY_ATTRIBUTEREFERENCE;
    }

}
