package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.application.ApplicationExecutorSet;
import io.ciera.tool.sql.architecture.application.ApplicationSet;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationExecutorSetImpl;
import io.ciera.tool.sql.architecture.application.impl.ApplicationSetImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ComponentInstantiationSetImpl extends InstanceSet<ComponentInstantiationSet,ComponentInstantiation> implements ComponentInstantiationSet {

    public ComponentInstantiationSetImpl() {
    }

    public ComponentInstantiationSetImpl(Comparator<? super ComponentInstantiation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setComp_package( ref_comp_package );
    }
    @Override
    public void setExecutor_index( int ref_executor_index ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setExecutor_index( ref_executor_index );
    }
    @Override
    public void setNext_comp_name( String ref_next_comp_name ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setNext_comp_name( ref_next_comp_name );
    }
    @Override
    public void setApp_name( String ref_app_name ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setApp_name( ref_app_name );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setComp_name( ref_comp_name );
    }
    @Override
    public void setSimulated_time( boolean m_simulated_time ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setSimulated_time( m_simulated_time );
    }
    @Override
    public void setApp_package( String ref_app_package ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setApp_package( ref_app_package );
    }
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setIndex( m_index );
    }
    @Override
    public void setNext_comp_package( String ref_next_comp_package ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setNext_comp_package( ref_next_comp_package );
    }
    @Override
    public void setInstance_loading( String m_instance_loading ) throws XtumlException {
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiation.setInstance_loading( m_instance_loading );
    }


    // selections
    @Override
    public ApplicationExecutorSet R4028_is_executed_by_ApplicationExecutor() throws XtumlException {
        ApplicationExecutorSet applicationexecutorset = new ApplicationExecutorSetImpl();
        for ( ComponentInstantiation componentinstantiation : this ) applicationexecutorset.add( componentinstantiation.R4028_is_executed_by_ApplicationExecutor() );
        return applicationexecutorset;
    }
    @Override
    public ComponentInstantiationSet R4029_follows_ComponentInstantiation() throws XtumlException {
        ComponentInstantiationSet componentinstantiationset = new ComponentInstantiationSetImpl();
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiationset.add( componentinstantiation.R4029_follows_ComponentInstantiation() );
        return componentinstantiationset;
    }
    @Override
    public ComponentInstantiationSet R4029_precedes_ComponentInstantiation() throws XtumlException {
        ComponentInstantiationSet componentinstantiationset = new ComponentInstantiationSetImpl();
        for ( ComponentInstantiation componentinstantiation : this ) componentinstantiationset.add( componentinstantiation.R4029_precedes_ComponentInstantiation() );
        return componentinstantiationset;
    }
    @Override
    public ComponentDefinitionSet R426_is_broken_into_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( ComponentInstantiation componentinstantiation : this ) componentdefinitionset.add( componentinstantiation.R426_is_broken_into_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public ApplicationSet R426_is_instantiated_by_Application() throws XtumlException {
        ApplicationSet applicationset = new ApplicationSetImpl();
        for ( ComponentInstantiation componentinstantiation : this ) applicationset.add( componentinstantiation.R426_is_instantiated_by_Application() );
        return applicationset;
    }


    @Override
    public ComponentInstantiation nullElement() {
        return ComponentInstantiationImpl.EMPTY_COMPONENTINSTANTIATION;
    }

    @Override
    public ComponentInstantiationSet emptySet() {
      return new ComponentInstantiationSetImpl();
    }

    @Override
    public ComponentInstantiationSet emptySet(Comparator<? super ComponentInstantiation> comp) {
      return new ComponentInstantiationSetImpl(comp);
    }

    @Override
    public List<ComponentInstantiation> elements() {
        return Arrays.asList(toArray(new ComponentInstantiation[0]));
    }

}
