/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.tool;

import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.template.util.ITemplate;
import io.ciera.runtime.template.util.ITemplateRegistry;
import io.ciera.runtime.template.util.Template;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.InstanceSelector;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Operation;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Function;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.expression.BinaryOperation;
import io.ciera.tool.sql.architecture.expression.ConstantReference;
import io.ciera.tool.sql.architecture.expression.Creation;
import io.ciera.tool.sql.architecture.expression.EnumeratorReference;
import io.ciera.tool.sql.architecture.expression.EventCreation;
import io.ciera.tool.sql.architecture.expression.Invocation;
import io.ciera.tool.sql.architecture.expression.Literal;
import io.ciera.tool.sql.architecture.expression.NamedReference;
import io.ciera.tool.sql.architecture.expression.ParameterReference;
import io.ciera.tool.sql.architecture.expression.Promotion;
import io.ciera.tool.sql.architecture.expression.SelectFromInstances;
import io.ciera.tool.sql.architecture.expression.SelectRelated;
import io.ciera.tool.sql.architecture.expression.Selected;
import io.ciera.tool.sql.architecture.expression.UnaryOperation;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.Where;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.Message;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortMessage;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.StateTransition;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.IfSmt;
import io.ciera.tool.sql.architecture.statement.RelateSmt;
import io.ciera.tool.sql.architecture.statement.UnrelateSmt;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.loader.AttributeComparison;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.BooleanSerializer;
import io.ciera.tool.sql.loader.ClassInstanceLoader;
import io.ciera.tool.sql.loader.ClassInstanceSerializer;
import io.ciera.tool.sql.loader.EnumeratorLoader;
import io.ciera.tool.sql.loader.EventInstanceLoader;
import io.ciera.tool.sql.loader.EventInstanceSerializer;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.IntegerLoader;
import io.ciera.tool.sql.loader.IntegerSerializer;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.RealSerializer;
import io.ciera.tool.sql.loader.StringSerializer;
import io.ciera.tool.sql.loader.TimerInstanceLoader;
import io.ciera.tool.sql.loader.TimerInstanceSerializer;

public class SqlTemplateRegistry
implements ITemplateRegistry {
    private Sql population;

    public SqlTemplateRegistry(Sql population) {
        this.population = population;
    }

    public ITemplate getTemplate(String filename) {
        switch (filename) {
            case "application/t.application.async.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String component_instantiations = (String)symbols[0];
                        String component_satisfactions = (String)symbols[1];
                        String imports = (String)symbols[2];
                        int num_component_instances = (Integer)symbols[3];
                        Application self = (Application)symbols[4];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" implements IApplication {\n\n    private IComponent<?>[] components;\n    private ApplicationExecutor executor;\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() {\n        components = new IComponent<?>[");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)num_component_instances));
                        ((Sql)this.context()).T().append("];\n    }\n\n    @Override\n    public void setup( String[] args, ILogger logger ) {\n        if ( null != logger ) {\n            executor = new ApplicationExecutor(\"");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Executor\", args, logger);\n        }\n        else {\n            executor = new ApplicationExecutor(\"");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Executor\", args);\n        }\n");
                        ((Sql)this.context()).T().append(component_instantiations);
                        ((Sql)this.context()).T().append(component_satisfactions);
                        ((Sql)this.context()).T().append("    }\n\n    @Override\n    public void printVersions() {\n        io.ciera.runtime.Version.printVersion();\n        for ( IComponent<?> c : components ) {\n            System.out.printf(\"%s: %s (%s)\", c.getClass().getName(), c.getVersion(), c.getVersionDate());\n            System.out.println();\n        }\n    }\n\n    public void handleSignal(final String data) {\n        final JSONObject msg = new JSONObject(data);\n        final int index = msg.getInt(\"componentId\");\n        final String portName = msg.getString(\"portName\");\n        // load population\n        try {\n            if (null!= components[index].getDefaultLoader()) components[index].getDefaultLoader().load();\n        } catch (XtumlException e) {/* fail silently */}\n        IChangeLog changeLog = executor.performTransaction(new ReceivedMessageTask() {\n            @Override\n            public void run() throws XtumlException {\n                // execute signal\n                try {\n                    Method portAccessor = components[index].getClass().getMethod(portName);\n                    IPort<?> port = (IPort<?>)portAccessor.invoke(components[index]);\n                    port.deliver(Message.deserialize(msg.getJSONObject(\"message\").toString()));\n                } catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n                    throw new XtumlException(\"Could not deliver message\");\n                }\n            }\n        });\n        // serialize population\n        try {\n            if (null!= components[index].getDefaultLoader()) components[index].getDefaultLoader().serialize(changeLog);\n        } catch (XtumlException e) {/* fail silently */}\n    }\n\n    public void heartbeat() {\n        // load population\n        for ( IComponent<?> c : components ) {\n        \ttry {\n        \t    if (null != c.getDefaultLoader()) c.getDefaultLoader().load();\n            } catch (XtumlException e) {/* fail silently */}\n        }\n        // tick\n        IChangeLog changeLog = executor.heartbeat();\n        // serialize population\n        for ( IComponent<?> c : components ) {\n        \ttry {\n        \t    if (null != c.getDefaultLoader()) c.getDefaultLoader().serialize(changeLog);\n            } catch (XtumlException e) {/* fail silently */}\n        }\n    }\n\n    @Override\n    public void initialize() {}\n\n    @Override\n    public void start() {}\n\n    @Override\n    public void stop() {}\n\n    public static void main(String[] args) {\n        ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" app = new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("();\n        app.setup(args, null);\n        CommandLine cmd = new CommandLine(args);\n        try {\n            cmd.register_flag(\"v\", \"Print version\");\n            cmd.register_flag(\"version\", \"Print version\");\n            cmd.register_flag(\"heartbeat\", \"Check ticking timers\");\n            cmd.register_value(\"signal\", \"signal_file\", \"File containing JSON signal data\", \"\", false);\n            cmd.read_command_line();\n            if (cmd.get_flag(\"v\") || cmd.get_flag(\"version\")) {\n                app.printVersions();\n            }\n            else {\n                if (cmd.get_flag(\"heartbeat\")) {\n                    app.heartbeat();\n                }\n                else if (!\"\".equals(cmd.get_value(\"signal\"))) {\n                    try {\n                        Scanner sc = new Scanner(new File(cmd.get_value(\"signal\")));\n                        String signalData = \"\";\n                        while (sc.hasNextLine()) signalData += sc.nextLine();\n                        sc.close();\n                        app.handleSignal(signalData);\n                    } catch (IOException e) {/* fail silently */}\n                }\n            }\n        } catch (XtumlException e) {/* fail silently */}\n    }\n\n}\n");
                    }
                };
            }
            case "application/t.application.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String component_getters = (String)symbols[0];
                        String component_instantiations = (String)symbols[1];
                        String component_satisfactions = (String)symbols[2];
                        String imports = (String)symbols[3];
                        int num_component_instances = (Integer)symbols[4];
                        int num_executors = (Integer)symbols[5];
                        Application self = (Application)symbols[6];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" implements IApplication {\n\n    private IComponent<?>[] components;\n    private ApplicationExecutor[] executors;\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() {\n        components = new IComponent<?>[");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)num_component_instances));
                        ((Sql)this.context()).T().append("];\n        executors = new ApplicationExecutor[");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)num_executors));
                        ((Sql)this.context()).T().append("];\n    }\n\n    @Override\n    public void run() {\n        for (ApplicationExecutor executor : executors) {\n            executor.run();\n        }\n    }\n\n    @Override\n    public void setup( String[] args, ILogger logger ) {\n        for ( int i = 0; i < executors.length; i++ ) {\n            if ( null != logger ) {\n                executors[i] = new ApplicationExecutor( \"");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Executor\" + i, args, logger );\n            }\n            else {\n                executors[i] = new ApplicationExecutor( \"");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Executor\" + i, args );\n            }\n        }\n");
                        ((Sql)this.context()).T().append(component_instantiations);
                        ((Sql)this.context()).T().append(component_satisfactions);
                        ((Sql)this.context()).T().append("    }\n\n");
                        ((Sql)this.context()).T().append(component_getters);
                        ((Sql)this.context()).T().append("\n    @Override\n    public void initialize() {\n        for ( IComponent<?> component : components ) {\n            component.getRunContext().execute( new GenericExecutionTask() {\n                @Override\n                public void run() throws XtumlException {\n                    component.initialize();\n                }\n            });\n        }\n    }\n\n    @Override\n    public void start() {\n        if (1 == executors.length) {\n            executors[0].run();\n        }\n        else {\n            for ( ApplicationExecutor executor : executors ) {\n                executor.start();\n            }\n        }\n    }\n\n    @Override\n    public void printVersions() {\n        io.ciera.runtime.Version.printVersion();\n        for ( IComponent<?> c : components ) {\n            System.out.printf(\"%s: %s (%s)\", c.getClass().getName(), c.getVersion(), c.getVersionDate());\n            System.out.println();\n        }\n    }\n\n    @Override\n    public void stop() {\n        for ( ApplicationExecutor executor : executors ) {\n            executor.execute(new HaltExecutionTask());\n        }\n    }\n\n    public static void main( String[] args ) {\n        IApplication app = new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("();\n        app.setup( args, null );\n        if ( Arrays.asList(args).contains(\"-v\") || Arrays.asList(args).contains(\"--version\") ) {\n            app.printVersions();\n        }\n        else {\n            app.initialize();\n            app.start();\n        }\n    }\n\n}\n");
                    }
                };
            }
            case "application/t.componentinstantiation.getter.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ComponentInstantiation self = (ComponentInstantiation)symbols[0];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("() {\n        return (");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(")components[");
                        ((Sql)this.context()).T().append((Object)self.getIndex());
                        ((Sql)this.context()).T().append("];\n    }\n");
                    }
                };
            }
            case "application/t.componentinstantiation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ComponentInstantiation self = (ComponentInstantiation)symbols[0];
                        ((Sql)this.context()).T().append("        components[");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getIndex()));
                        ((Sql)this.context()).T().append("] = new ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("(this, ");
                        if (-1 == self.getExecutor_index()) {
                            ((Sql)this.context()).T().append("executor");
                        } else {
                            ((Sql)this.context()).T().append("executors[");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getExecutor_index()));
                            ((Sql)this.context()).T().append("]");
                        }
                        ((Sql)this.context()).T().append(", ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getIndex()));
                        ((Sql)this.context()).T().append(");\n");
                        if (self.getSimulated_time()) {
                            if (-1 == self.getExecutor_index()) {
                                ((Sql)this.context()).T().append("executor");
                            } else {
                                ((Sql)this.context()).T().append("executors[");
                                ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getExecutor_index()));
                                ((Sql)this.context()).T().append("]");
                            }
                            ((Sql)this.context()).T().append("        .enableSimulatedTime(true);\n");
                        }
                        if (StringUtil.inequality((String)"", (String)self.getInstance_loading())) {
                            ((Sql)this.context()).T().append("        components[");
                            ((Sql)this.context()).T().append((Object)self.getIndex());
                            ((Sql)this.context()).T().append("].addLoader(\"");
                            ((Sql)this.context()).T().append(self.getInstance_loading());
                            ((Sql)this.context()).T().append("\", new ");
                            ((Sql)this.context()).T().append(self.getComp_name());
                            ((Sql)this.context()).T().append(self.getInstance_loading());
                            ((Sql)this.context()).T().append("Loader((");
                            ((Sql)this.context()).T().append(self.getComp_name());
                            ((Sql)this.context()).T().append(")components[");
                            ((Sql)this.context()).T().append((Object)self.getIndex());
                            ((Sql)this.context()).T().append("]));\n");
                        }
                    }
                };
            }
            case "application/t.satisfaction.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        int prov_comp_index = (Integer)symbols[0];
                        String prov_comp_name = (String)symbols[1];
                        String prov_port_name = (String)symbols[2];
                        int req_comp_index = (Integer)symbols[3];
                        String req_comp_name = (String)symbols[4];
                        String req_port_name = (String)symbols[5];
                        ((Sql)this.context()).T().append("        ((");
                        ((Sql)this.context()).T().append(req_comp_name);
                        ((Sql)this.context()).T().append(")components[");
                        ((Sql)this.context()).T().append((Object)req_comp_index);
                        ((Sql)this.context()).T().append("]).");
                        ((Sql)this.context()).T().append(req_port_name);
                        ((Sql)this.context()).T().append("().satisfy(((");
                        ((Sql)this.context()).T().append(prov_comp_name);
                        ((Sql)this.context()).T().append(")components[");
                        ((Sql)this.context()).T().append((Object)prov_comp_index);
                        ((Sql)this.context()).T().append("]).");
                        ((Sql)this.context()).T().append(prov_port_name);
                        ((Sql)this.context()).T().append("());\n        ((");
                        ((Sql)this.context()).T().append(prov_comp_name);
                        ((Sql)this.context()).T().append(")components[");
                        ((Sql)this.context()).T().append((Object)prov_comp_index);
                        ((Sql)this.context()).T().append("]).");
                        ((Sql)this.context()).T().append(prov_port_name);
                        ((Sql)this.context()).T().append("().satisfy(((");
                        ((Sql)this.context()).T().append(req_comp_name);
                        ((Sql)this.context()).T().append(")components[");
                        ((Sql)this.context()).T().append((Object)req_comp_index);
                        ((Sql)this.context()).T().append("]).");
                        ((Sql)this.context()).T().append(req_port_name);
                        ((Sql)this.context()).T().append("());\n");
                    }
                };
            }
            case "class/t.attribute.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Attribute self = (Attribute)symbols[0];
                        ((Sql)this.context()).T().append("    private ");
                        ((Sql)this.context()).T().append(self.getType_reference_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "class/t.attributeaccessor.empty.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean is_getter = (Boolean)symbols[0];
                        String name = (String)symbols[1];
                        AttributeAccessor self = (AttributeAccessor)symbols[2];
                        String type_name = (String)symbols[3];
                        if (is_getter) {
                            ((Sql)this.context()).T().append("    public ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("() throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot get attribute of empty instance.\" );\n    }\n");
                        } else {
                            ((Sql)this.context()).T().append("    public void ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(" ) throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot set attribute of empty instance.\" );\n    }\n");
                        }
                    }
                };
            }
            case "class/t.attributeaccessor.int.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean is_getter = (Boolean)symbols[0];
                        String name = (String)symbols[1];
                        AttributeAccessor self = (AttributeAccessor)symbols[2];
                        String type_name = (String)symbols[3];
                        if (is_getter) {
                            ((Sql)this.context()).T().append("    public ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("() throws XtumlException;\n");
                        } else {
                            ((Sql)this.context()).T().append("    public void ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(" ) throws XtumlException;\n");
                        }
                    }
                };
            }
            case "class/t.attributeaccessor.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_derivation = (String)symbols[0];
                        boolean is_array = (Boolean)symbols[1];
                        boolean is_getter = (Boolean)symbols[2];
                        boolean is_string = (Boolean)symbols[3];
                        String name = (String)symbols[4];
                        boolean primitive = (Boolean)symbols[5];
                        String propagations = (String)symbols[6];
                        AttributeAccessor self = (AttributeAccessor)symbols[7];
                        String type_name = (String)symbols[8];
                        if (is_getter) {
                            ((Sql)this.context()).T().append("    @Override\n    public ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("() throws XtumlException {\n        checkLiving();\n");
                            if (StringUtil.inequality((String)"", (String)attribute_derivation)) {
                                ((Sql)this.context()).T().append("        ");
                                ((Sql)this.context()).T().append(attribute_derivation);
                                ((Sql)this.context()).T().append("");
                            }
                            ((Sql)this.context()).T().append("        return ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(";\n    }\n");
                        } else {
                            ((Sql)this.context()).T().append("    @Override\n    public void ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(") throws XtumlException {\n        checkLiving();\n");
                            if (primitive) {
                                ((Sql)this.context()).T().append("        if (");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(" != this.");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(") {\n");
                            } else if (is_array) {
                                ((Sql)this.context()).T().append("        if (ArrayUtil.inequality(");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(", this.");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(")) {\n");
                            } else if (is_string) {
                                ((Sql)this.context()).T().append("        if (StringUtil.inequality(");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(", this.");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(")) {\n");
                            } else {
                                ((Sql)this.context()).T().append("        if (");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(".inequality( this.");
                                ((Sql)this.context()).T().append(self.getAttribute_name());
                                ((Sql)this.context()).T().append(")) {\n");
                            }
                            ((Sql)this.context()).T().append("            final ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" oldValue = this.");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(";\n            this.");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(" = ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(";\n            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, \"");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append("\", oldValue, this.");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append("));\n");
                            ((Sql)this.context()).T().append(propagations);
                            ((Sql)this.context()).T().append("        }\n    }\n");
                        }
                    }
                };
            }
            case "class/t.attributeaccessor.set.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean is_getter = (Boolean)symbols[0];
                        String name = (String)symbols[1];
                        AttributeAccessor self = (AttributeAccessor)symbols[2];
                        String type_name = (String)symbols[3];
                        if (!is_getter) {
                            ((Sql)this.context()).T().append("    @Override\n    public void ");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(" ) throws XtumlException {\n        for ( ");
                            ((Sql)this.context()).T().append(self.getClass_name());
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append(" : this ) ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append(".");
                            ((Sql)this.context()).T().append(name);
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(self.getAttribute_name());
                            ((Sql)this.context()).T().append(" );\n    }\n");
                        }
                    }
                };
            }
            case "class/t.attributederivation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        ((Sql)this.context()).T().append(body);
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "class/t.attributeinitializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String initializer = (String)symbols[0];
                        Attribute self = (Attribute)symbols[1];
                        ((Sql)this.context()).T().append("        ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" = ");
                        ((Sql)this.context()).T().append(initializer);
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "class/t.attributepropagation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String accessor_name = (String)symbols[0];
                        String attribute_name = (String)symbols[1];
                        String selector_name = (String)symbols[2];
                        ((Sql)this.context()).T().append("            if ( !");
                        ((Sql)this.context()).T().append(selector_name);
                        ((Sql)this.context()).T().append("().isEmpty() ) ");
                        ((Sql)this.context()).T().append(selector_name);
                        ((Sql)this.context()).T().append("().");
                        ((Sql)this.context()).T().append(accessor_name);
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(attribute_name);
                        ((Sql)this.context()).T().append(" );\n");
                    }
                };
            }
            case "class/t.class.impl.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_initializers = (String)symbols[0];
                        String attribute_initializers2 = (String)symbols[1];
                        String attribute_invocation_list = (String)symbols[2];
                        String attribute_list = (String)symbols[3];
                        String attributes = (String)symbols[4];
                        String empty_attributes = (String)symbols[5];
                        String empty_operations = (String)symbols[6];
                        String empty_selectors = (String)symbols[7];
                        String id1_attributes = (String)symbols[8];
                        String id2_attributes = (String)symbols[9];
                        String id3_attributes = (String)symbols[10];
                        String imports = (String)symbols[11];
                        String initial_state = (String)symbols[12];
                        String initial_state2 = (String)symbols[13];
                        String operations = (String)symbols[14];
                        String relationship_initializers = (String)symbols[15];
                        String selectors = (String)symbols[16];
                        ModelInst self = (ModelInst)symbols[17];
                        String state_machine_decl = (String)symbols[18];
                        String state_machine_events = (String)symbols[19];
                        String state_machine_initializer = (String)symbols[20];
                        String state_machine_initializer2 = (String)symbols[21];
                        String static_operations = (String)symbols[22];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(".impl;\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl extends ");
                        ((Sql)this.context()).T().append(self.getExtends());
                        ((Sql)this.context()).T().append(" implements ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n    public static final String KEY_LETTERS = \"");
                        ((Sql)this.context()).T().append(self.getKey_letters());
                        ((Sql)this.context()).T().append("\";\n    public static final ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" EMPTY_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u_", self.getName()));
                        ((Sql)this.context()).T().append(" = new Empty");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("();\n\n    private ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context;\n\n    // constructors\n    private ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context ) {\n        this.context = context;\n");
                        ((Sql)this.context()).T().append(attribute_initializers);
                        ((Sql)this.context()).T().append(relationship_initializers);
                        ((Sql)this.context()).T().append(state_machine_initializer);
                        ((Sql)this.context()).T().append("    }\n\n    private ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context, UniqueId instanceId");
                        ((Sql)this.context()).T().append(attribute_list);
                        ((Sql)this.context()).T().append(initial_state);
                        ((Sql)this.context()).T().append(" ) {\n        super(instanceId);\n        this.context = context;\n");
                        ((Sql)this.context()).T().append(attribute_initializers2);
                        ((Sql)this.context()).T().append(relationship_initializers);
                        ((Sql)this.context()).T().append(state_machine_initializer2);
                        ((Sql)this.context()).T().append("    }\n\n    public static ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" create( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context ) throws XtumlException {\n        ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" = new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl( context );\n        if ( context.addInstance( new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" ) ) {\n            new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(".getRunContext().addChange(new InstanceCreatedDelta(new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(", KEY_LETTERS));\n            return new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n        }\n        else throw new InstancePopulationException( \"Instance already exists within this population.\" );\n    }\n\n");
                        if (StringUtil.inequality((String)attribute_list, (String)"")) {
                            ((Sql)this.context()).T().append("    public static ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append(" create( ");
                            ((Sql)this.context()).T().append(self.getComp_name());
                            ((Sql)this.context()).T().append(" context");
                            ((Sql)this.context()).T().append(attribute_list);
                            ((Sql)this.context()).T().append(initial_state);
                            ((Sql)this.context()).T().append(" ) throws XtumlException {\n        return create(context, UniqueId.random()");
                            ((Sql)this.context()).T().append(attribute_invocation_list);
                            ((Sql)this.context()).T().append(initial_state2);
                            ((Sql)this.context()).T().append(");\n    }\n");
                        }
                        ((Sql)this.context()).T().append("\n    public static ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" create( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context, UniqueId instanceId");
                        ((Sql)this.context()).T().append(attribute_list);
                        ((Sql)this.context()).T().append(initial_state);
                        ((Sql)this.context()).T().append(" ) throws XtumlException {\n        ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" = new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl( context, instanceId");
                        ((Sql)this.context()).T().append(attribute_invocation_list);
                        ((Sql)this.context()).T().append(initial_state2);
                        ((Sql)this.context()).T().append(" );\n        if ( context.addInstance( new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" ) ) {\n            return new");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n        }\n        else throw new InstancePopulationException( \"Instance already exists within this population.\" );\n    }\n\n");
                        ((Sql)this.context()).T().append(state_machine_decl);
                        ((Sql)this.context()).T().append("\n\n    // attributes\n");
                        ((Sql)this.context()).T().append(attributes);
                        ((Sql)this.context()).T().append("\n\n    // instance identifiers\n");
                        if (StringUtil.inequality((String)"", (String)id1_attributes)) {
                            ((Sql)this.context()).T().append("    @Override\n    public IInstanceIdentifier getId1() {\n        try {\n            return new InstanceIdentifier(");
                            ((Sql)this.context()).T().append(id1_attributes);
                            ((Sql)this.context()).T().append(");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n");
                        }
                        if (StringUtil.inequality((String)"", (String)id2_attributes)) {
                            ((Sql)this.context()).T().append("    @Override\n    public IInstanceIdentifier getId2() {\n        try {\n            return new InstanceIdentifier(");
                            ((Sql)this.context()).T().append(id2_attributes);
                            ((Sql)this.context()).T().append(");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n");
                        }
                        if (StringUtil.inequality((String)"", (String)id3_attributes)) {
                            ((Sql)this.context()).T().append("    @Override\n    public IInstanceIdentifier getId3() {\n        try {\n            return new InstanceIdentifier(");
                            ((Sql)this.context()).T().append(id3_attributes);
                            ((Sql)this.context()).T().append(");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n");
                        }
                        ((Sql)this.context()).T().append("\n    // operations\n");
                        ((Sql)this.context()).T().append(operations);
                        ((Sql)this.context()).T().append("\n\n    // static operations\n");
                        ((Sql)this.context()).T().append(static_operations);
                        ((Sql)this.context()).T().append("\n\n    // events\n");
                        ((Sql)this.context()).T().append(state_machine_events);
                        ((Sql)this.context()).T().append("\n\n    // selections\n");
                        ((Sql)this.context()).T().append(selectors);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public IRunContext getRunContext() {\n        return context().getRunContext();\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context() {\n        return context;\n    }\n\n    @Override\n    public String getKeyLetters() {\n        return KEY_LETTERS;\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" self() {\n        return this;\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" oneWhere(IWhere<IXtumlType> condition) throws XtumlException {\n        if (null == condition) throw new XtumlException(\"Null condition passed to selection.\");\n        if (condition.evaluate(this)) return this;\n        else return EMPTY_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u_", self.getName()));
                        ((Sql)this.context()).T().append(";\n    }\n\n}\n\nclass Empty");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends ");
                        ((Sql)this.context()).T().append(self.getExtends());
                        ((Sql)this.context()).T().append(" implements ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n    // attributes\n");
                        ((Sql)this.context()).T().append(empty_attributes);
                        ((Sql)this.context()).T().append("\n\n    // operations\n");
                        ((Sql)this.context()).T().append(empty_operations);
                        ((Sql)this.context()).T().append("\n\n    // selections\n");
                        ((Sql)this.context()).T().append(empty_selectors);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public String getKeyLetters() {\n        return ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl.KEY_LETTERS;\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" self() {\n        return this;\n    }\n\n    @Override\n    public boolean isEmpty() {\n        return true;\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" oneWhere(IWhere<IXtumlType> condition) throws XtumlException {\n        if (null == condition) throw new XtumlException(\"Null condition passed to selection.\");\n        return ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl.EMPTY_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u_", self.getName()));
                        ((Sql)this.context()).T().append(";\n    }\n\n}\n");
                    }
                };
            }
            case "class/t.class.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attributes = (String)symbols[0];
                        String imports = (String)symbols[1];
                        String operations = (String)symbols[2];
                        String selectors = (String)symbols[3];
                        ModelInst self = (ModelInst)symbols[4];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic interface ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends IModelInstance<");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(",");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("> {\n\n    // attributes\n");
                        ((Sql)this.context()).T().append(attributes);
                        ((Sql)this.context()).T().append("\n\n    // operations\n");
                        ((Sql)this.context()).T().append(operations);
                        ((Sql)this.context()).T().append("\n\n    // selections\n");
                        ((Sql)this.context()).T().append(selectors);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "class/t.classset.impl.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attributes = (String)symbols[0];
                        String imports = (String)symbols[1];
                        String selectors = (String)symbols[2];
                        InstSet self = (InstSet)symbols[3];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(".impl;\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl extends ");
                        ((Sql)this.context()).T().append(self.getExtends());
                        ((Sql)this.context()).T().append(" implements ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl() {\n    }\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl(Comparator<? super ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("> comp) {\n        super(comp);\n    }\n\n    // attributes\n");
                        ((Sql)this.context()).T().append(attributes);
                        ((Sql)this.context()).T().append("\n\n    // selections\n");
                        ((Sql)this.context()).T().append(selectors);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" nullElement() {\n        return ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("Impl.EMPTY_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u_", self.getClass_name()));
                        ((Sql)this.context()).T().append(";\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" emptySet() {\n      return new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl();\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" emptySet(Comparator<? super ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("> comp) {\n      return new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl(comp);\n    }\n\n    @Override\n    public List<");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("> elements() {\n");
                        if (StringUtil.inequality((String)"", (String)self.getComparator())) {
                            ((Sql)this.context()).T().append("        ");
                            ((Sql)this.context()).T().append(self.getClass_name());
                            ((Sql)this.context()).T().append("[] elements = toArray(new ");
                            ((Sql)this.context()).T().append(self.getClass_name());
                            ((Sql)this.context()).T().append("[0]);\n        Arrays.sort(elements, (a, b) -> {\n            try {\n                return a.");
                            ((Sql)this.context()).T().append(self.getComparator());
                            ((Sql)this.context()).T().append("().compareTo(b.");
                            ((Sql)this.context()).T().append(self.getComparator());
                            ((Sql)this.context()).T().append("());\n            } catch (XtumlException e) { return 0; }\n        });\n        return Arrays.asList(elements);\n");
                        } else {
                            ((Sql)this.context()).T().append("        return Arrays.asList(toArray(new ");
                            ((Sql)this.context()).T().append(self.getClass_name());
                            ((Sql)this.context()).T().append("[0]));\n");
                        }
                        ((Sql)this.context()).T().append("    }\n\n}\n");
                    }
                };
            }
            case "class/t.classset.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attributes = (String)symbols[0];
                        String imports = (String)symbols[1];
                        String selectors = (String)symbols[2];
                        InstSet self = (InstSet)symbols[3];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic interface ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends IInstanceSet<");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(",");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("> {\n\n    // attributes\n");
                        ((Sql)this.context()).T().append(attributes);
                        ((Sql)this.context()).T().append("\n\n    // selections\n");
                        ((Sql)this.context()).T().append(selectors);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "class/t.instanceselector.empty.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean multiplicity_many = (Boolean)symbols[0];
                        InstanceSelector self = (InstanceSelector)symbols[1];
                        String type_name = (String)symbols[2];
                        if (multiplicity_many) {
                            ((Sql)this.context()).T().append("    @Override\n    public ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("() {\n        return (new ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append("Impl());\n    }\n");
                        } else {
                            ((Sql)this.context()).T().append("    @Override\n    public ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("() {\n        return ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append("Impl.EMPTY_");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u_", type_name));
                            ((Sql)this.context()).T().append(";\n    }\n");
                        }
                    }
                };
            }
            case "class/t.instanceselector.int.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String inst_type_name = (String)symbols[0];
                        boolean multiplicity_many = (Boolean)symbols[1];
                        InstanceSelector self = (InstanceSelector)symbols[2];
                        String type_name = (String)symbols[3];
                        if (multiplicity_many) {
                            ((Sql)this.context()).T().append("    default public void add");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {}\n    default public void remove");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {}\n");
                        } else {
                            ((Sql)this.context()).T().append("    default public void set");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {}\n");
                        }
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() throws XtumlException;\n");
                    }
                };
            }
            case "class/t.instanceselector.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String inst_type_name = (String)symbols[0];
                        boolean multiplicity_many = (Boolean)symbols[1];
                        InstanceSelector self = (InstanceSelector)symbols[2];
                        String type_name = (String)symbols[3];
                        if (multiplicity_many) {
                            ((Sql)this.context()).T().append("    private ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_set;\n    @Override\n    public void add");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {\n        ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_set.add(inst);\n    }\n    @Override\n    public void remove");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {\n        ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_set.remove(inst);\n    }\n");
                        } else {
                            ((Sql)this.context()).T().append("    private ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_inst;\n    @Override\n    public void set");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("( ");
                            ((Sql)this.context()).T().append(inst_type_name);
                            ((Sql)this.context()).T().append(" inst ) {\n        ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_inst = inst;\n    }\n");
                        }
                        ((Sql)this.context()).T().append("    @Override\n    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() throws XtumlException {\n");
                        if (multiplicity_many) {
                            ((Sql)this.context()).T().append("        return ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_set;\n");
                        } else {
                            ((Sql)this.context()).T().append("        return ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("_inst;\n");
                        }
                        ((Sql)this.context()).T().append("    }\n");
                    }
                };
            }
            case "class/t.operation.empty.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String modifiers = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        Operation self = (Operation)symbols[2];
                        String type_name = (String)symbols[3];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(modifiers);
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot invoke operation on empty instance.\" );\n    }\n");
                    }
                };
            }
            case "class/t.operation.int.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String modifiers = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        Operation self = (Operation)symbols[2];
                        String type_name = (String)symbols[3];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(modifiers);
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException;\n");
                    }
                };
            }
            case "class/t.operation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        String modifiers = (String)symbols[1];
                        String parameter_list = (String)symbols[2];
                        Operation self = (Operation)symbols[3];
                        String type_name = (String)symbols[4];
                        if (!self.getIs_class_based()) {
                            ((Sql)this.context()).T().append("    @Override\n    public ");
                            ((Sql)this.context()).T().append(modifiers);
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(parameter_list);
                            ((Sql)this.context()).T().append(") throws XtumlException ");
                            ((Sql)this.context()).T().append(body);
                            ((Sql)this.context()).T().append("\n");
                        } else {
                            ((Sql)this.context()).T().append("        public ");
                            ((Sql)this.context()).T().append(modifiers);
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(parameter_list);
                            ((Sql)this.context()).T().append(") throws XtumlException ");
                            ((Sql)this.context()).T().append(body);
                            ((Sql)this.context()).T().append("\n");
                        }
                    }
                };
            }
            case "class/t.operations.static.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String operations = (String)symbols[0];
                        ModelInst self = (ModelInst)symbols[1];
                        ((Sql)this.context()).T().append("    public static class CLASS extends ActionHome<");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("> {\n\n        public CLASS( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context ) {\n            super( context );\n        }\n\n");
                        ((Sql)this.context()).T().append(operations);
                        ((Sql)this.context()).T().append("\n\n    }\n");
                    }
                };
            }
            case "class/t.setselector.int.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        SetSelector self = (SetSelector)symbols[0];
                        String type_name = (String)symbols[1];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() throws XtumlException;\n");
                    }
                };
            }
            case "class/t.setselector.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean multiplicity_many = (Boolean)symbols[0];
                        SetSelector self = (SetSelector)symbols[1];
                        String type_name = (String)symbols[2];
                        ((Sql)this.context()).T().append("    @Override\n    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() throws XtumlException {\n        ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", type_name));
                        ((Sql)this.context()).T().append(" = new ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append("Impl();\n        for ( ");
                        ((Sql)this.context()).T().append(self.getSelector_class_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getSelector_class_name()));
                        ((Sql)this.context()).T().append(" : this ) ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", type_name));
                        ((Sql)this.context()).T().append(".add");
                        if (multiplicity_many) {
                            ((Sql)this.context()).T().append("All");
                        }
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getSelector_class_name()));
                        ((Sql)this.context()).T().append(".");
                        ((Sql)this.context()).T().append(self.getSelector_name());
                        ((Sql)this.context()).T().append("() );\n        return ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", type_name));
                        ((Sql)this.context()).T().append(";\n    }\n");
                    }
                };
            }
            case "component/t.componentdefinition.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_directory = (String)symbols[0];
                        String functions = (String)symbols[1];
                        String imports = (String)symbols[2];
                        String init = (String)symbols[3];
                        String instance_adds = (String)symbols[4];
                        String instance_extent_initializers = (String)symbols[5];
                        String instance_removes = (String)symbols[6];
                        String instance_selectors = (String)symbols[7];
                        String ports = (String)symbols[8];
                        String relationship_extent_initializers = (String)symbols[9];
                        String relationship_modifiers = (String)symbols[10];
                        String relationship_selectors = (String)symbols[11];
                        ComponentDefinition self = (ComponentDefinition)symbols[12];
                        String utilities = (String)symbols[13];
                        String utility_initializers = (String)symbols[14];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends ");
                        ((Sql)this.context()).T().append(self.getExtends());
                        ((Sql)this.context()).T().append(" {\n\n    private Map<String, Class<?>> classDirectory;\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(IApplication app, IRunContext runContext, int populationId) {\n        super(app, runContext, populationId);\n");
                        ((Sql)this.context()).T().append(instance_extent_initializers);
                        ((Sql)this.context()).T().append("\n");
                        ((Sql)this.context()).T().append(relationship_extent_initializers);
                        ((Sql)this.context()).T().append("\n");
                        ((Sql)this.context()).T().append(utility_initializers);
                        ((Sql)this.context()).T().append("\n        classDirectory = new TreeMap<>();\n");
                        ((Sql)this.context()).T().append(class_directory);
                        ((Sql)this.context()).T().append("\n    }\n\n    // domain functions\n");
                        ((Sql)this.context()).T().append(functions);
                        ((Sql)this.context()).T().append("\n\n    // relates and unrelates\n");
                        ((Sql)this.context()).T().append(relationship_modifiers);
                        ((Sql)this.context()).T().append("\n\n    // instance selections\n");
                        ((Sql)this.context()).T().append(instance_selectors);
                        ((Sql)this.context()).T().append("\n\n    // relationship selections\n");
                        ((Sql)this.context()).T().append(relationship_selectors);
                        ((Sql)this.context()).T().append("\n\n    // ports\n");
                        ((Sql)this.context()).T().append(ports);
                        ((Sql)this.context()).T().append("\n\n    // utilities\n");
                        ((Sql)this.context()).T().append(utilities);
                        ((Sql)this.context()).T().append("\n\n    // component initialization function\n    @Override\n    public void initialize() throws XtumlException {\n");
                        ((Sql)this.context()).T().append(init);
                        ((Sql)this.context()).T().append("\n    }\n\n");
                        if (StringUtil.inequality((String)"", (String)self.getVersion())) {
                            ((Sql)this.context()).T().append("    @Override\n    public String getVersion() {\n        Properties prop = new Properties();\n        try {\n            prop.load(getClass().getResourceAsStream(\"");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("Properties.properties\"));\n        } catch (IOException e) { /* do nothing */ }\n        return prop.getProperty(\"version\", \"Unknown\");\n    }\n");
                        }
                        if (StringUtil.inequality((String)"", (String)self.getVersion_date())) {
                            ((Sql)this.context()).T().append("    @Override\n    public String getVersionDate() {\n        Properties prop = new Properties();\n        try {\n            prop.load(getClass().getResourceAsStream(\"");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("Properties.properties\"));\n        } catch (IOException e) { /* do nothing */ }\n        return prop.getProperty(\"version_date\", \"Unknown\");\n    }\n");
                        }
                        ((Sql)this.context()).T().append("\n    @Override\n    public boolean addInstance( IModelInstance<?,?> instance ) throws XtumlException {\n        if ( null == instance ) throw new BadArgumentException( \"Null instance passed.\" );\n        if ( instance.isEmpty() ) throw new EmptyInstanceException( \"Cannot add empty instance to population.\" );\n");
                        ((Sql)this.context()).T().append(instance_adds);
                        ((Sql)this.context()).T().append("\n        return false;\n    }\n\n    @Override\n    public boolean removeInstance( IModelInstance<?,?> instance ) throws XtumlException {\n        if ( null == instance ) throw new BadArgumentException( \"Null instance passed.\" );\n        if ( instance.isEmpty() ) throw new EmptyInstanceException( \"Cannot remove empty instance from population.\" );\n");
                        ((Sql)this.context()).T().append(instance_removes);
                        ((Sql)this.context()).T().append("\n        return false;\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" context() {\n        return this;\n    }\n\n    @Override\n    public Class<?> getClassByKeyLetters(String keyLetters) {\n        return classDirectory.get(keyLetters);\n    }\n\n}\n");
                    }
                };
            }
            case "component/t.function.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        Function self = (Function)symbols[2];
                        String type_name = (String)symbols[3];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException ");
                        ((Sql)this.context()).T().append(body);
                        ((Sql)this.context()).T().append("\n");
                    }
                };
            }
            case "component/t.instancepopulationselector.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        InstancePopulationSelector self = (InstancePopulationSelector)symbols[0];
                        String set_name = (String)symbols[1];
                        ((Sql)this.context()).T().append("    private ");
                        ((Sql)this.context()).T().append(set_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("_extent;\n    public ");
                        ((Sql)this.context()).T().append(set_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() {\n        return ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("_extent;\n    }\n");
                    }
                };
            }
            case "component/t.relationshippopulationselector.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        RelationshipPopulationSelector self = (RelationshipPopulationSelector)symbols[0];
                        ((Sql)this.context()).T().append("    private IRelationshipSet ");
                        ((Sql)this.context()).T().append(self.getRel_name());
                        ((Sql)this.context()).T().append("_extent;\n    public IRelationshipSet ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() throws XtumlException {\n        return ");
                        ((Sql)this.context()).T().append(self.getRel_name());
                        ((Sql)this.context()).T().append("_extent;\n    }\n");
                    }
                };
            }
            case "component/t.utility.impl.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String imports = (String)symbols[0];
                        Utility self = (Utility)symbols[1];
                        String utility_functions = (String)symbols[2];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(".impl;\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl<C extends IComponent<C>> extends Utility<C> implements ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("Impl( C context ) {\n        super( context );\n    }\n\n");
                        ((Sql)this.context()).T().append(utility_functions);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "component/t.utility.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String imports = (String)symbols[0];
                        Utility self = (Utility)symbols[1];
                        String utility_functions = (String)symbols[2];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic interface ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n");
                        ((Sql)this.context()).T().append(utility_functions);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "component/t.utilityfunction.int.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String parameter_list = (String)symbols[0];
                        UtilityFunction self = (UtilityFunction)symbols[1];
                        String type_name = (String)symbols[2];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(");\n");
                    }
                };
            }
            case "component/t.utilityfunction.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        UtilityFunction self = (UtilityFunction)symbols[2];
                        String type_name = (String)symbols[3];
                        ((Sql)this.context()).T().append("    public ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") ");
                        ((Sql)this.context()).T().append(body);
                        ((Sql)this.context()).T().append("\n");
                    }
                };
            }
            case "component/t.utilityreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        UtilityReference self = (UtilityReference)symbols[0];
                        ((Sql)this.context()).T().append("    private ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(";\n    public ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append("() {\n        if ( null == ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(" ) ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(" = new ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append("Impl<>( this );\n        return ");
                        ((Sql)this.context()).T().append(self.getUtility_name());
                        ((Sql)this.context()).T().append(";\n    }\n");
                    }
                };
            }
            case "component/t.version.properties": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ComponentDefinition self = (ComponentDefinition)symbols[0];
                        ((Sql)this.context()).T().append("version=");
                        ((Sql)this.context()).T().append(self.getVersion());
                        ((Sql)this.context()).T().append("\nversion_date=");
                        ((Sql)this.context()).T().append(self.getVersion_date());
                        ((Sql)this.context()).T().append("\n");
                    }
                };
            }
            case "expression/t.actualparameter.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String expression_body = (String)symbols[0];
                        ((Sql)this.context()).T().append(expression_body);
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "expression/t.any.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String root_expression_body = (String)symbols[0];
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append(".any()");
                    }
                };
            }
            case "expression/t.arrayelementreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String index_expression_body = (String)symbols[0];
                        String root_expression_body = (String)symbols[1];
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append("[");
                        ((Sql)this.context()).T().append(index_expression_body);
                        ((Sql)this.context()).T().append("]");
                    }
                };
            }
            case "expression/t.attributeaccess.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String accessor = (String)symbols[0];
                        String root_expression_body = (String)symbols[1];
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append(".");
                        ((Sql)this.context()).T().append(accessor);
                        ((Sql)this.context()).T().append("()");
                    }
                };
            }
            case "expression/t.binaryoperation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String left_operand_body = (String)symbols[0];
                        String operator = (String)symbols[1];
                        String right_operand_body = (String)symbols[2];
                        BinaryOperation self = (BinaryOperation)symbols[3];
                        if (StringUtil.inequality((String)self.getCast(), (String)"")) {
                            ((Sql)this.context()).T().append("((");
                            ((Sql)this.context()).T().append(self.getCast());
                            ((Sql)this.context()).T().append(")");
                        }
                        if (self.getInvocation()) {
                            if (self.getUtil()) {
                                ((Sql)this.context()).T().append(operator);
                                ((Sql)this.context()).T().append("(");
                                ((Sql)this.context()).T().append(left_operand_body);
                                ((Sql)this.context()).T().append(", ");
                                ((Sql)this.context()).T().append(right_operand_body);
                                ((Sql)this.context()).T().append(")");
                            } else {
                                ((Sql)this.context()).T().append(left_operand_body);
                                ((Sql)this.context()).T().append(".");
                                ((Sql)this.context()).T().append(operator);
                                ((Sql)this.context()).T().append("(");
                                ((Sql)this.context()).T().append(right_operand_body);
                                ((Sql)this.context()).T().append(")");
                            }
                        } else {
                            ((Sql)this.context()).T().append(left_operand_body);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(operator);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(right_operand_body);
                            ((Sql)this.context()).T().append("");
                        }
                        if (StringUtil.inequality((String)self.getCast(), (String)"")) {
                            ((Sql)this.context()).T().append(")");
                        }
                    }
                };
            }
            case "expression/t.constantreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean is_string = (Boolean)symbols[0];
                        ConstantReference self = (ConstantReference)symbols[1];
                        if (is_string) {
                            ((Sql)this.context()).T().append("\"");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append("\"");
                        } else {
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append("");
                        }
                    }
                };
            }
            case "expression/t.creation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Creation self = (Creation)symbols[0];
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("Impl.create( context() )");
                    }
                };
            }
            case "expression/t.enumeratorreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        EnumeratorReference self = (EnumeratorReference)symbols[0];
                        ((Sql)this.context()).T().append(self.getEnum_type_name());
                        ((Sql)this.context()).T().append(".");
                        ((Sql)this.context()).T().append(self.getEnum_name());
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "expression/t.eventcreation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String evt_expr = (String)symbols[0];
                        EventCreation self = (EventCreation)symbols[1];
                        String target_expr = (String)symbols[2];
                        ((Sql)this.context()).T().append(evt_expr);
                        ((Sql)this.context()).T().append(".to");
                        if (self.getTo_self()) {
                            ((Sql)this.context()).T().append("Self");
                        }
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(target_expr);
                        ((Sql)this.context()).T().append(")");
                    }
                };
            }
            case "expression/t.invocation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String base_name = (String)symbols[0];
                        boolean is_event_creation = (Boolean)symbols[1];
                        String parameter_list = (String)symbols[2];
                        Invocation self = (Invocation)symbols[3];
                        if (is_event_creation) {
                            ((Sql)this.context()).T().append("new ");
                            ((Sql)this.context()).T().append(base_name);
                            ((Sql)this.context()).T().append(".");
                            ((Sql)this.context()).T().append(self.getInvoked_name());
                            ((Sql)this.context()).T().append("(getRunContext(), context().getId()");
                            if (StringUtil.inequality((String)"", (String)parameter_list)) {
                                ((Sql)this.context()).T().append(", ");
                                ((Sql)this.context()).T().append(parameter_list);
                                ((Sql)this.context()).T().append("");
                            }
                            ((Sql)this.context()).T().append(")");
                        } else {
                            ((Sql)this.context()).T().append(base_name);
                            ((Sql)this.context()).T().append(".");
                            ((Sql)this.context()).T().append(self.getInvoked_name());
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(parameter_list);
                            ((Sql)this.context()).T().append(")");
                        }
                    }
                };
            }
            case "expression/t.literal.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean is_string = (Boolean)symbols[0];
                        Literal self = (Literal)symbols[1];
                        if (is_string) {
                            ((Sql)this.context()).T().append("\"");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append("\"");
                        } else {
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append("");
                        }
                    }
                };
            }
            case "expression/t.namedreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        NamedReference self = (NamedReference)symbols[0];
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "expression/t.parameterreference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ParameterReference self = (ParameterReference)symbols[0];
                        ((Sql)this.context()).T().append(self.getParam_name());
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "expression/t.parenthesizedexpression.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String root_expression_body = (String)symbols[0];
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append(" )");
                    }
                };
            }
            case "expression/t.promotion.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast_function = (String)symbols[0];
                        String root_expression_body = (String)symbols[1];
                        Promotion self = (Promotion)symbols[2];
                        String type_name = (String)symbols[3];
                        if (self.getCast()) {
                            if (StringUtil.equality((String)"", (String)cast_function)) {
                                ((Sql)this.context()).T().append("((");
                                ((Sql)this.context()).T().append(type_name);
                                ((Sql)this.context()).T().append(")(");
                                ((Sql)this.context()).T().append(root_expression_body);
                                ((Sql)this.context()).T().append("))");
                            } else {
                                ((Sql)this.context()).T().append(root_expression_body);
                                ((Sql)this.context()).T().append(".");
                                ((Sql)this.context()).T().append(cast_function);
                                ((Sql)this.context()).T().append("()");
                            }
                        } else {
                            ((Sql)this.context()).T().append("new ");
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(root_expression_body);
                            ((Sql)this.context()).T().append(")");
                        }
                    }
                };
            }
            case "expression/t.selected.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Selected self = (Selected)symbols[0];
                        ((Sql)this.context()).T().append("((");
                        ((Sql)this.context()).T().append(self.getCast());
                        ((Sql)this.context()).T().append(")selected)");
                    }
                };
            }
            case "expression/t.selectfrominstances.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        SelectFromInstances self = (SelectFromInstances)symbols[0];
                        ((Sql)this.context()).T().append("context().");
                        ((Sql)this.context()).T().append(self.getSelector_name());
                        ((Sql)this.context()).T().append("()");
                    }
                };
            }
            case "expression/t.selectrelated.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String root_expression_body = (String)symbols[0];
                        SelectRelated self = (SelectRelated)symbols[1];
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append(".");
                        ((Sql)this.context()).T().append(self.getSelector_name());
                        ((Sql)this.context()).T().append("()");
                    }
                };
            }
            case "expression/t.unaryoperation.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String operand_body = (String)symbols[0];
                        UnaryOperation self = (UnaryOperation)symbols[1];
                        if (self.getInvocation()) {
                            ((Sql)this.context()).T().append(operand_body);
                            ((Sql)this.context()).T().append(".");
                            ((Sql)this.context()).T().append(self.getOperator());
                            ((Sql)this.context()).T().append("()");
                        } else {
                            ((Sql)this.context()).T().append(self.getOperator());
                            ((Sql)this.context()).T().append(operand_body);
                            ((Sql)this.context()).T().append("");
                        }
                    }
                };
            }
            case "expression/t.variablereference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        VariableReference self = (VariableReference)symbols[0];
                        String type_name = (String)symbols[1];
                        String var_prefix = (String)symbols[2];
                        if (self.getDeclaration()) {
                            ((Sql)this.context()).T().append(type_name);
                            ((Sql)this.context()).T().append(" ");
                        }
                        ((Sql)this.context()).T().append(var_prefix);
                        ((Sql)this.context()).T().append(self.getVar_name());
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "expression/t.where.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String accessor = (String)symbols[0];
                        String root_expression_body = (String)symbols[1];
                        Where self = (Where)symbols[2];
                        boolean sort_descending = (Boolean)symbols[3];
                        boolean sorted = (Boolean)symbols[4];
                        boolean use_util = (Boolean)symbols[5];
                        String util_name = (String)symbols[6];
                        String where_expression_body = (String)symbols[7];
                        if (StringUtil.equality((String)"many", (String)self.getMultiplicity()) || StringUtil.equality((String)"one", (String)self.getMultiplicity())) {
                            ((Sql)this.context()).T().append("((");
                            ((Sql)this.context()).T().append(self.getCast());
                            ((Sql)this.context()).T().append(")");
                        }
                        ((Sql)this.context()).T().append(root_expression_body);
                        ((Sql)this.context()).T().append("");
                        if (sorted) {
                            ((Sql)this.context()).T().append(".sorted((_a, _b) -> {try {int comp = ");
                            if (use_util) {
                                ((Sql)this.context()).T().append(util_name);
                                ((Sql)this.context()).T().append(".compareTo(_a.");
                                ((Sql)this.context()).T().append(accessor);
                                ((Sql)this.context()).T().append("(), _b.");
                                ((Sql)this.context()).T().append(accessor);
                                ((Sql)this.context()).T().append("())");
                            } else {
                                ((Sql)this.context()).T().append("_a.");
                                ((Sql)this.context()).T().append(accessor);
                                ((Sql)this.context()).T().append("().compareTo(_b.");
                                ((Sql)this.context()).T().append(accessor);
                                ((Sql)this.context()).T().append("())");
                            }
                            ((Sql)this.context()).T().append(";return comp == 0 ? _a.compareTo(_b) : comp;} catch (XtumlException _e) {return 0;}}\n");
                            if (sort_descending) {
                                ((Sql)this.context()).T().append(", false");
                            }
                            ((Sql)this.context()).T().append(")");
                        }
                        if (StringUtil.equality((String)"one", (String)self.getMultiplicity())) {
                            ((Sql)this.context()).T().append(".oneWhere(selected -> ");
                            ((Sql)this.context()).T().append(where_expression_body);
                            ((Sql)this.context()).T().append("))");
                        } else if (StringUtil.equality((String)"any", (String)self.getMultiplicity())) {
                            ((Sql)this.context()).T().append(".anyWhere(selected -> ");
                            ((Sql)this.context()).T().append(where_expression_body);
                            ((Sql)this.context()).T().append(")");
                        } else {
                            ((Sql)this.context()).T().append(".where(selected -> ");
                            ((Sql)this.context()).T().append(where_expression_body);
                            ((Sql)this.context()).T().append("))");
                        }
                    }
                };
            }
            case "file/t.generalfile.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        GeneralFile self = (GeneralFile)symbols[0];
                        ((Sql)this.context()).T().append(self.getContents());
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "file/t.typeimport.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        TypeImport self = (TypeImport)symbols[0];
                        ((Sql)this.context()).T().append("import ");
                        ((Sql)this.context()).T().append(self.getFully_qualified_name());
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "interface/t.interface.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String from_provider_message_block = (String)symbols[0];
                        String imports = (String)symbols[1];
                        Iface self = (Iface)symbols[2];
                        String to_provider_message_block = (String)symbols[3];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic interface ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" {\n\n    // to provider messages\n");
                        ((Sql)this.context()).T().append(to_provider_message_block);
                        ((Sql)this.context()).T().append("\n\n    // from provider messages\n");
                        ((Sql)this.context()).T().append(from_provider_message_block);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "interface/t.message.deliver.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String message_parameter_list = (String)symbols[0];
                        PortMessage self = (PortMessage)symbols[1];
                        ((Sql)this.context()).T().append("            case ");
                        ((Sql)this.context()).T().append(self.getIface_name());
                        ((Sql)this.context()).T().append(".SIGNAL_NO_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u", self.getMsg_name()));
                        ((Sql)this.context()).T().append(":\n                ");
                        ((Sql)this.context()).T().append(self.getMsg_name());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(message_parameter_list);
                        ((Sql)this.context()).T().append(");\n                break;\n");
                    }
                };
            }
            case "interface/t.message.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String invocation_parameter_list = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        Message self = (Message)symbols[2];
                        ((Sql)this.context()).T().append("    public static final int SIGNAL_NO_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u", self.getName()));
                        ((Sql)this.context()).T().append(" = ");
                        ((Sql)this.context()).T().append((Object)self.getId());
                        ((Sql)this.context()).T().append(";\n    public static class ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("c", self.getName()));
                        ((Sql)this.context()).T().append(" extends Message {\n");
                        if (StringUtil.inequality((String)"", (String)parameter_list)) {
                            ((Sql)this.context()).T().append("        public ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("c", self.getName()));
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(parameter_list);
                            ((Sql)this.context()).T().append(") {\n            super(new Object[]{");
                            ((Sql)this.context()).T().append(invocation_parameter_list);
                            ((Sql)this.context()).T().append("});\n        }\n");
                        }
                        ((Sql)this.context()).T().append("        @Override\n        public int getId() {\n            return SIGNAL_NO_");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("u", self.getName()));
                        ((Sql)this.context()).T().append(";\n        }\n \n    }\n    public void ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException;\n");
                    }
                };
            }
            case "interface/t.port.http.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String endpoint = (String)symbols[0];
                        ((Sql)this.context()).T().append("    @Override\n    public String getEndpoint() {\n        return \"");
                        ((Sql)this.context()).T().append(endpoint);
                        ((Sql)this.context()).T().append("\";\n    }\n");
                    }
                };
            }
            case "interface/t.port.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String extra_parameters = (String)symbols[0];
                        String imports = (String)symbols[1];
                        String inbound_message_block = (String)symbols[2];
                        String message_switch_block = (String)symbols[3];
                        String outbound_message_block = (String)symbols[4];
                        Port self = (Port)symbols[5];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends ");
                        ((Sql)this.context()).T().append(self.getBase_class());
                        ((Sql)this.context()).T().append("<");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("> implements ");
                        ((Sql)this.context()).T().append(self.getIface_name());
                        ((Sql)this.context()).T().append(" {\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context, IPort<?> peer ) {\n        super( context, peer );\n    }\n\n    // inbound messages\n");
                        ((Sql)this.context()).T().append(inbound_message_block);
                        ((Sql)this.context()).T().append("\n\n    // outbound messages\n");
                        ((Sql)this.context()).T().append(outbound_message_block);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public void deliver( IMessage message ) throws XtumlException {\n        if ( null == message ) throw new BadArgumentException( \"Cannot deliver null message.\" );\n        switch ( message.getId() ) {\n");
                        ((Sql)this.context()).T().append(message_switch_block);
                        ((Sql)this.context()).T().append("        default:\n            throw new BadArgumentException( \"Message not implemented by this port.\" );\n        }\n    }\n\n");
                        ((Sql)this.context()).T().append(extra_parameters);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public String getName() {\n        return \"");
                        ((Sql)this.context()).T().append(self.getPort_name());
                        ((Sql)this.context()).T().append("\";\n    }\n\n}\n");
                    }
                };
            }
            case "interface/t.portaccessor.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Port self = (Port)symbols[0];
                        ((Sql)this.context()).T().append("    private ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(self.getPort_name());
                        ((Sql)this.context()).T().append("() {\n        if ( null == ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" ) ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" = new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( this, null );\n        return ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n    }\n");
                    }
                };
            }
            case "interface/t.portmessage.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        boolean inbound = (Boolean)symbols[1];
                        String invocation_parameter_list = (String)symbols[2];
                        String parameter_list = (String)symbols[3];
                        PortMessage self = (PortMessage)symbols[4];
                        ((Sql)this.context()).T().append("    public void ");
                        ((Sql)this.context()).T().append(self.getMsg_name());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException ");
                        if (inbound) {
                            ((Sql)this.context()).T().append(body);
                            ((Sql)this.context()).T().append("\n");
                        } else {
                            ((Sql)this.context()).T().append("{\n        if ( satisfied() ) send(new ");
                            ((Sql)this.context()).T().append(self.getIface_name());
                            ((Sql)this.context()).T().append(".");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("c", self.getMsg_name()));
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(invocation_parameter_list);
                            ((Sql)this.context()).T().append("));\n        else ");
                            ((Sql)this.context()).T().append(body);
                            ((Sql)this.context()).T().append("    }\n");
                        }
                    }
                };
            }
            case "invocable/t.codeblock.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean include_suffix = (Boolean)symbols[0];
                        String indent = (String)symbols[1];
                        boolean is_else_if = (Boolean)symbols[2];
                        CodeBlock self = (CodeBlock)symbols[3];
                        String statements = (String)symbols[4];
                        if (is_else_if) {
                            ((Sql)this.context()).T().append(statements);
                            ((Sql)this.context()).T().append("");
                        } else {
                            ((Sql)this.context()).T().append("{\n");
                            ((Sql)this.context()).T().append(self.getPrefix());
                            ((Sql)this.context()).T().append(statements);
                            ((Sql)this.context()).T().append("");
                            if (include_suffix) {
                                ((Sql)this.context()).T().append(self.getSuffix());
                                ((Sql)this.context()).T().append("");
                            }
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("}\n");
                        }
                    }
                };
            }
            case "loader/t.attributecomparison.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        AttributeComparison self = (AttributeComparison)symbols[0];
                        if (self.getPrimitive()) {
                            ((Sql)this.context()).T().append("selected.");
                            ((Sql)this.context()).T().append(self.getPart_accessor());
                            ((Sql)this.context()).T().append(" == form.");
                            ((Sql)this.context()).T().append(self.getForm_accessor());
                            ((Sql)this.context()).T().append("");
                        } else if (self.getIs_string()) {
                            ((Sql)this.context()).T().append("StringUtil.equality( selected.");
                            ((Sql)this.context()).T().append(self.getPart_accessor());
                            ((Sql)this.context()).T().append(", form.");
                            ((Sql)this.context()).T().append(self.getForm_accessor());
                            ((Sql)this.context()).T().append(" )");
                        } else {
                            ((Sql)this.context()).T().append("selected.");
                            ((Sql)this.context()).T().append(self.getPart_accessor());
                            ((Sql)this.context()).T().append(".equality( form.");
                            ((Sql)this.context()).T().append(self.getForm_accessor());
                            ((Sql)this.context()).T().append(" )");
                        }
                    }
                };
            }
            case "loader/t.attributeserializer.sep.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ((Sql)this.context()).T().append("        out.print(\",\");\n");
                    }
                };
            }
            case "loader/t.batchrelator.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_comparisons = (String)symbols[0];
                        BatchRelator self = (BatchRelator)symbols[1];
                        ((Sql)this.context()).T().append("    public void batch_relate_");
                        ((Sql)this.context()).T().append(self.getRel_name());
                        ((Sql)this.context()).T().append("() throws XtumlException {\n        for ( ");
                        ((Sql)this.context()).T().append(self.getForm_name());
                        ((Sql)this.context()).T().append(" form : population.");
                        ((Sql)this.context()).T().append(self.getForm_name());
                        ((Sql)this.context()).T().append("_instances() ) {\n");
                        if (self.getUnconditional()) {
                            ((Sql)this.context()).T().append("            population.relate_");
                            ((Sql)this.context()).T().append(self.getRel_name());
                            ((Sql)this.context()).T().append("( form, population.");
                            ((Sql)this.context()).T().append(self.getPart_name());
                            ((Sql)this.context()).T().append("_instances().getById");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getId_num()));
                            ((Sql)this.context()).T().append("(new InstanceIdentifier(");
                            ((Sql)this.context()).T().append(attribute_comparisons);
                            ((Sql)this.context()).T().append(")));\n");
                        } else {
                            ((Sql)this.context()).T().append("            ");
                            ((Sql)this.context()).T().append(self.getPart_name());
                            ((Sql)this.context()).T().append(" part = population.");
                            ((Sql)this.context()).T().append(self.getPart_name());
                            ((Sql)this.context()).T().append("_instances().getById");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getId_num()));
                            ((Sql)this.context()).T().append("(new InstanceIdentifier(");
                            ((Sql)this.context()).T().append(attribute_comparisons);
                            ((Sql)this.context()).T().append("));\n            if ( !part.isEmpty() ) population.relate_");
                            ((Sql)this.context()).T().append(self.getRel_name());
                            ((Sql)this.context()).T().append("( form, part );\n");
                        }
                        ((Sql)this.context()).T().append("        }\n    }\n");
                    }
                };
            }
            case "loader/t.booleanloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        int value_index = (Integer)symbols[0];
                        ((Sql)this.context()).T().append("(int)values.get(");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                        ((Sql)this.context()).T().append(") == 1 ? true : false");
                    }
                };
            }
            case "loader/t.booleanserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast = (String)symbols[0];
                        BooleanSerializer self = (BooleanSerializer)symbols[1];
                        if (StringUtil.equality((String)"", (String)cast)) {
                            ((Sql)this.context()).T().append("        out.printf( \"%d\", ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(" ? 1 : 0 );\n");
                        } else {
                            ((Sql)this.context()).T().append("        out.printf( \"%d\", (");
                            ((Sql)this.context()).T().append(cast);
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(") ? 1 : 0 );\n");
                        }
                    }
                };
            }
            case "loader/t.classinstanceloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_loaders = (String)symbols[0];
                        ClassInstanceLoader self = (ClassInstanceLoader)symbols[1];
                        ((Sql)this.context()).T().append("        case \"");
                        ((Sql)this.context()).T().append(self.getClass_key_letters());
                        ((Sql)this.context()).T().append("\":\n            ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("Impl.create(population, ");
                        ((Sql)this.context()).T().append(attribute_loaders);
                        ((Sql)this.context()).T().append(");\n            break;\n");
                    }
                };
            }
            case "loader/t.classinstanceserializer.def.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_serializers = (String)symbols[0];
                        ClassInstanceSerializer self = (ClassInstanceSerializer)symbols[1];
                        ((Sql)this.context()).T().append("    public void serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO ");
                        ((Sql)this.context()).T().append(self.getClass_key_letters());
                        ((Sql)this.context()).T().append(" VALUES(\" );\n");
                        ((Sql)this.context()).T().append(attribute_serializers);
                        ((Sql)this.context()).T().append("        out.println( \");\" );\n    }\n");
                    }
                };
            }
            case "loader/t.classinstanceserializer.init.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "loader/t.classinstanceserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ClassInstanceSerializer self = (ClassInstanceSerializer)symbols[0];
                        ((Sql)this.context()).T().append("        for ( ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst : population.");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("_instances() ) serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, out );\n");
                    }
                };
            }
            case "loader/t.enumeratorloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        EnumeratorLoader self = (EnumeratorLoader)symbols[0];
                        int value_index = (Integer)symbols[1];
                        ((Sql)this.context()).T().append(self.getType_name());
                        ((Sql)this.context()).T().append(".deserialize( (int)values.get(");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                        ((Sql)this.context()).T().append(") )");
                    }
                };
            }
            case "loader/t.eventinstanceloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_loaders = (String)symbols[0];
                        String class_name = (String)symbols[1];
                        String event_handle = (String)symbols[2];
                        String event_target = (String)symbols[3];
                        String population_id = (String)symbols[4];
                        EventInstanceLoader self = (EventInstanceLoader)symbols[5];
                        ((Sql)this.context()).T().append("        case \"");
                        ((Sql)this.context()).T().append(self.getEvt_class_name());
                        ((Sql)this.context()).T().append("\":\n            new ");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append("(population.getRunContext(), ");
                        ((Sql)this.context()).T().append(population_id);
                        ((Sql)this.context()).T().append("");
                        if (StringUtil.inequality((String)"", (String)attribute_loaders)) {
                            ((Sql)this.context()).T().append(", ");
                            ((Sql)this.context()).T().append(attribute_loaders);
                            ((Sql)this.context()).T().append("");
                        }
                        ((Sql)this.context()).T().append(").to(");
                        ((Sql)this.context()).T().append(event_handle);
                        ((Sql)this.context()).T().append(", population.");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("_instances().anyWhere(selected -> selected.getInstanceId().equality(");
                        ((Sql)this.context()).T().append(event_target);
                        ((Sql)this.context()).T().append(")));\n            break;\n");
                    }
                };
            }
            case "loader/t.eventinstanceserializer.def.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_serializers = (String)symbols[0];
                        String class_name = (String)symbols[1];
                        EventInstanceSerializer self = (EventInstanceSerializer)symbols[2];
                        ((Sql)this.context()).T().append("    public void serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" VALUES(\" );\n");
                        ((Sql)this.context()).T().append(attribute_serializers);
                        ((Sql)this.context()).T().append("        out.println( \");\" );\n    }\n");
                    }
                };
            }
            case "loader/t.eventinstanceserializer.init.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "loader/t.eventinstanceserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        EventInstanceSerializer self = (EventInstanceSerializer)symbols[1];
                        ((Sql)this.context()).T().append("        for ( IEvent ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst : population.getRunContext().getActiveEvents().where(selected -> selected instanceof ");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append(") ) serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( (");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append(")");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, out );\n");
                    }
                };
            }
            case "loader/t.generalloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        GeneralLoader self = (GeneralLoader)symbols[0];
                        int value_index = (Integer)symbols[1];
                        if (StringUtil.equality((String)"boolean", (String)self.getType_name())) {
                            ((Sql)this.context()).T().append("false");
                        } else if (StringUtil.equality((String)"int", (String)self.getType_name())) {
                            ((Sql)this.context()).T().append("0");
                        } else if (StringUtil.equality((String)"double", (String)self.getType_name())) {
                            ((Sql)this.context()).T().append("0d");
                        } else if (self.getLoad_value()) {
                            ((Sql)this.context()).T().append(self.getType_name());
                            ((Sql)this.context()).T().append(".deserialize(values.get(");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                            ((Sql)this.context()).T().append("))");
                        } else {
                            ((Sql)this.context()).T().append("new ");
                            ((Sql)this.context()).T().append(self.getType_name());
                            ((Sql)this.context()).T().append("()");
                        }
                    }
                };
            }
            case "loader/t.generalserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast = (String)symbols[0];
                        GeneralSerializer self = (GeneralSerializer)symbols[1];
                        if (StringUtil.equality((String)"", (String)cast)) {
                            ((Sql)this.context()).T().append("        out.printf( \"%s\", ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(".serialize() );\n");
                        } else {
                            ((Sql)this.context()).T().append("        out.printf( \"%s\", (");
                            ((Sql)this.context()).T().append(cast);
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(").serialize() );\n");
                        }
                    }
                };
            }
            case "loader/t.integerloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        IntegerLoader self = (IntegerLoader)symbols[0];
                        int value_index = (Integer)symbols[1];
                        if (self.getIs_long()) {
                            ((Sql)this.context()).T().append("(long)values.get(");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                            ((Sql)this.context()).T().append(")");
                        } else {
                            ((Sql)this.context()).T().append("(int)values.get(");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                            ((Sql)this.context()).T().append(")");
                        }
                    }
                };
            }
            case "loader/t.integerserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast = (String)symbols[0];
                        IntegerSerializer self = (IntegerSerializer)symbols[1];
                        if (StringUtil.equality((String)"", (String)cast)) {
                            ((Sql)this.context()).T().append("        out.printf( \"%d\", ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(" );\n");
                        } else {
                            ((Sql)this.context()).T().append("        out.printf( \"%d\", (");
                            ((Sql)this.context()).T().append(cast);
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(")");
                            if (StringUtil.inequality((String)"", (String)self.getValue2())) {
                                ((Sql)this.context()).T().append(".");
                                ((Sql)this.context()).T().append(self.getValue2());
                                ((Sql)this.context()).T().append("");
                            }
                            ((Sql)this.context()).T().append(" );\n");
                        }
                    }
                };
            }
            case "loader/t.linkloader.multi.relate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean declare = (Boolean)symbols[0];
                        String form_class = (String)symbols[1];
                        String formvar = (String)symbols[2];
                        String part_class = (String)symbols[3];
                        String partvar = (String)symbols[4];
                        String rel_name = (String)symbols[5];
                        if (declare) {
                            ((Sql)this.context()).T().append("            ");
                            ((Sql)this.context()).T().append(part_class);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(partvar);
                            ((Sql)this.context()).T().append(" = population.");
                            ((Sql)this.context()).T().append(part_class);
                            ((Sql)this.context()).T().append("_instances().getByInstanceId( UniqueId.deserialize(instids.get(1)) );\n");
                        }
                        ((Sql)this.context()).T().append("            ");
                        ((Sql)this.context()).T().append(form_class);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(formvar);
                        ((Sql)this.context()).T().append(" = population.");
                        ((Sql)this.context()).T().append(form_class);
                        ((Sql)this.context()).T().append("_instances().getByInstanceId( UniqueId.deserialize(instids.get(0)) );\n            if ( ! ");
                        ((Sql)this.context()).T().append(formvar);
                        ((Sql)this.context()).T().append(".isEmpty() ) {\n                population.relate_");
                        ((Sql)this.context()).T().append(rel_name);
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(formvar);
                        ((Sql)this.context()).T().append(", ");
                        ((Sql)this.context()).T().append(partvar);
                        ((Sql)this.context()).T().append(" ); \n                break;\n            }\n");
                    }
                };
            }
            case "loader/t.linkloader.ref.relate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String form_class = (String)symbols[0];
                        String formvar = (String)symbols[1];
                        int index = (Integer)symbols[2];
                        String part_class = (String)symbols[3];
                        String partvar = (String)symbols[4];
                        String rel_name = (String)symbols[5];
                        String vtyp = (String)symbols[6];
                        if (index == 1) {
                            ((Sql)this.context()).T().append("            ");
                            ((Sql)this.context()).T().append(form_class);
                            ((Sql)this.context()).T().append(" ");
                            ((Sql)this.context()).T().append(formvar);
                            ((Sql)this.context()).T().append(" = population.");
                            ((Sql)this.context()).T().append(form_class);
                            ((Sql)this.context()).T().append("_instances().getByInstanceId( UniqueId.deserialize(instids.get(0)) );\n");
                        }
                        ((Sql)this.context()).T().append("\t        ");
                        ((Sql)this.context()).T().append(vtyp);
                        ((Sql)this.context()).T().append(partvar);
                        ((Sql)this.context()).T().append(" = population.");
                        ((Sql)this.context()).T().append(part_class);
                        ((Sql)this.context()).T().append("_instances().getByInstanceId( UniqueId.deserialize(instids.get(");
                        ((Sql)this.context()).T().append((Object)index);
                        ((Sql)this.context()).T().append(")) );\n            population.relate_");
                        ((Sql)this.context()).T().append(rel_name);
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(formvar);
                        ((Sql)this.context()).T().append(", ");
                        ((Sql)this.context()).T().append(partvar);
                        ((Sql)this.context()).T().append(" );\n");
                    }
                };
            }
            case "loader/t.linkloader.relate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String relates = (String)symbols[0];
                        String rnum_str = (String)symbols[1];
                        ((Sql)this.context()).T().append("        case ");
                        ((Sql)this.context()).T().append(rnum_str);
                        ((Sql)this.context()).T().append(":\n");
                        ((Sql)this.context()).T().append(relates);
                        ((Sql)this.context()).T().append("            break;\n");
                    }
                };
            }
            case "loader/t.linkserializer.invoke.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        String rnum_str = (String)symbols[1];
                        ((Sql)this.context()).T().append("        for ( ");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", class_name));
                        ((Sql)this.context()).T().append("_inst : population.");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append("_instances() ) serialize_");
                        ((Sql)this.context()).T().append(rnum_str);
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", class_name));
                        ((Sql)this.context()).T().append("_inst, out );\n");
                    }
                };
            }
            case "loader/t.linkserializer.method.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        String init = (String)symbols[1];
                        String referred_ids = (String)symbols[2];
                        String rnum_str = (String)symbols[3];
                        String self_serialize = (String)symbols[4];
                        ((Sql)this.context()).T().append("    public void serialize_");
                        ((Sql)this.context()).T().append(rnum_str);
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", class_name));
                        ((Sql)this.context()).T().append("_inst, PrintStream out ) throws XtumlException {\n");
                        ((Sql)this.context()).T().append(init);
                        ((Sql)this.context()).T().append("\n    ");
                        ((Sql)this.context()).T().append(self_serialize);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(referred_ids);
                        ((Sql)this.context()).T().append("           out.println( \");\" );\n    \t}\n    }\n");
                    }
                };
            }
            case "loader/t.linkserializer.reference.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String ref_out = (String)symbols[0];
                        ((Sql)this.context()).T().append("           out.print(\",\");\n    ");
                        ((Sql)this.context()).T().append(ref_out);
                        ((Sql)this.context()).T().append(" ");
                    }
                };
            }
            case "loader/t.multilinkserializer.init.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String iterator = (String)symbols[0];
                        String link_type = (String)symbols[1];
                        String referred_name = (String)symbols[2];
                        String referring_class = (String)symbols[3];
                        String rnum_str = (String)symbols[4];
                        String selector_name = (String)symbols[5];
                        String set_type_name = (String)symbols[6];
                        ((Sql)this.context()).T().append("        ");
                        ((Sql)this.context()).T().append(set_type_name);
                        ((Sql)this.context()).T().append(" links = ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", referring_class));
                        ((Sql)this.context()).T().append("_inst.");
                        ((Sql)this.context()).T().append(selector_name);
                        ((Sql)this.context()).T().append("();\n        for ( ");
                        ((Sql)this.context()).T().append(referred_name);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(iterator);
                        ((Sql)this.context()).T().append("_inst : links ) {\n            out.print( \"");
                        ((Sql)this.context()).T().append(link_type);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(rnum_str);
                        ((Sql)this.context()).T().append(" IDS(\" ); ");
                    }
                };
            }
            case "loader/t.populationloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String batch_relator_definitions = (String)symbols[0];
                        String batch_relators = (String)symbols[1];
                        String imports = (String)symbols[2];
                        String instance_loaders = (String)symbols[3];
                        String instance_serializer_definitions = (String)symbols[4];
                        String instance_serializers = (String)symbols[5];
                        String link_serializer_definitions = (String)symbols[6];
                        String link_serializer_relates = (String)symbols[7];
                        String link_serializers = (String)symbols[8];
                        PopulationLoader self = (PopulationLoader)symbols[9];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends SqlLoader {\n\n    private ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" population;\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" population ) {\n        super(population.getRunContext());\n        this.population = population;\n    }\n\n    @Override\n    public void insert(String tableName, List<Object> values) throws XtumlException {\n        switch ( tableName ) {\n");
                        ((Sql)this.context()).T().append(instance_loaders);
                        ((Sql)this.context()).T().append("        default:\n            //throw new XtumlException( \"Class not supported by this population.\" );\n            break;\n        }\n    }\n\n    @Override\n    public void link(Integer relNumber, List<Object> instids) throws XtumlException {\n    \tswitch ( relNumber ) {\n");
                        ((Sql)this.context()).T().append(link_serializer_relates);
                        ((Sql)this.context()).T().append("        default:\n            //throw new XtumlException( \"Cannot relate instances.\" );\n            break;\n        }\n    }\n\n    @Override\n    public void batchRelate() throws XtumlException {\n");
                        ((Sql)this.context()).T().append(batch_relators);
                        ((Sql)this.context()).T().append("    }\n\n");
                        ((Sql)this.context()).T().append(batch_relator_definitions);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public void serialize() throws XtumlException {\n        PrintStream out = new PrintStream(getOut());\n");
                        ((Sql)this.context()).T().append(instance_serializers);
                        ((Sql)this.context()).T().append("\n        //  association data\n");
                        ((Sql)this.context()).T().append(link_serializers);
                        ((Sql)this.context()).T().append("\n        out.flush();\n    }\n\n");
                        ((Sql)this.context()).T().append(instance_serializer_definitions);
                        ((Sql)this.context()).T().append("\n\n");
                        ((Sql)this.context()).T().append(link_serializer_definitions);
                        ((Sql)this.context()).T().append("\n\n}\n");
                    }
                };
            }
            case "loader/t.realloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        int value_index = (Integer)symbols[0];
                        ((Sql)this.context()).T().append("(double)values.get(");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                        ((Sql)this.context()).T().append(")");
                    }
                };
            }
            case "loader/t.realserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast = (String)symbols[0];
                        RealSerializer self = (RealSerializer)symbols[1];
                        if (StringUtil.equality((String)"", (String)cast)) {
                            ((Sql)this.context()).T().append("        out.printf( \"%f\", ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(" );\n");
                        } else {
                            ((Sql)this.context()).T().append("        out.printf( \"%f\", (");
                            ((Sql)this.context()).T().append(cast);
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(") );\n");
                        }
                    }
                };
            }
            case "loader/t.singlelinkserializer.init.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        String link_type = (String)symbols[1];
                        String rnum_str = (String)symbols[2];
                        String selector_name = (String)symbols[3];
                        ((Sql)this.context()).T().append("        if ( !");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", class_name));
                        ((Sql)this.context()).T().append("_inst.");
                        ((Sql)this.context()).T().append(selector_name);
                        ((Sql)this.context()).T().append("().isEmpty() ) {\n            out.print( \"");
                        ((Sql)this.context()).T().append(link_type);
                        ((Sql)this.context()).T().append(" ");
                        ((Sql)this.context()).T().append(rnum_str);
                        ((Sql)this.context()).T().append(" IDS(\" ); ");
                    }
                };
            }
            case "loader/t.stringloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        int value_index = (Integer)symbols[0];
                        ((Sql)this.context()).T().append("(String)values.get(");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)value_index));
                        ((Sql)this.context()).T().append(")");
                    }
                };
            }
            case "loader/t.stringserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cast = (String)symbols[0];
                        StringSerializer self = (StringSerializer)symbols[1];
                        if (StringUtil.equality((String)"", (String)cast)) {
                            ((Sql)this.context()).T().append("        out.printf( \"'%s'\", ");
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(".replaceAll( \"'\", \"''\" ) );\n");
                        } else {
                            ((Sql)this.context()).T().append("        out.printf( \"'%s'\", (");
                            ((Sql)this.context()).T().append(cast);
                            ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                            ((Sql)this.context()).T().append("_inst.");
                            ((Sql)this.context()).T().append(self.getValue());
                            ((Sql)this.context()).T().append(").replaceAll( \"'\", \"''\" ) );\n");
                        }
                    }
                };
            }
            case "loader/t.timerinstanceloader.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_loaders = (String)symbols[0];
                        TimerInstanceLoader self = (TimerInstanceLoader)symbols[1];
                        ((Sql)this.context()).T().append("        case \"");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("\":\n            population.getRunContext().addTimer(new Timer(");
                        ((Sql)this.context()).T().append(attribute_loaders);
                        ((Sql)this.context()).T().append("));\n            break;\n");
                    }
                };
            }
            case "loader/t.timerinstanceserializer.def.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_serializers = (String)symbols[0];
                        TimerInstanceSerializer self = (TimerInstanceSerializer)symbols[1];
                        ((Sql)this.context()).T().append("    public void serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( Timer ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" VALUES(\" );\n");
                        ((Sql)this.context()).T().append(attribute_serializers);
                        ((Sql)this.context()).T().append("        out.println( \");\" );\n    }\n");
                    }
                };
            }
            case "loader/t.timerinstanceserializer.init.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "loader/t.timerinstanceserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        TimerInstanceSerializer self = (TimerInstanceSerializer)symbols[0];
                        ((Sql)this.context()).T().append("        for ( Timer ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst : population.getRunContext().getActiveTimers().where(selected -> selected.getPopulationId() == population.getId()) ) serialize_");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getClass_name()));
                        ((Sql)this.context()).T().append("_inst, out );\n");
                    }
                };
            }
            case "loader/t.uniqueidserializer.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        String quote = (String)symbols[1];
                        String value = (String)symbols[2];
                        ((Sql)this.context()).T().append("        out.printf( \"");
                        ((Sql)this.context()).T().append(quote);
                        ((Sql)this.context()).T().append("%s");
                        ((Sql)this.context()).T().append(quote);
                        ((Sql)this.context()).T().append("\", ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", class_name));
                        ((Sql)this.context()).T().append("_inst.");
                        ((Sql)this.context()).T().append(value);
                        ((Sql)this.context()).T().append(".serialize() );\n");
                    }
                };
            }
            case "relationship/t.referentialattributeinitialization.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String form_accessor_name = (String)symbols[0];
                        String part_accessor_name = (String)symbols[1];
                        ((Sql)this.context()).T().append("            form.");
                        ((Sql)this.context()).T().append(form_accessor_name);
                        ((Sql)this.context()).T().append("( part.");
                        ((Sql)this.context()).T().append(part_accessor_name);
                        ((Sql)this.context()).T().append("() );\n");
                    }
                };
            }
            case "relationship/t.relationshipmodifiers.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String attribute_propagations = (String)symbols[0];
                        String cardinality_check = (String)symbols[1];
                        String relationship_setters = (String)symbols[2];
                        String relationship_unsetters = (String)symbols[3];
                        ClassRelationship self = (ClassRelationship)symbols[4];
                        ((Sql)this.context()).T().append("    public void relate_");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(self.getForm_name());
                        ((Sql)this.context()).T().append(" form, ");
                        ((Sql)this.context()).T().append(self.getPart_name());
                        ((Sql)this.context()).T().append(" part ) throws XtumlException {\n        if ( null == form || null == part ) throw new BadArgumentException( \"Null instances passed.\" );\n        if ( form.isEmpty() || part.isEmpty() ) throw new EmptyInstanceException( \"Cannot relate empty instances.\" );\n");
                        ((Sql)this.context()).T().append(cardinality_check);
                        ((Sql)this.context()).T().append("        if ( ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("_extent.add( new Relationship( form.getInstanceId(), part.getInstanceId() ) ) ) {\n");
                        ((Sql)this.context()).T().append(relationship_setters);
                        ((Sql)this.context()).T().append(attribute_propagations);
                        ((Sql)this.context()).T().append("        }\n        else throw new ModelIntegrityException( \"Instances could not be related.\" );\n    }\n\n    public void unrelate_");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(self.getForm_name());
                        ((Sql)this.context()).T().append(" form, ");
                        ((Sql)this.context()).T().append(self.getPart_name());
                        ((Sql)this.context()).T().append(" part ) throws XtumlException {\n        if ( null == form || null == part ) throw new BadArgumentException( \"Null instances passed.\" );\n        if ( form.isEmpty() || part.isEmpty() ) throw new EmptyInstanceException( \"Cannot unrelate empty instances.\" );\n        if ( ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("_extent.remove( ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("_extent.get( form.getInstanceId(), part.getInstanceId() ) ) ) {\n");
                        ((Sql)this.context()).T().append(relationship_unsetters);
                        ((Sql)this.context()).T().append("        }\n        else throw new ModelIntegrityException( \"Instances could not be unrelated.\" );\n    }\n");
                    }
                };
            }
            case "statemachine/t.event.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String class_name = (String)symbols[0];
                        String invocation_parameter_list = (String)symbols[1];
                        String parameter_list = (String)symbols[2];
                        Event self = (Event)symbols[3];
                        ((Sql)this.context()).T().append("    public static class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends Event {\n        public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(IRunContext runContext, int populationId");
                        if (StringUtil.inequality((String)"", (String)parameter_list)) {
                            ((Sql)this.context()).T().append(", ");
                            ((Sql)this.context()).T().append(parameter_list);
                            ((Sql)this.context()).T().append("");
                        }
                        ((Sql)this.context()).T().append(") {\n            super(runContext, populationId");
                        if (StringUtil.inequality((String)"", (String)parameter_list)) {
                            ((Sql)this.context()).T().append(", new Object[]{");
                            ((Sql)this.context()).T().append(invocation_parameter_list);
                            ((Sql)this.context()).T().append("}");
                        }
                        ((Sql)this.context()).T().append(");\n        }\n        @Override\n        public int getId() {\n            return ");
                        ((Sql)this.context()).T().append((Object)self.getId());
                        ((Sql)this.context()).T().append(";\n        }\n        @Override\n        public String getClassName() {\n            return \"");
                        ((Sql)this.context()).T().append(class_name);
                        ((Sql)this.context()).T().append("\";\n        }\n    }\n");
                    }
                };
            }
            case "statemachine/t.state.decl.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        State self = (State)symbols[0];
                        ((Sql)this.context()).T().append("    public static final int ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" = ");
                        ((Sql)this.context()).T().append((Object)self.getNumber());
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "statemachine/t.state.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        State self = (State)symbols[2];
                        ((Sql)this.context()).T().append("    private void ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("_entry_action(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException ");
                        ((Sql)this.context()).T().append(body);
                        ((Sql)this.context()).T().append("\n");
                    }
                };
            }
            case "statemachine/t.statemachine.decl.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        StateMachine self = (StateMachine)symbols[0];
                        ((Sql)this.context()).T().append("    private final ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" statemachine;\n    \n    @Override\n    public void accept(IEvent event) throws XtumlException {\n        statemachine.transition(event);\n    }\n\n    @Override\n    public int getCurrentState() {\n        return statemachine.getCurrentState();\n    }\n");
                    }
                };
            }
            case "statemachine/t.statemachine.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String imports = (String)symbols[0];
                        String initial_state = (String)symbols[1];
                        StateMachine self = (StateMachine)symbols[2];
                        String state_actions = (String)symbols[3];
                        String state_declarations = (String)symbols[4];
                        String transition_table_rows = (String)symbols[5];
                        String txn_actions = (String)symbols[6];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(".impl;\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends StateMachine<");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(",");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append("> {\n\n");
                        ((Sql)this.context()).T().append(state_declarations);
                        ((Sql)this.context()).T().append("\n\n    private ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" self;\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" self, ");
                        ((Sql)this.context()).T().append(self.getComp_name());
                        ((Sql)this.context()).T().append(" context) {\n");
                        if (StringUtil.inequality((String)"", (String)initial_state)) {
                            ((Sql)this.context()).T().append("        this(self, context, ");
                            ((Sql)this.context()).T().append(initial_state);
                            ((Sql)this.context()).T().append(");\n    }\n\n    public ");
                            ((Sql)this.context()).T().append(self.getName());
                            ((Sql)this.context()).T().append("(");
                            ((Sql)this.context()).T().append(self.getClass_name());
                            ((Sql)this.context()).T().append(" self, ");
                            ((Sql)this.context()).T().append(self.getComp_name());
                            ((Sql)this.context()).T().append(" context, int initialState) {\n        super(context, initialState);\n        this.self = self;\n    }\n");
                        } else {
                            ((Sql)this.context()).T().append("        super(context);\n        this.self = self;\n    }\n");
                        }
                        ((Sql)this.context()).T().append("\n");
                        ((Sql)this.context()).T().append(state_actions);
                        ((Sql)this.context()).T().append("\n\n");
                        ((Sql)this.context()).T().append(txn_actions);
                        ((Sql)this.context()).T().append("\n\n    @Override\n    public ITransition[][] getStateEventMatrix() {\n        return new ITransition[][] {\n");
                        ((Sql)this.context()).T().append(transition_table_rows);
                        ((Sql)this.context()).T().append("\n        };\n    }\n\n    @Override\n    public ");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append(" self() {\n        return self;\n    }\n\n    @Override\n    public String getClassName() {\n        return \"");
                        ((Sql)this.context()).T().append(self.getClass_name());
                        ((Sql)this.context()).T().append("\";\n    }\n\n}\n");
                    }
                };
            }
            case "statemachine/t.transition.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String body = (String)symbols[0];
                        String parameter_list = (String)symbols[1];
                        StateTransition self = (StateTransition)symbols[2];
                        ((Sql)this.context()).T().append("    private void ");
                        ((Sql)this.context()).T().append(self.getStart_state_name());
                        ((Sql)this.context()).T().append("_");
                        ((Sql)this.context()).T().append(self.getEvent_name());
                        ((Sql)this.context()).T().append("_txn_to_");
                        ((Sql)this.context()).T().append(self.getEnd_state_name());
                        ((Sql)this.context()).T().append("_action(");
                        ((Sql)this.context()).T().append(parameter_list);
                        ((Sql)this.context()).T().append(") throws XtumlException ");
                        ((Sql)this.context()).T().append(body);
                        ((Sql)this.context()).T().append("\n");
                    }
                };
            }
            case "statemachine/t.transitiontablecell.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        boolean cant_happen = (Boolean)symbols[0];
                        String end_state_name = (String)symbols[1];
                        boolean event_ignored = (Boolean)symbols[2];
                        String evt_name = (String)symbols[3];
                        boolean has_entry_action = (Boolean)symbols[4];
                        boolean has_txn_action = (Boolean)symbols[5];
                        String parameter_list = (String)symbols[6];
                        TransitionTableCell self = (TransitionTableCell)symbols[7];
                        String state_parameter_list = (String)symbols[8];
                        if (cant_happen) {
                            ((Sql)this.context()).T().append("CANT_HAPPEN");
                        } else if (event_ignored) {
                            ((Sql)this.context()).T().append("IGNORE");
                        } else {
                            ((Sql)this.context()).T().append("(event) -> {");
                            if (has_txn_action) {
                                ((Sql)this.context()).T().append(self.getState_name());
                                ((Sql)this.context()).T().append("_");
                                ((Sql)this.context()).T().append(evt_name);
                                ((Sql)this.context()).T().append("_txn_to_");
                                ((Sql)this.context()).T().append(end_state_name);
                                ((Sql)this.context()).T().append("_action(");
                                ((Sql)this.context()).T().append(parameter_list);
                                ((Sql)this.context()).T().append(");");
                            }
                            if (has_entry_action) {
                                ((Sql)this.context()).T().append(end_state_name);
                                ((Sql)this.context()).T().append("_entry_action(");
                                ((Sql)this.context()).T().append(state_parameter_list);
                                ((Sql)this.context()).T().append(");");
                            }
                            ((Sql)this.context()).T().append("return ");
                            ((Sql)this.context()).T().append(end_state_name);
                            ((Sql)this.context()).T().append(";}");
                        }
                    }
                };
            }
            case "statemachine/t.transitiontablerow.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String transition_table_cells = (String)symbols[0];
                        ((Sql)this.context()).T().append("            { ");
                        ((Sql)this.context()).T().append(transition_table_cells);
                        ((Sql)this.context()).T().append("\n            }");
                    }
                };
            }
            case "statement/t.break.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String indent = (String)symbols[0];
                        String oal = (String)symbols[1];
                        String prefix = (String)symbols[2];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("break;\n");
                    }
                };
            }
            case "statement/t.continue.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String indent = (String)symbols[0];
                        String oal = (String)symbols[1];
                        String prefix = (String)symbols[2];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("continue;\n");
                    }
                };
            }
            case "statement/t.delete.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String indent = (String)symbols[0];
                        String inst_expr = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String prefix = (String)symbols[3];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append(inst_expr);
                        ((Sql)this.context()).T().append(".delete();\n");
                    }
                };
            }
            case "statement/t.expressionasstatement.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String expression_body = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String prefix = (String)symbols[3];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append(expression_body);
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "statement/t.finalization.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        int finalization_num = (Integer)symbols[0];
                        String indent = (String)symbols[1];
                        Finalization self = (Finalization)symbols[2];
                        String type_name = (String)symbols[3];
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("final ");
                        ((Sql)this.context()).T().append(type_name);
                        ((Sql)this.context()).T().append(" _final");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)finalization_num));
                        ((Sql)this.context()).T().append("_");
                        ((Sql)this.context()).T().append(self.getVar_name());
                        ((Sql)this.context()).T().append(" = ");
                        ((Sql)this.context()).T().append(self.getVar_name());
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "statement/t.for.iter.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String indent = (String)symbols[0];
                        ForSmt self = (ForSmt)symbols[1];
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append(self.getIterator_name());
                        ((Sql)this.context()).T().append(" = _");
                        ((Sql)this.context()).T().append(self.getIterator_name());
                        ((Sql)this.context()).T().append("_iter.next();\n");
                    }
                };
            }
            case "statement/t.for.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String control_block = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String iterable_expr = (String)symbols[2];
                        String iterator_type = (String)symbols[3];
                        String oal = (String)symbols[4];
                        String prefix = (String)symbols[5];
                        ForSmt self = (ForSmt)symbols[6];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("for ( Iterator<");
                        ((Sql)this.context()).T().append(iterator_type);
                        ((Sql)this.context()).T().append("> _");
                        ((Sql)this.context()).T().append(self.getIterator_name());
                        ((Sql)this.context()).T().append("_iter = ");
                        ((Sql)this.context()).T().append(iterable_expr);
                        ((Sql)this.context()).T().append(".elements().iterator(); _");
                        ((Sql)this.context()).T().append(self.getIterator_name());
                        ((Sql)this.context()).T().append("_iter.hasNext(); ) ");
                        ((Sql)this.context()).T().append(control_block);
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "statement/t.generate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String evt_expr = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String prefix = (String)symbols[3];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("context().generate(");
                        ((Sql)this.context()).T().append(evt_expr);
                        ((Sql)this.context()).T().append(");\n");
                    }
                };
            }
            case "statement/t.halt.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String indent = (String)symbols[0];
                        String oal = (String)symbols[1];
                        String prefix = (String)symbols[2];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("getRunContext().execute( new HaltExecutionTask() );\n");
                    }
                };
            }
            case "statement/t.if.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cond_expr = (String)symbols[0];
                        String else_block = (String)symbols[1];
                        String else_oal = (String)symbols[2];
                        String if_oal = (String)symbols[3];
                        String indent = (String)symbols[4];
                        IfSmt self = (IfSmt)symbols[5];
                        String then_block = (String)symbols[6];
                        if (StringUtil.inequality((String)"", (String)if_oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(if_oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        if (!self.getIs_else_if()) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("");
                        }
                        ((Sql)this.context()).T().append("if ( ");
                        ((Sql)this.context()).T().append(cond_expr);
                        ((Sql)this.context()).T().append(" ) ");
                        ((Sql)this.context()).T().append(then_block);
                        ((Sql)this.context()).T().append("");
                        if (StringUtil.inequality((String)"", (String)else_block)) {
                            if (StringUtil.inequality((String)"", (String)else_oal)) {
                                ((Sql)this.context()).T().append(indent);
                                ((Sql)this.context()).T().append("// ");
                                ((Sql)this.context()).T().append(else_oal);
                                ((Sql)this.context()).T().append("\n");
                            }
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("else ");
                            ((Sql)this.context()).T().append(else_block);
                            ((Sql)this.context()).T().append("");
                        }
                    }
                };
            }
            case "statement/t.relate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String form_expr = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String part_expr = (String)symbols[3];
                        String prefix = (String)symbols[4];
                        RelateSmt self = (RelateSmt)symbols[5];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("context().relate_");
                        ((Sql)this.context()).T().append(self.getRel_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(form_expr);
                        ((Sql)this.context()).T().append(", ");
                        ((Sql)this.context()).T().append(part_expr);
                        ((Sql)this.context()).T().append(" );\n");
                    }
                };
            }
            case "statement/t.return.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String block_suffix = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String prefix = (String)symbols[3];
                        String ret_expression_body = (String)symbols[4];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append("");
                        if (StringUtil.equality((String)"", (String)ret_expression_body)) {
                            ((Sql)this.context()).T().append(block_suffix);
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("return;\n");
                        } else {
                            ((Sql)this.context()).T().append(block_suffix);
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("return ");
                            ((Sql)this.context()).T().append(ret_expression_body);
                            ((Sql)this.context()).T().append(";\n");
                        }
                    }
                };
            }
            case "statement/t.unrelate.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String form_expr = (String)symbols[0];
                        String indent = (String)symbols[1];
                        String oal = (String)symbols[2];
                        String part_expr = (String)symbols[3];
                        String prefix = (String)symbols[4];
                        UnrelateSmt self = (UnrelateSmt)symbols[5];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("context().unrelate_");
                        ((Sql)this.context()).T().append(self.getRel_name());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(form_expr);
                        ((Sql)this.context()).T().append(", ");
                        ((Sql)this.context()).T().append(part_expr);
                        ((Sql)this.context()).T().append(" );\n");
                    }
                };
            }
            case "statement/t.while.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String cond_expr = (String)symbols[0];
                        String control_block = (String)symbols[1];
                        String indent = (String)symbols[2];
                        String oal = (String)symbols[3];
                        String prefix = (String)symbols[4];
                        if (StringUtil.inequality((String)"", (String)oal)) {
                            ((Sql)this.context()).T().append(indent);
                            ((Sql)this.context()).T().append("// ");
                            ((Sql)this.context()).T().append(oal);
                            ((Sql)this.context()).T().append("\n");
                        }
                        ((Sql)this.context()).T().append(prefix);
                        ((Sql)this.context()).T().append(indent);
                        ((Sql)this.context()).T().append("while ( ");
                        ((Sql)this.context()).T().append(cond_expr);
                        ((Sql)this.context()).T().append(" ) ");
                        ((Sql)this.context()).T().append(control_block);
                        ((Sql)this.context()).T().append("");
                    }
                };
            }
            case "type/t.enumeratedtype.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String enumerator_accessors = (String)symbols[0];
                        String enumerators = (String)symbols[1];
                        String imports = (String)symbols[2];
                        EnumeratedType self = (EnumeratedType)symbols[3];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic enum ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" implements IXtumlType {\n\n    UNINITIALIZED_ENUM( -1 )");
                        ((Sql)this.context()).T().append(enumerators);
                        ((Sql)this.context()).T().append("\n\n    private final int value;\n\n    ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() {\n        value = -1;\n    }\n\n    ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( int value ) {\n        this.value = value;\n    }\n\n    public int getValue() {\n        return value;\n    }\n\n    @Override\n    public boolean equality( IXtumlType value ) throws XtumlException {\n        if (value instanceof ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(") {\n            return null != value && this.value == ((");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(")value).getValue();\n        }\n        else return false;\n    }\n\n    @Override\n    public String serialize() {\n        return Integer.toString(value);\n    }\n\n    public static ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" deserialize(Object o) throws XtumlException {\n        if (o instanceof ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(") {\n            return (");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(")o;\n        }\n        else if (o instanceof Integer) {\n            return valueOf((int)o);\n        }\n        else if (o instanceof String) {\n            try {\n                return valueOf(Integer.parseInt((String)o));\n            }\n            catch (NumberFormatException e1) {\n                Matcher m = Pattern.compile(\"([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)\").matcher((String)o);\n                if (m.matches() && \"");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("l", self.getName()));
                        ((Sql)this.context()).T().append("\".equals(m.group(1).toLowerCase())) {\n                    try {\n                        return Enum.valueOf(");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(".class, m.group(2).toUpperCase());\n                    } catch (IllegalArgumentException e2) {/* do nothing */}\n                }\n            }\n        }\n        throw new XtumlException(\"Cannot deserialize value: \" + o != null ? o.toString() : \"null\");\n    }\n\n    public static ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" valueOf(int value) {\n        switch( value ) {\n");
                        ((Sql)this.context()).T().append(enumerator_accessors);
                        ((Sql)this.context()).T().append("        default:\n            return UNINITIALIZED_ENUM;\n        }\n    }\n\n}\n");
                    }
                };
            }
            case "type/t.enumerator.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Enumerator self = (Enumerator)symbols[0];
                        ((Sql)this.context()).T().append("    ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("( ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getValue()));
                        ((Sql)this.context()).T().append(" )");
                    }
                };
            }
            case "type/t.enumeratoraccessor.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        Enumerator self = (Enumerator)symbols[0];
                        ((Sql)this.context()).T().append("        case ");
                        ((Sql)this.context()).T().append(((Sql)this.context()).T().sub("t", (Object)self.getValue()));
                        ((Sql)this.context()).T().append(":\n            return ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(";\n");
                    }
                };
            }
            case "type/t.userdefinedtype.java": {
                return new Template<Sql>(this.population){

                    public void evaluate(Object ... symbols) throws XtumlException {
                        String extends_type = (String)symbols[0];
                        String imports = (String)symbols[1];
                        UserDefinedType self = (UserDefinedType)symbols[2];
                        ((Sql)this.context()).T().append("package ");
                        ((Sql)this.context()).T().append(self.getPackage());
                        ((Sql)this.context()).T().append(";\n\n");
                        ((Sql)this.context()).T().append(imports);
                        ((Sql)this.context()).T().append("\n\npublic class ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" extends ");
                        ((Sql)this.context()).T().append(extends_type);
                        ((Sql)this.context()).T().append(" implements IXtumlType {\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("() {\n        super();\n    }\n\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(Object value) throws XtumlException {\n        super(value);\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    public ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append(" promote(Object o) throws XtumlException {\n        return new ");
                        ((Sql)this.context()).T().append(self.getName());
                        ((Sql)this.context()).T().append("(cast(o));\n    }\n\n}\n");
                    }
                };
            }
        }
        return symbolTable -> {};
    }
}

