package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum RelationshipType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    ASSOCIATIVE( 1 ),
    BINARY( 0 ),
    SUPERSUBTYPE( 2 );

    private final int value;

    RelationshipType() {
        value = -1;
    }

    RelationshipType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof RelationshipType) {
            return null != value && this.value == ((RelationshipType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static RelationshipType deserialize(Object o) throws XtumlException {
        if (o instanceof RelationshipType) {
            return (RelationshipType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "relationshiptype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(RelationshipType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static RelationshipType valueOf(int value) {
        switch( value ) {
        case 1:
            return ASSOCIATIVE;
        case 0:
            return BINARY;
        case 2:
            return SUPERSUBTYPE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
