package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.value.TransientVar;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class TransientVarImpl extends ModelInstance<TransientVar,Sql> implements TransientVar {

    public static final String KEY_LETTERS = "V_TRN";
    public static final TransientVar EMPTY_TRANSIENTVAR = new EmptyTransientVar();

    private Sql context;

    // constructors
    private TransientVarImpl( Sql context ) {
        this.context = context;
        ref_Var_ID = UniqueId.random();
        ref_DT_ID = UniqueId.random();
        m_Dimensions = "";
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R821_has_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R844_may_have_Dimensions_set = new DimensionsSetImpl();
    }

    private TransientVarImpl( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, UniqueId ref_DT_ID, String m_Dimensions ) {
        super(instanceId);
        this.context = context;
        this.ref_Var_ID = ref_Var_ID;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Dimensions = m_Dimensions;
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R821_has_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R844_may_have_Dimensions_set = new DimensionsSetImpl();
    }

    public static TransientVar create( Sql context ) throws XtumlException {
        TransientVar newTransientVar = new TransientVarImpl( context );
        if ( context.addInstance( newTransientVar ) ) {
            newTransientVar.getRunContext().addChange(new InstanceCreatedDelta(newTransientVar, KEY_LETTERS));
            return newTransientVar;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TransientVar create( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, UniqueId ref_DT_ID, String m_Dimensions ) throws XtumlException {
        TransientVar newTransientVar = new TransientVarImpl( context, instanceId, ref_Var_ID, ref_DT_ID, m_Dimensions );
        if ( context.addInstance( newTransientVar ) ) {
            return newTransientVar;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
            if ( !R844_may_have_Dimensions().isEmpty() ) R844_may_have_Dimensions().setVar_ID( ref_Var_ID );
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getVar_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private V_VAR R814_is_a_V_VAR_inst;
    @Override
    public void setR814_is_a_V_VAR( V_VAR inst ) {
        R814_is_a_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R814_is_a_V_VAR() throws XtumlException {
        return R814_is_a_V_VAR_inst;
    }
    private DataType R821_has_DataType_inst;
    @Override
    public void setR821_has_DataType( DataType inst ) {
        R821_has_DataType_inst = inst;
    }
    @Override
    public DataType R821_has_DataType() throws XtumlException {
        return R821_has_DataType_inst;
    }
    private DimensionsSet R844_may_have_Dimensions_set;
    @Override
    public void addR844_may_have_Dimensions( Dimensions inst ) {
        R844_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR844_may_have_Dimensions( Dimensions inst ) {
        R844_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R844_may_have_Dimensions() throws XtumlException {
        return R844_may_have_Dimensions_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TransientVar self() {
        return this;
    }

    @Override
    public TransientVar oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TRANSIENTVAR;
    }

}

class EmptyTransientVar extends ModelInstance<TransientVar,Sql> implements TransientVar {

    // attributes
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public V_VAR R814_is_a_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public DataType R821_has_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R844_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TransientVarImpl.KEY_LETTERS;
    }

    @Override
    public TransientVar self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TransientVar oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TransientVarImpl.EMPTY_TRANSIENTVAR;
    }

}
