package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.StructureMember;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructureMemberImpl;
import io.ciera.tool.sql.ooaofooa.value.MemberValueReference;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class MemberValueReferenceImpl extends ModelInstance<MemberValueReference,Sql> implements MemberValueReference {

    public static final String KEY_LETTERS = "V_MVL";
    public static final MemberValueReference EMPTY_MEMBERVALUEREFERENCE = new EmptyMemberValueReference();

    private Sql context;

    // constructors
    private MemberValueReferenceImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Root_Value_ID = UniqueId.random();
        ref_Member_ID = UniqueId.random();
        ref_DT_DT_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R836_is_value_of_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R837_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private MemberValueReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Member_ID, UniqueId ref_DT_DT_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Root_Value_ID = ref_Root_Value_ID;
        this.ref_Member_ID = ref_Member_ID;
        this.ref_DT_DT_ID = ref_DT_DT_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R836_is_value_of_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R837_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static MemberValueReference create( Sql context ) throws XtumlException {
        MemberValueReference newMemberValueReference = new MemberValueReferenceImpl( context );
        if ( context.addInstance( newMemberValueReference ) ) {
            newMemberValueReference.getRunContext().addChange(new InstanceCreatedDelta(newMemberValueReference, KEY_LETTERS));
            return newMemberValueReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MemberValueReference create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Member_ID, UniqueId ref_DT_DT_ID ) throws XtumlException {
        MemberValueReference newMemberValueReference = new MemberValueReferenceImpl( context, instanceId, ref_Value_ID, ref_Root_Value_ID, ref_Member_ID, ref_DT_DT_ID );
        if ( context.addInstance( newMemberValueReference ) ) {
            return newMemberValueReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_Root_Value_ID;
    @Override
    public UniqueId getRoot_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Root_Value_ID;
    }
    @Override
    public void setRoot_Value_ID(UniqueId ref_Root_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Root_Value_ID.inequality( this.ref_Root_Value_ID)) {
            final UniqueId oldValue = this.ref_Root_Value_ID;
            this.ref_Root_Value_ID = ref_Root_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Root_Value_ID", oldValue, this.ref_Root_Value_ID));
        }
    }
    private UniqueId ref_Member_ID;
    @Override
    public void setMember_ID(UniqueId ref_Member_ID) throws XtumlException {
        checkLiving();
        if (ref_Member_ID.inequality( this.ref_Member_ID)) {
            final UniqueId oldValue = this.ref_Member_ID;
            this.ref_Member_ID = ref_Member_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Member_ID", oldValue, this.ref_Member_ID));
        }
    }
    @Override
    public UniqueId getMember_ID() throws XtumlException {
        checkLiving();
        return ref_Member_ID;
    }
    private UniqueId ref_DT_DT_ID;
    @Override
    public void setDT_DT_ID(UniqueId ref_DT_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_DT_ID.inequality( this.ref_DT_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_DT_ID;
            this.ref_DT_DT_ID = ref_DT_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_DT_ID", oldValue, this.ref_DT_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_DT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_DT_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private StructureMember R836_is_value_of_StructureMember_inst;
    @Override
    public void setR836_is_value_of_StructureMember( StructureMember inst ) {
        R836_is_value_of_StructureMember_inst = inst;
    }
    @Override
    public StructureMember R836_is_value_of_StructureMember() throws XtumlException {
        return R836_is_value_of_StructureMember_inst;
    }
    private Value R837_Value_inst;
    @Override
    public void setR837_Value( Value inst ) {
        R837_Value_inst = inst;
    }
    @Override
    public Value R837_Value() throws XtumlException {
        return R837_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MemberValueReference self() {
        return this;
    }

    @Override
    public MemberValueReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MEMBERVALUEREFERENCE;
    }

}

class EmptyMemberValueReference extends ModelInstance<MemberValueReference,Sql> implements MemberValueReference {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRoot_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRoot_Value_ID( UniqueId ref_Root_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setMember_ID( UniqueId ref_Member_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMember_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_DT_ID( UniqueId ref_DT_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_DT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public StructureMember R836_is_value_of_StructureMember() {
        return StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
    }
    @Override
    public Value R837_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return MemberValueReferenceImpl.KEY_LETTERS;
    }

    @Override
    public MemberValueReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MemberValueReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MemberValueReferenceImpl.EMPTY_MEMBERVALUEREFERENCE;
    }

}
