package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;
import io.ciera.tool.sql.ooaofooa.value.InstanceHandle;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class InstanceHandleImpl extends ModelInstance<InstanceHandle,Sql> implements InstanceHandle {

    public static final String KEY_LETTERS = "V_INT";
    public static final InstanceHandle EMPTY_INSTANCEHANDLE = new EmptyInstanceHandle();

    private Sql context;

    // constructors
    private InstanceHandleImpl( Sql context ) {
        this.context = context;
        ref_Var_ID = UniqueId.random();
        m_IsImplicitInFor = false;
        ref_Obj_ID = UniqueId.random();
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R818_refers_to_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private InstanceHandleImpl( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, boolean m_IsImplicitInFor, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Var_ID = ref_Var_ID;
        this.m_IsImplicitInFor = m_IsImplicitInFor;
        this.ref_Obj_ID = ref_Obj_ID;
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R818_refers_to_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static InstanceHandle create( Sql context ) throws XtumlException {
        InstanceHandle newInstanceHandle = new InstanceHandleImpl( context );
        if ( context.addInstance( newInstanceHandle ) ) {
            newInstanceHandle.getRunContext().addChange(new InstanceCreatedDelta(newInstanceHandle, KEY_LETTERS));
            return newInstanceHandle;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceHandle create( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, boolean m_IsImplicitInFor, UniqueId ref_Obj_ID ) throws XtumlException {
        InstanceHandle newInstanceHandle = new InstanceHandleImpl( context, instanceId, ref_Var_ID, m_IsImplicitInFor, ref_Obj_ID );
        if ( context.addInstance( newInstanceHandle ) ) {
            return newInstanceHandle;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    private boolean m_IsImplicitInFor;
    @Override
    public void setIsImplicitInFor(boolean m_IsImplicitInFor) throws XtumlException {
        checkLiving();
        if (m_IsImplicitInFor != this.m_IsImplicitInFor) {
            final boolean oldValue = this.m_IsImplicitInFor;
            this.m_IsImplicitInFor = m_IsImplicitInFor;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_IsImplicitInFor", oldValue, this.m_IsImplicitInFor));
        }
    }
    @Override
    public boolean getIsImplicitInFor() throws XtumlException {
        checkLiving();
        return m_IsImplicitInFor;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getVar_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private V_VAR R814_is_a_V_VAR_inst;
    @Override
    public void setR814_is_a_V_VAR( V_VAR inst ) {
        R814_is_a_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R814_is_a_V_VAR() throws XtumlException {
        return R814_is_a_V_VAR_inst;
    }
    private ModelClass R818_refers_to_ModelClass_inst;
    @Override
    public void setR818_refers_to_ModelClass( ModelClass inst ) {
        R818_refers_to_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R818_refers_to_ModelClass() throws XtumlException {
        return R818_refers_to_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceHandle self() {
        return this;
    }

    @Override
    public InstanceHandle oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCEHANDLE;
    }

}

class EmptyInstanceHandle extends ModelInstance<InstanceHandle,Sql> implements InstanceHandle {

    // attributes
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsImplicitInFor( boolean m_IsImplicitInFor ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsImplicitInFor() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public V_VAR R814_is_a_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public ModelClass R818_refers_to_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return InstanceHandleImpl.KEY_LETTERS;
    }

    @Override
    public InstanceHandle self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceHandle oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceHandleImpl.EMPTY_INSTANCEHANDLE;
    }

}
