package io.ciera.tool.sql.ooaofooa.usecase.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.usecase.Include;
import io.ciera.tool.sql.ooaofooa.usecase.UseCaseAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.impl.UseCaseAssociationImpl;


public class IncludeImpl extends ModelInstance<Include,Sql> implements Include {

    public static final String KEY_LETTERS = "UC_I";
    public static final Include EMPTY_INCLUDE = new EmptyInclude();

    private Sql context;

    // constructors
    private IncludeImpl( Sql context ) {
        this.context = context;
        ref_Assoc_ID = UniqueId.random();
        m_Descrip = "";
        R1210_is_a_UseCaseAssociation_inst = UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }

    private IncludeImpl( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Assoc_ID = ref_Assoc_ID;
        this.m_Descrip = m_Descrip;
        R1210_is_a_UseCaseAssociation_inst = UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }

    public static Include create( Sql context ) throws XtumlException {
        Include newInclude = new IncludeImpl( context );
        if ( context.addInstance( newInclude ) ) {
            newInclude.getRunContext().addChange(new InstanceCreatedDelta(newInclude, KEY_LETTERS));
            return newInclude;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Include create( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, String m_Descrip ) throws XtumlException {
        Include newInclude = new IncludeImpl( context, instanceId, ref_Assoc_ID, m_Descrip );
        if ( context.addInstance( newInclude ) ) {
            return newInclude;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Assoc_ID;
    @Override
    public UniqueId getAssoc_ID() throws XtumlException {
        checkLiving();
        return ref_Assoc_ID;
    }
    @Override
    public void setAssoc_ID(UniqueId ref_Assoc_ID) throws XtumlException {
        checkLiving();
        if (ref_Assoc_ID.inequality( this.ref_Assoc_ID)) {
            final UniqueId oldValue = this.ref_Assoc_ID;
            this.ref_Assoc_ID = ref_Assoc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Assoc_ID", oldValue, this.ref_Assoc_ID));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAssoc_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private UseCaseAssociation R1210_is_a_UseCaseAssociation_inst;
    @Override
    public void setR1210_is_a_UseCaseAssociation( UseCaseAssociation inst ) {
        R1210_is_a_UseCaseAssociation_inst = inst;
    }
    @Override
    public UseCaseAssociation R1210_is_a_UseCaseAssociation() throws XtumlException {
        return R1210_is_a_UseCaseAssociation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Include self() {
        return this;
    }

    @Override
    public Include oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INCLUDE;
    }

}

class EmptyInclude extends ModelInstance<Include,Sql> implements Include {

    // attributes
    public UniqueId getAssoc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAssoc_ID( UniqueId ref_Assoc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public UseCaseAssociation R1210_is_a_UseCaseAssociation() {
        return UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return IncludeImpl.KEY_LETTERS;
    }

    @Override
    public Include self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Include oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return IncludeImpl.EMPTY_INCLUDE;
    }

}
