package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.DerivedAttributeBody;
import io.ciera.tool.sql.ooaofooa.body.impl.DerivedAttributeBodyImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.BaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.DerivedBaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.BaseAttributeImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class DerivedBaseAttributeImpl extends ModelInstance<DerivedBaseAttribute,Sql> implements DerivedBaseAttribute {

    public static final String KEY_LETTERS = "O_DBATTR";
    public static final DerivedBaseAttribute EMPTY_DERIVEDBASEATTRIBUTE = new EmptyDerivedBaseAttribute();

    private Sql context;

    // constructors
    private DerivedBaseAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        R107_is_a_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
        R693_DerivedAttributeBody_inst = DerivedAttributeBodyImpl.EMPTY_DERIVEDATTRIBUTEBODY;
    }

    private DerivedBaseAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Dialect = m_Dialect;
        R107_is_a_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
        R693_DerivedAttributeBody_inst = DerivedAttributeBodyImpl.EMPTY_DERIVEDATTRIBUTEBODY;
    }

    public static DerivedBaseAttribute create( Sql context ) throws XtumlException {
        DerivedBaseAttribute newDerivedBaseAttribute = new DerivedBaseAttributeImpl( context );
        if ( context.addInstance( newDerivedBaseAttribute ) ) {
            newDerivedBaseAttribute.getRunContext().addChange(new InstanceCreatedDelta(newDerivedBaseAttribute, KEY_LETTERS));
            return newDerivedBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DerivedBaseAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect ) throws XtumlException {
        DerivedBaseAttribute newDerivedBaseAttribute = new DerivedBaseAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Dialect );
        if ( context.addInstance( newDerivedBaseAttribute ) ) {
            return newDerivedBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
            if ( !R693_DerivedAttributeBody().isEmpty() ) R693_DerivedAttributeBody().setAttr_ID( ref_Attr_ID );
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R693_DerivedAttributeBody().isEmpty() ) R693_DerivedAttributeBody().setObj_ID( ref_Obj_ID );
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    private ActionDialect m_Dialect;
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private BaseAttribute R107_is_a_BaseAttribute_inst;
    @Override
    public void setR107_is_a_BaseAttribute( BaseAttribute inst ) {
        R107_is_a_BaseAttribute_inst = inst;
    }
    @Override
    public BaseAttribute R107_is_a_BaseAttribute() throws XtumlException {
        return R107_is_a_BaseAttribute_inst;
    }
    private DerivedAttributeBody R693_DerivedAttributeBody_inst;
    @Override
    public void setR693_DerivedAttributeBody( DerivedAttributeBody inst ) {
        R693_DerivedAttributeBody_inst = inst;
    }
    @Override
    public DerivedAttributeBody R693_DerivedAttributeBody() throws XtumlException {
        return R693_DerivedAttributeBody_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DerivedBaseAttribute self() {
        return this;
    }

    @Override
    public DerivedBaseAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_DERIVEDBASEATTRIBUTE;
    }

}

class EmptyDerivedBaseAttribute extends ModelInstance<DerivedBaseAttribute,Sql> implements DerivedBaseAttribute {

    // attributes
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public BaseAttribute R107_is_a_BaseAttribute() {
        return BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }
    @Override
    public DerivedAttributeBody R693_DerivedAttributeBody() {
        return DerivedAttributeBodyImpl.EMPTY_DERIVEDATTRIBUTEBODY;
    }


    @Override
    public String getKeyLetters() {
        return DerivedBaseAttributeImpl.KEY_LETTERS;
    }

    @Override
    public DerivedBaseAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DerivedBaseAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
    }

}
