package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.NonLocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.PolymorphicEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.PolymorphicEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SEMEventImpl;


public class NonLocalEventImpl extends ModelInstance<NonLocalEvent,Sql> implements NonLocalEvent {

    public static final String KEY_LETTERS = "SM_NLEVT";
    public static final NonLocalEvent EMPTY_NONLOCALEVENT = new EmptyNonLocalEvent();

    private Sql context;

    // constructors
    private NonLocalEventImpl( Sql context ) {
        this.context = context;
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        ref_polySMevt_ID = UniqueId.random();
        ref_polySM_ID = UniqueId.random();
        m_polySMspd_IDdeprecated = UniqueId.random();
        m_Local_Meaning = "";
        m_Name = "";
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R527_is_defined_by_PolymorphicEvent_inst = PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
    }

    private NonLocalEventImpl( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, UniqueId ref_polySMevt_ID, UniqueId ref_polySM_ID, UniqueId m_polySMspd_IDdeprecated, String m_Local_Meaning, String m_Name ) {
        super(instanceId);
        this.context = context;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.ref_polySMevt_ID = ref_polySMevt_ID;
        this.ref_polySM_ID = ref_polySM_ID;
        this.m_polySMspd_IDdeprecated = m_polySMspd_IDdeprecated;
        this.m_Local_Meaning = m_Local_Meaning;
        this.m_Name = m_Name;
        R526_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R527_is_defined_by_PolymorphicEvent_inst = PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
    }

    public static NonLocalEvent create( Sql context ) throws XtumlException {
        NonLocalEvent newNonLocalEvent = new NonLocalEventImpl( context );
        if ( context.addInstance( newNonLocalEvent ) ) {
            newNonLocalEvent.getRunContext().addChange(new InstanceCreatedDelta(newNonLocalEvent, KEY_LETTERS));
            return newNonLocalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static NonLocalEvent create( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, UniqueId ref_polySMevt_ID, UniqueId ref_polySM_ID, UniqueId m_polySMspd_IDdeprecated, String m_Local_Meaning, String m_Name ) throws XtumlException {
        NonLocalEvent newNonLocalEvent = new NonLocalEventImpl( context, instanceId, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, ref_polySMevt_ID, ref_polySM_ID, m_polySMspd_IDdeprecated, m_Local_Meaning, m_Name );
        if ( context.addInstance( newNonLocalEvent ) ) {
            return newNonLocalEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    private UniqueId ref_polySMevt_ID;
    @Override
    public void setPolySMevt_ID(UniqueId ref_polySMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_polySMevt_ID.inequality( this.ref_polySMevt_ID)) {
            final UniqueId oldValue = this.ref_polySMevt_ID;
            this.ref_polySMevt_ID = ref_polySMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_polySMevt_ID", oldValue, this.ref_polySMevt_ID));
        }
    }
    @Override
    public UniqueId getPolySMevt_ID() throws XtumlException {
        checkLiving();
        return ref_polySMevt_ID;
    }
    private UniqueId ref_polySM_ID;
    @Override
    public void setPolySM_ID(UniqueId ref_polySM_ID) throws XtumlException {
        checkLiving();
        if (ref_polySM_ID.inequality( this.ref_polySM_ID)) {
            final UniqueId oldValue = this.ref_polySM_ID;
            this.ref_polySM_ID = ref_polySM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_polySM_ID", oldValue, this.ref_polySM_ID));
        }
    }
    @Override
    public UniqueId getPolySM_ID() throws XtumlException {
        checkLiving();
        return ref_polySM_ID;
    }
    private UniqueId m_polySMspd_IDdeprecated;
    @Override
    public void setPolySMspd_IDdeprecated(UniqueId m_polySMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_polySMspd_IDdeprecated.inequality( this.m_polySMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_polySMspd_IDdeprecated;
            this.m_polySMspd_IDdeprecated = m_polySMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_polySMspd_IDdeprecated", oldValue, this.m_polySMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getPolySMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_polySMspd_IDdeprecated;
    }
    private String m_Local_Meaning;
    @Override
    public void setLocal_Meaning(String m_Local_Meaning) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Local_Meaning, this.m_Local_Meaning)) {
            final String oldValue = this.m_Local_Meaning;
            this.m_Local_Meaning = m_Local_Meaning;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Local_Meaning", oldValue, this.m_Local_Meaning));
        }
    }
    @Override
    public String getLocal_Meaning() throws XtumlException {
        checkLiving();
        return m_Local_Meaning;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SEMEvent R526_is_a_SEMEvent_inst;
    @Override
    public void setR526_is_a_SEMEvent( SEMEvent inst ) {
        R526_is_a_SEMEvent_inst = inst;
    }
    @Override
    public SEMEvent R526_is_a_SEMEvent() throws XtumlException {
        return R526_is_a_SEMEvent_inst;
    }
    private PolymorphicEvent R527_is_defined_by_PolymorphicEvent_inst;
    @Override
    public void setR527_is_defined_by_PolymorphicEvent( PolymorphicEvent inst ) {
        R527_is_defined_by_PolymorphicEvent_inst = inst;
    }
    @Override
    public PolymorphicEvent R527_is_defined_by_PolymorphicEvent() throws XtumlException {
        return R527_is_defined_by_PolymorphicEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public NonLocalEvent self() {
        return this;
    }

    @Override
    public NonLocalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_NONLOCALEVENT;
    }

}

class EmptyNonLocalEvent extends ModelInstance<NonLocalEvent,Sql> implements NonLocalEvent {

    // attributes
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPolySMevt_ID( UniqueId ref_polySMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPolySMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPolySM_ID( UniqueId ref_polySM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPolySM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPolySMspd_IDdeprecated( UniqueId m_polySMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPolySMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLocal_Meaning( String m_Local_Meaning ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLocal_Meaning() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SEMEvent R526_is_a_SEMEvent() {
        return SEMEventImpl.EMPTY_SEMEVENT;
    }
    @Override
    public PolymorphicEvent R527_is_defined_by_PolymorphicEvent() {
        return PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
    }


    @Override
    public String getKeyLetters() {
        return NonLocalEventImpl.KEY_LETTERS;
    }

    @Override
    public NonLocalEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public NonLocalEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return NonLocalEventImpl.EMPTY_NONLOCALEVENT;
    }

}
