package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.ActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.Transition;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MealyStateMachineImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionImpl;


public class MealyActionHomeImpl extends ModelInstance<MealyActionHome,Sql> implements MealyActionHome {

    public static final String KEY_LETTERS = "SM_MEAH";
    public static final MealyActionHome EMPTY_MEALYACTIONHOME = new EmptyMealyActionHome();

    private Sql context;

    // constructors
    private MealyActionHomeImpl( Sql context ) {
        this.context = context;
        ref_Act_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_Trans_ID = UniqueId.random();
        R512_MealyStateMachine_inst = MealyStateMachineImpl.EMPTY_MEALYSTATEMACHINE;
        R512_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R513_is_a_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
    }

    private MealyActionHomeImpl( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID, UniqueId ref_Trans_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Act_ID = ref_Act_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_Trans_ID = ref_Trans_ID;
        R512_MealyStateMachine_inst = MealyStateMachineImpl.EMPTY_MEALYSTATEMACHINE;
        R512_Transition_inst = TransitionImpl.EMPTY_TRANSITION;
        R513_is_a_ActionHome_inst = ActionHomeImpl.EMPTY_ACTIONHOME;
    }

    public static MealyActionHome create( Sql context ) throws XtumlException {
        MealyActionHome newMealyActionHome = new MealyActionHomeImpl( context );
        if ( context.addInstance( newMealyActionHome ) ) {
            newMealyActionHome.getRunContext().addChange(new InstanceCreatedDelta(newMealyActionHome, KEY_LETTERS));
            return newMealyActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MealyActionHome create( Sql context, UniqueId instanceId, UniqueId ref_Act_ID, UniqueId ref_SM_ID, UniqueId ref_Trans_ID ) throws XtumlException {
        MealyActionHome newMealyActionHome = new MealyActionHomeImpl( context, instanceId, ref_Act_ID, ref_SM_ID, ref_Trans_ID );
        if ( context.addInstance( newMealyActionHome ) ) {
            return newMealyActionHome;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Act_ID;
    @Override
    public void setAct_ID(UniqueId ref_Act_ID) throws XtumlException {
        checkLiving();
        if (ref_Act_ID.inequality( this.ref_Act_ID)) {
            final UniqueId oldValue = this.ref_Act_ID;
            this.ref_Act_ID = ref_Act_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Act_ID", oldValue, this.ref_Act_ID));
        }
    }
    @Override
    public UniqueId getAct_ID() throws XtumlException {
        checkLiving();
        return ref_Act_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_Trans_ID;
    @Override
    public UniqueId getTrans_ID() throws XtumlException {
        checkLiving();
        return ref_Trans_ID;
    }
    @Override
    public void setTrans_ID(UniqueId ref_Trans_ID) throws XtumlException {
        checkLiving();
        if (ref_Trans_ID.inequality( this.ref_Trans_ID)) {
            final UniqueId oldValue = this.ref_Trans_ID;
            this.ref_Trans_ID = ref_Trans_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Trans_ID", oldValue, this.ref_Trans_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSM_ID(), getTrans_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getAct_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MealyStateMachine R512_MealyStateMachine_inst;
    @Override
    public void setR512_MealyStateMachine( MealyStateMachine inst ) {
        R512_MealyStateMachine_inst = inst;
    }
    @Override
    public MealyStateMachine R512_MealyStateMachine() throws XtumlException {
        return R512_MealyStateMachine_inst;
    }
    private Transition R512_Transition_inst;
    @Override
    public void setR512_Transition( Transition inst ) {
        R512_Transition_inst = inst;
    }
    @Override
    public Transition R512_Transition() throws XtumlException {
        return R512_Transition_inst;
    }
    private ActionHome R513_is_a_ActionHome_inst;
    @Override
    public void setR513_is_a_ActionHome( ActionHome inst ) {
        R513_is_a_ActionHome_inst = inst;
    }
    @Override
    public ActionHome R513_is_a_ActionHome() throws XtumlException {
        return R513_is_a_ActionHome_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MealyActionHome self() {
        return this;
    }

    @Override
    public MealyActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MEALYACTIONHOME;
    }

}

class EmptyMealyActionHome extends ModelInstance<MealyActionHome,Sql> implements MealyActionHome {

    // attributes
    public void setAct_ID( UniqueId ref_Act_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAct_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTrans_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTrans_ID( UniqueId ref_Trans_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MealyStateMachine R512_MealyStateMachine() {
        return MealyStateMachineImpl.EMPTY_MEALYSTATEMACHINE;
    }
    @Override
    public Transition R512_Transition() {
        return TransitionImpl.EMPTY_TRANSITION;
    }
    @Override
    public ActionHome R513_is_a_ActionHome() {
        return ActionHomeImpl.EMPTY_ACTIONHOME;
    }


    @Override
    public String getKeyLetters() {
        return MealyActionHomeImpl.KEY_LETTERS;
    }

    @Override
    public MealyActionHome self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MealyActionHome oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
    }

}
