package io.ciera.tool.sql.ooaofooa.selection.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.selection.ACT_SEL;
import io.ciera.tool.sql.ooaofooa.selection.SelectRelatedBy;
import io.ciera.tool.sql.ooaofooa.selection.impl.ACT_SELImpl;


public class SelectRelatedByImpl extends ModelInstance<SelectRelatedBy,Sql> implements SelectRelatedBy {

    public static final String KEY_LETTERS = "ACT_SR";
    public static final SelectRelatedBy EMPTY_SELECTRELATEDBY = new EmptySelectRelatedBy();

    private Sql context;

    // constructors
    private SelectRelatedByImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        R664_is_a_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
    }

    private SelectRelatedByImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        R664_is_a_ACT_SEL_inst = ACT_SELImpl.EMPTY_ACT_SEL;
    }

    public static SelectRelatedBy create( Sql context ) throws XtumlException {
        SelectRelatedBy newSelectRelatedBy = new SelectRelatedByImpl( context );
        if ( context.addInstance( newSelectRelatedBy ) ) {
            newSelectRelatedBy.getRunContext().addChange(new InstanceCreatedDelta(newSelectRelatedBy, KEY_LETTERS));
            return newSelectRelatedBy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectRelatedBy create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) throws XtumlException {
        SelectRelatedBy newSelectRelatedBy = new SelectRelatedByImpl( context, instanceId, ref_Statement_ID );
        if ( context.addInstance( newSelectRelatedBy ) ) {
            return newSelectRelatedBy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SEL R664_is_a_ACT_SEL_inst;
    @Override
    public void setR664_is_a_ACT_SEL( ACT_SEL inst ) {
        R664_is_a_ACT_SEL_inst = inst;
    }
    @Override
    public ACT_SEL R664_is_a_ACT_SEL() throws XtumlException {
        return R664_is_a_ACT_SEL_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectRelatedBy self() {
        return this;
    }

    @Override
    public SelectRelatedBy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTRELATEDBY;
    }

}

class EmptySelectRelatedBy extends ModelInstance<SelectRelatedBy,Sql> implements SelectRelatedBy {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SEL R664_is_a_ACT_SEL() {
        return ACT_SELImpl.EMPTY_ACT_SEL;
    }


    @Override
    public String getKeyLetters() {
        return SelectRelatedByImpl.KEY_LETTERS;
    }

    @Override
    public SelectRelatedBy self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectRelatedBy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectRelatedByImpl.EMPTY_SELECTRELATEDBY;
    }

}
