package io.ciera.tool.sql.ooaofooa.selection.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.selection.ACT_SEL;
import io.ciera.tool.sql.ooaofooa.selection.ChainLink;
import io.ciera.tool.sql.ooaofooa.selection.SelectRelatedBy;
import io.ciera.tool.sql.ooaofooa.selection.SelectRelatedWhere;
import io.ciera.tool.sql.ooaofooa.selection.impl.ChainLinkImpl;
import io.ciera.tool.sql.ooaofooa.selection.impl.SelectRelatedByImpl;
import io.ciera.tool.sql.ooaofooa.selection.impl.SelectRelatedWhereImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ACT_SELImpl extends ModelInstance<ACT_SEL,Sql> implements ACT_SEL {

    public static final String KEY_LETTERS = "ACT_SEL";
    public static final ACT_SEL EMPTY_ACT_SEL = new EmptyACT_SEL();

    private Sql context;

    // constructors
    private ACT_SELImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        m_is_implicit = false;
        m_cardinality = "";
        ref_Value_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R613_starting_point_Value_inst = ValueImpl.EMPTY_VALUE;
        R637_starts_with_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R638_selection_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R664_is_a_SelectRelatedBy_inst = SelectRelatedByImpl.EMPTY_SELECTRELATEDBY;
        R664_is_a_SelectRelatedWhere_inst = SelectRelatedWhereImpl.EMPTY_SELECTRELATEDWHERE;
    }

    private ACT_SELImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, String m_cardinality, UniqueId ref_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Var_ID = ref_Var_ID;
        this.m_is_implicit = m_is_implicit;
        this.m_cardinality = m_cardinality;
        this.ref_Value_ID = ref_Value_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R613_starting_point_Value_inst = ValueImpl.EMPTY_VALUE;
        R637_starts_with_ChainLink_inst = ChainLinkImpl.EMPTY_CHAINLINK;
        R638_selection_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R664_is_a_SelectRelatedBy_inst = SelectRelatedByImpl.EMPTY_SELECTRELATEDBY;
        R664_is_a_SelectRelatedWhere_inst = SelectRelatedWhereImpl.EMPTY_SELECTRELATEDWHERE;
    }

    public static ACT_SEL create( Sql context ) throws XtumlException {
        ACT_SEL newACT_SEL = new ACT_SELImpl( context );
        if ( context.addInstance( newACT_SEL ) ) {
            newACT_SEL.getRunContext().addChange(new InstanceCreatedDelta(newACT_SEL, KEY_LETTERS));
            return newACT_SEL;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ACT_SEL create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, String m_cardinality, UniqueId ref_Value_ID ) throws XtumlException {
        ACT_SEL newACT_SEL = new ACT_SELImpl( context, instanceId, ref_Statement_ID, ref_Var_ID, m_is_implicit, m_cardinality, ref_Value_ID );
        if ( context.addInstance( newACT_SEL ) ) {
            return newACT_SEL;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R664_is_a_SelectRelatedWhere().isEmpty() ) R664_is_a_SelectRelatedWhere().setStatement_ID( ref_Statement_ID );
            if ( !R637_starts_with_ChainLink().isEmpty() ) R637_starts_with_ChainLink().setStatement_ID( ref_Statement_ID );
            if ( !R664_is_a_SelectRelatedBy().isEmpty() ) R664_is_a_SelectRelatedBy().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    private boolean m_is_implicit;
    @Override
    public void setIs_implicit(boolean m_is_implicit) throws XtumlException {
        checkLiving();
        if (m_is_implicit != this.m_is_implicit) {
            final boolean oldValue = this.m_is_implicit;
            this.m_is_implicit = m_is_implicit;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_implicit", oldValue, this.m_is_implicit));
        }
    }
    @Override
    public boolean getIs_implicit() throws XtumlException {
        checkLiving();
        return m_is_implicit;
    }
    private String m_cardinality;
    @Override
    public void setCardinality(String m_cardinality) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_cardinality, this.m_cardinality)) {
            final String oldValue = this.m_cardinality;
            this.m_cardinality = m_cardinality;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_cardinality", oldValue, this.m_cardinality));
        }
    }
    @Override
    public String getCardinality() throws XtumlException {
        checkLiving();
        return m_cardinality;
    }
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R613_starting_point_Value_inst;
    @Override
    public void setR613_starting_point_Value( Value inst ) {
        R613_starting_point_Value_inst = inst;
    }
    @Override
    public Value R613_starting_point_Value() throws XtumlException {
        return R613_starting_point_Value_inst;
    }
    private ChainLink R637_starts_with_ChainLink_inst;
    @Override
    public void setR637_starts_with_ChainLink( ChainLink inst ) {
        R637_starts_with_ChainLink_inst = inst;
    }
    @Override
    public ChainLink R637_starts_with_ChainLink() throws XtumlException {
        return R637_starts_with_ChainLink_inst;
    }
    private V_VAR R638_selection_V_VAR_inst;
    @Override
    public void setR638_selection_V_VAR( V_VAR inst ) {
        R638_selection_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R638_selection_V_VAR() throws XtumlException {
        return R638_selection_V_VAR_inst;
    }
    private SelectRelatedBy R664_is_a_SelectRelatedBy_inst;
    @Override
    public void setR664_is_a_SelectRelatedBy( SelectRelatedBy inst ) {
        R664_is_a_SelectRelatedBy_inst = inst;
    }
    @Override
    public SelectRelatedBy R664_is_a_SelectRelatedBy() throws XtumlException {
        return R664_is_a_SelectRelatedBy_inst;
    }
    private SelectRelatedWhere R664_is_a_SelectRelatedWhere_inst;
    @Override
    public void setR664_is_a_SelectRelatedWhere( SelectRelatedWhere inst ) {
        R664_is_a_SelectRelatedWhere_inst = inst;
    }
    @Override
    public SelectRelatedWhere R664_is_a_SelectRelatedWhere() throws XtumlException {
        return R664_is_a_SelectRelatedWhere_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ACT_SEL self() {
        return this;
    }

    @Override
    public ACT_SEL oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ACT_SEL;
    }

}

class EmptyACT_SEL extends ModelInstance<ACT_SEL,Sql> implements ACT_SEL {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_implicit() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCardinality( String m_cardinality ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getCardinality() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R613_starting_point_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public ChainLink R637_starts_with_ChainLink() {
        return ChainLinkImpl.EMPTY_CHAINLINK;
    }
    @Override
    public V_VAR R638_selection_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public SelectRelatedBy R664_is_a_SelectRelatedBy() {
        return SelectRelatedByImpl.EMPTY_SELECTRELATEDBY;
    }
    @Override
    public SelectRelatedWhere R664_is_a_SelectRelatedWhere() {
        return SelectRelatedWhereImpl.EMPTY_SELECTRELATEDWHERE;
    }


    @Override
    public String getKeyLetters() {
        return ACT_SELImpl.KEY_LETTERS;
    }

    @Override
    public ACT_SEL self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ACT_SEL oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ACT_SELImpl.EMPTY_ACT_SEL;
    }

}
